package com.voxeet.sdk.models.v2;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

import java.util.HashMap;

/**
 * Represents the various types of message that the default chat implementation provides
 *
 * Those can be currently of the folowing type :
 *
 * - text
 */
@Annotate
public enum ChatMessageType {
    TEXT("text");

    private static boolean init = false;
    private static HashMap<String, ChatMessageType> map = new HashMap<>();
    private static ChatMessageType[] VALUES = new ChatMessageType[]{
            TEXT
    };

    private final String text;

    @NoDocumentation
    ChatMessageType(String text) {
        this.text = text;
    }

    @NoDocumentation
    public static ChatMessageType fromString(String text) {
        checkInit();
        return map.get(text);
    }

    private static void checkInit() {
        if (!init) {
            for (ChatMessageType type : VALUES) {
                map.put(type.text, type);
            }
            init = true;
        }
    }

    /**
     * Get the content of the chat message
     * @return the content message or null if it was not send with any content (it can be empty tho)
     */
    @Nullable
    public String text() {
        return text;
    }
}
