package com.voxeet.sdk.models.v2;

import android.support.annotation.NonNull;

import com.voxeet.sdk.core.services.chat.InternalChatMessage;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

import java.util.Date;

/**
 * Represents a simple message from the implementation by default given to developers
 */
@Annotate
public class ChatMessage {
    /**
     * Holds the message date
     */
    public Date date;

    /**
     * Message content
     */
    public String content;

    /**
     * Message type
     */
    public ChatMessageType type;

    private ChatMessage() {

    }

    /**
     * Constructor given to developers to send their own messages. A message consists of its date, the content and the actual type formatting its content.
     * @param date the Date to use, no check for past present or future
     * @param content the string representation of its content
     * @param type the type used to format this message
     */
    public ChatMessage(@NonNull Date date, @NonNull String content, @NonNull ChatMessageType type) {
        this.date = date;
        this.content = content;
        this.type = type;
    }

    @NoDocumentation
    public ChatMessage(@NonNull InternalChatMessage source) {
        date = source.time;
        content = source.content;
        type = ChatMessageType.fromString(source.type);
    }
}
