package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

/**
 * Event fired when a specific video should be played
 */
@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.VIDEO_PRESENTATION_PLAY)
public class VideoPresentationPlay extends Event {

    /**
     * Represent the key of the current video to manage
     */
    public String key;

    /**
     * The Conference that is managing this video
     */
    public String conferenceId;

    /**
     * The creator of the request
     */
    public String userId;

    /**
     * representation of the date
     */
    public long timestamp;

    @Override
    public String getType() {
        return EventNames.VIDEO_PRESENTATION_PLAY;
    }
}
