package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.Presence;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.USER_LOG_OUT)
public class UserLogoutEvent extends Event {

    public String userId;

    public Presence presence;

    @Override
    public String getType() {
        return EventNames.USER_LOG_OUT;
    }
}
