package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.Conference;
import com.voxeet.sdk.models.v1.ConferenceInfos;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.models.v1.UserProfile;

import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.USER_INVITED)
public class UserInvited extends Event {

    @JsonProperty("conference")
    public ConferenceInfos conferenceInfos;

    public List<UserProfile> participants;

    public Conference getAsConference() {
        Conference conference = new Conference();
        conference.setConferenceInfos(conferenceInfos);
        conference.setHasBeenCreated(true);
        conference.setDemo(false);
        conference.setConferenceType(conferenceInfos.getConferenceType());
        conference.setMeetingId(conferenceInfos.getMeetingId());
        conference.setConferenceId(conferenceInfos.getConferenceId());
        conference.setDescription(conferenceInfos.getDescription());
        conference.setLocation(conferenceInfos.getLocation());
        conference.setGuestAccess(false);
        conference.setOffline(false);
        conference.setRecorded(false);
        conference.setRecordingStatus(RecordingStatus.NOT_RECORDING);

        for (UserProfile profile : participants) {
            conference.getConferenceUsers().add(new ConferenceUser(profile));
        }

        return conference;
    }

    @Override
    public String getType() {
        return EventNames.USER_INVITED;
    }
}
