package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.OfferCandidate;
import com.voxeet.sdk.models.v1.OfferDescription;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromRestAPI;

import java.util.List;

@FromRestAPI
@Annotate
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.STOP_VIDEO)
public class StopVideoResponse extends Event {

    @JsonProperty("candidates")
    public List<OfferCandidate> candidates;

    @JsonProperty("description")
    public OfferDescription description;

    @JsonProperty("user_id")
    public String userId;

    @Override
    public String getType() {
        return EventNames.STOP_VIDEO;
    }
}
