package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromRestAPI;

import java.util.List;

@Annotate
@FromRestAPI
@JsonIgnoreProperties(ignoreUnknown = true)
public class SdkConferenceInvitation {

    @JsonProperty("voxeetIds")
    public List<String> voxeetIds;

    @JsonProperty("externalIds")
    public List<String> externalIds;

    public SdkConferenceInvitation(List<String> voxeetIds, List<String> externalIds) {
        this.voxeetIds = voxeetIds;
        this.externalIds = externalIds;
    }
}