package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.Conference;
import com.voxeet.sdk.models.v1.ConferenceInfos;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.models.v1.UserProfile;

import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.OWN_USER_INVITED)
public class OwnUserInvited extends Event {

    private String userId;

    @JsonProperty("conference")
    private ConferenceInfos conferenceInfos;

    public List<UserProfile> getGuests() {
        return guests;
    }

    public void setGuests(List<UserProfile> guests) {
        this.guests = guests;
    }

    private List<UserProfile> guests;

    public Conference getConference() {
        Conference conference = new Conference();
        conference.setConferenceInfos(conferenceInfos);
        conference.setHasBeenCreated(true);
        conference.setDemo(false);
        conference.setConferenceType(conferenceInfos.getConferenceType());
        conference.setMeetingId(conferenceInfos.getMeetingId());
        conference.setConferenceId(conferenceInfos.getConferenceId());
        conference.setDescription(conferenceInfos.getDescription());
        conference.setLocation(conferenceInfos.getLocation());
        conference.setGuestAccess(false);
        conference.setOffline(false);
        conference.setRecorded(false);
        conference.setRecordingStatus(RecordingStatus.NOT_RECORDING);

        for (UserProfile profile : guests) {
            conference.getConferenceUsers().add(new ConferenceUser(profile));
        }

        return conference;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ConferenceInfos getConferenceInfos() {
        return conferenceInfos;
    }

    public void setConferenceInfos(ConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Override
    public String getType() {
        return EventNames.OWN_USER_INVITED;
    }
}
