package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.authent.models.DeviceType;

import java.util.HashMap;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.DEVICE_TYPE)
public class JoinParameters extends Event {

    @JsonProperty("device_type")
    private DeviceType deviceType;

    @JsonProperty("sdp_version")
    private String sdpVersion;

    @JsonProperty("participantType")
    private String participantType;

    @JsonProperty("metadata")
    private HashMap<String, Object> metadata;

    @JsonProperty("sync")
    private boolean sync;

    public JoinParameters() {
        sync = true;
        metadata = new HashMap<>();
        //metadata.setStats(true);
    }

    public JoinParameters(DeviceType deviceType, boolean listenerMode) {
        this();
        this.deviceType = deviceType;

        this.sdpVersion = "SDP_V2";

        if (listenerMode)
            this.participantType = "LISTENER";
        else
            this.participantType = "USER";
    }

    public String getParticipantType() {
        return participantType;
    }

    public void setParticipantType(String participantType) {
        this.participantType = participantType;
    }

    public String getSdpVersion() {
        return sdpVersion;
    }

    public void setSdpVersion(String sdpVersion) {
        this.sdpVersion = sdpVersion;
    }

    public DeviceType getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    @Override
    public String getType() {
        return EventNames.DEVICE_TYPE;
    }

    public boolean isSync() {
        return sync;
    }
}
