package com.voxeet.sdk.exceptions;

import android.support.annotation.NonNull;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class ExceptionManager {

    private final static ReentrantLock lock = new ReentrantLock();
    private final static List<ExceptionListener> listeners = new ArrayList<>();

    private ExceptionManager() {

    }

    public static void register(@NonNull ExceptionListener listener) {
        lock();
        if (!listeners.contains(listener)) listeners.add(listener);
        unlock();
    }

    public static void unregister(@NonNull ExceptionListener listener) {
        lock();
        listeners.remove(listener);
        unlock();
    }

    public static void sendException(@NonNull Throwable throwable) {
        lock();
        for (ExceptionListener listener : listeners) {
            try {
                listener.onException(throwable);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        unlock();
    }

    private static void lock() {
        try {
            if (!lock.isLocked()) lock.lock();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void unlock() {
        try {
            if (lock.isLocked()) lock.unlock();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
