package com.voxeet.sdk.events.websocket;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.EventNames;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;

@InternalEvent
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.RENEGOCIATION_ENDED)
public class RenegociationEndedEvent extends Event {

    @JsonProperty("conference_id")
    private String conferenceId;

    private int offerSent;

    private int answerReceived;

    public int getOfferSent() {
        return offerSent;
    }

    public void setOfferSent(int offerSent) {
        this.offerSent = offerSent;
    }

    public int getAnswerReceived() {
        return answerReceived;
    }

    public void setAnswerReceived(int answerReceived) {
        this.answerReceived = answerReceived;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    @Override
    public String getType() {
        return EventNames.RENEGOCIATION_ENDED;
    }
}
