package com.voxeet.sdk.events.v2;

import android.support.annotation.NonNull;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Event fired when a new User is known for a Conference :
 * - invited
 * - joined (negotiated with the servers)
 *
 * Note : it does not mean the User is currently in the Conference
 */
@Annotate
@FromSDK
public class UserAddedEvent extends SuccessEvent {

    /**
     * The User holding this event
     */
    @NonNull
    public User user;

    /**
     * The underlying Conference instance
     */
    @NoDocumentation
    @NonNull
    public Conference conference;

    @NoDocumentation
    public UserAddedEvent(@NonNull Conference conference,
                          @NonNull User user) {
        this.user = user;
        this.conference = conference;
    }
}
