package com.voxeet.sdk.events.sdk;

import android.support.annotation.NonNull;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Event sent when a conference has been successfully joined
 * Embeds the instance of the Conference
 */
@Annotate
@FromSDK
public class ConferenceJoinedSuccessEvent extends SuccessEvent {

    /**
     * The Conference that has been joined
     * Fully usable :
     * - id
     * - alias
     */
    @NonNull
    public Conference conference;

    @NoDocumentation
    public ConferenceJoinedSuccessEvent(@NonNull Conference conference) {
        this.conference = conference;
    }

}
