package com.voxeet.sdk.events.sdk;

import android.support.annotation.NonNull;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;

/**
 * Event sent when a conference has been successfully created
 * Embeds the instance of the Conference
 */
@Annotate
@FromSDK
public class ConferenceCreationSuccess extends SuccessEvent {

    /**
     * The Conference that has been created
     * Fully usable :
     * - id
     * - alias
     */
    @NonNull
    public Conference conference;

    public ConferenceCreationSuccess(@NonNull Conference conference) {
        this.conference = conference;
    }
}
