package com.voxeet.sdk.core.services.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v2.ChatMessage;

import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class InternalChatMessage {
    public String title;
    public String content;
    public String type;
    public String avatarUrl;
    public Date time;
    public String name;
    public String ownerId;

    public InternalChatMessage(String messageType, @Nullable User user, @NonNull ChatMessage chatMessage) {
        title = messageType;
        content = chatMessage.content;
        type = chatMessage.type.text();
        time = chatMessage.date;

        if(null != user) {
            ownerId = user.getId();

            UserInfo userInfo = user.getUserInfo();
            if(null != userInfo) {
                avatarUrl = userInfo.getAvatarUrl();
                name = userInfo.getName();
            }
        }
    }
}
