package com.voxeet.sdk.core.services.builders;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.json.internal.MetadataHolder;
import com.voxeet.sdk.json.internal.ParamsHolder;
import com.voxeet.sdk.utils.Annotate;

/**
 * Hold and manage information to describe a conference to create
 */
@Annotate
public class ConferenceCreateInformation {
    private String conferenceAlias;
    private MetadataHolder metadataHolder;
    private ParamsHolder paramsHolder;

    private ConferenceCreateInformation() {

    }

    /**
     * Get the alias requested for the conference to create
     * @return the alias if set to a valid value or null
     */
    @Nullable
    public String getConferenceAlias() {
        return conferenceAlias;
    }

    /**
     * Get the various Metadata for the conference
     * @return the holder instance or null
     */
    @Nullable
    public MetadataHolder getMetadataHolder() {
        return metadataHolder;
    }

    /**
     * Get the various Parameters for the conference
     * @return the holder instance or null
     */
    @Nullable
    public ParamsHolder getParamsHolder() {
        return paramsHolder;
    }

    /**
     * Build a given conference
     */
    @Annotate
    public static class Builder {
        private ConferenceCreateInformation conferenceJoinInformation;

        /**
         * Create a new builder
         */
        public Builder() {
            conferenceJoinInformation = new ConferenceCreateInformation();
        }

        /**
         * Set the alias of the conference
         *
         * It is recommanded to be set with the developer's specific and unique name for the newly created conference
         * @param conferenceAlias the name of the conference, preferably non null
         * @return this builder instance
         */
        public Builder setConferenceAlias(@Nullable String conferenceAlias) {
            conferenceJoinInformation.conferenceAlias = conferenceAlias;
            return this;
        }

        /**
         * Add metadata into the conference to create
         * @param metadataHolder the reference to the metadata
         * @return this builder instance
         */
        public Builder setMetadataHolder(@Nullable MetadataHolder metadataHolder) {
            conferenceJoinInformation.metadataHolder = metadataHolder;
            return this;
        }

        /**
         * Add parameters into the conference to create
         *
         * @param paramsHolder the reference to the parameters
         * @return this builder instance
         */
        public Builder setParamsHolder(@Nullable ParamsHolder paramsHolder) {
            conferenceJoinInformation.paramsHolder = paramsHolder;
            return this;
        }

        /**
         * Constructs the instance of the creation
         * @return this builder instance
         */
        @NonNull
        public ConferenceCreateInformation build() {
            return conferenceJoinInformation;
        }

    }
}
