package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;

import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.chat.ChatMessageEvent;
import com.voxeet.sdk.core.services.chat.InternalChatMessage;
import com.voxeet.sdk.core.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.events.sdk.MessageReceived;
import com.voxeet.sdk.factories.EventsFactory;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v2.ChatMessage;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;

/**
 * Module to manage incoming well formatted ChatMessage and redistribute them accross the EventBus
 */
@Annotate
public class ChatService extends AbstractVoxeetService {

    @NoDocumentation
    public ChatService(@NonNull VoxeetSdk instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
    }

    @Subscribe
    public void onEvent(MessageReceived event) {
        InternalChatMessage chatMessage = EventsFactory.mapping(event.message, InternalChatMessage.class);

        ConferenceService conferenceService = VoxeetSdk.conference();
        if (null != conferenceService && null != chatMessage) {
            User user = conferenceService.findUserById(chatMessage.ownerId);
            //ChatMessage
            //User
            EventBus.getDefault().post(new ChatMessageEvent(user, new ChatMessage(chatMessage)));
        }
    }

    /**
     * Send a message to the various users
     *
     * @param conference the conference to send the message to
     * @param chatMessage the actual message
     * @return a promise to resolve
     */
    @NonNull
    public Promise<Boolean> sendMessage(@NonNull Conference conference, @NonNull ChatMessage chatMessage) {
        SessionService sessionService = VoxeetSdk.session();
        ConferenceService conferenceService = VoxeetSdk.conference();

        if(null != sessionService && null != conferenceService) {
            User user = new User(sessionService.getUserId(), sessionService.getUserInfo());
            InternalChatMessage internalChatMessage = new InternalChatMessage("Chat_Message", user, chatMessage);

            String json = EventsFactory.getJson(internalChatMessage);
            if(null != json) {
                return conferenceService.sendMessage(conference.getId(), json);
            }
        }

        return new Promise<Boolean>(new PromiseSolver<Boolean>() {
            @Override
            public void onCall(@NonNull Solver<Boolean> solver) {
                try {
                    throw new IllegalStateException("The sdk is not initialized");
                }catch (Exception e){
                    solver.reject(e);
                }
            }
        });
    }

}
