package com.voxeet.sdk.core.network.endpoints;

import com.voxeet.sdk.events.success.GetTokenUploadSuccessResult;
import com.voxeet.sdk.events.success.not_to_fire.LoginSuccessResponseEvent;
import com.voxeet.sdk.json.LoginEvent;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;

public interface IUserRService {

    @POST("users/login")
    Call<LoginSuccessResponseEvent> login(@Body LoginEvent loginEvent);

    @POST("v1/users/logout")
    Call<ResponseBody> logout(@Header("Authorization") String authorization);

    @GET("users/me/getUploadToken")
    @Headers("Content-Type: application/json")
    Call<GetTokenUploadSuccessResult> getUploadToken();
}