package voxeet.com.sdk.models.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;

import voxeet.com.sdk.models.abs.Meeting;
import voxeet.com.sdk.models.abs.MeetingEvent;
import voxeet.com.sdk.models.abs.UserProfile;

/**
 * Created by RomainB on 5/23/16.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class DefaultMeeting implements Meeting<DefaultUserProfile>, Comparable<DefaultMeeting> {

    private String meetingId;

    private String meetingType;

    @JsonProperty("readTimestamp")
    private long lastRead;

    private int nbSharedFile;

    private List<String> tags;

    @JsonProperty("notificationType")
    private String settings;

    private List<DefaultUserProfile> profiles;

    private List<DefaultMeetingEvent> events;

    @JsonProperty("conferenceInfo")
    private DefaultConferenceInfos conferenceInfos;

    public long getLastEventTime() {
        return lastEventTime;
    }

    public void setLastEventTime(long lastEventTime) {
        this.lastEventTime = lastEventTime;
    }

    private long lastEventTime;

    //TODO reminiscence from RealmObject isValid() - remove ?
    @Override
    public boolean isObjectValid() {
        return true;
    }

    @Override
    public List<MeetingEvent> getEvents() {
        List<? extends MeetingEvent> events = this.events;
        return (List<MeetingEvent>) events;
    }

    public void setEvents(List<DefaultMeetingEvent> events) {
        this.events = events;
    }

    @Override
    public DefaultConferenceInfos getConferenceInfos() {
        return conferenceInfos;
    }

    public void setConferenceInfos(DefaultConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Override
    public int getNbSharedFile() {
        return nbSharedFile;
    }

    public void setNbSharedFile(int nbSharedFile) {
        this.nbSharedFile = nbSharedFile;
    }

    @Override
    public List<String> getTags() {
        if (tags == null)
            return null;

        List<String> list = new ArrayList<>();
        list.addAll(tags);
        return list;
    }

    public void setTags(List<String> tags) {
        if (tags != null) {
            if (this.tags == null)
                this.tags = new ArrayList<>();
            else
                this.tags.clear();

            this.tags.addAll(tags);
        }
    }

    @Override
    public String getSettings() {
        return settings;
    }

    public void setSettings(String settings) {
        this.settings = settings;
    }

    @Override
    public String getMeetingId() {
        return meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    @Override
    public String getMeetingType() {
        return meetingType;
    }

    public void setMeetingType(String meetingType) {
        this.meetingType = meetingType;
    }

    @Override
    public long getLastRead() {
        return lastRead;
    }

    public void setLastRead(long lastRead) {
        this.lastRead = lastRead;
    }

    @Override
    public List<DefaultUserProfile> getProfiles() {
        return profiles;
    }

    public void setProfiles(List<DefaultUserProfile> profiles) {
        this.profiles = profiles;
    }

    @Override
    public MeetingEvent lastEvent(){ //reverse order
        try {
            return events.get(0);
        } catch (ArrayIndexOutOfBoundsException | NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public String title(){
        boolean isFirst = true;
        String names = "";
        for (DefaultUserProfile p : profiles) {
            if (isFirst) {
                names += p.getNickName();
                isFirst = false;
            } else {
                names += ", " + p.getNickName();
            }
        }
        return names;
    }

    @Override
    public String name() {
        String name = null;
        if (tags != null && tags.size() > 0) {
            name = "#" + Joiner.on(" ").skipNulls().join(tags);
        }
        return name;
    }

    @Override
    public void sort() {
        Collections.sort(events);

        lastEventTime = lastEvent().getTime();
    }

    @Override
    public MeetingEvent getLastMeetingEvent() {
        if (events.size() > 0)
            return events.get(events.size() - 1);
        return null;
    }

    @Override
    public int compareTo(DefaultMeeting another) {
        return new Date(another.lastEvent().getTime()).compareTo(new Date(lastEvent().getTime()));
    }
}
