package voxeet.com.sdk.models;

/**
 * Created by kevinleperf on 13/12/2017.
 */

public enum ConferenceUserStatus {
    IN_PROGRESS(0),
    ON_AIR(1),
    LATER(2),
    DECLINE(3),
    LEFT(4),
    MISSED(5),
    RESERVED(6),
    CONNECTING(7),
    INACTIVE(8),
    WARNING(9), //added by Kévin LE PERF - received during test with client
    ERROR(10); //added by Kévin LE PERF

    private final int value;

    ConferenceUserStatus(int value) {
        this.value = value;
    }

    public int value() {
        return value;
    }

    public static ConferenceUserStatus fromId(int value) {
        switch (value) {
            case 1:
                return ON_AIR;
            case 2:
                return LATER;
            case 3:
                return DECLINE;
            case 4:
                return LEFT;
            case 5:
                return MISSED;
            case 6:
                return RESERVED;
            case 7:
                return CONNECTING;
            case 8:
                return INACTIVE;
            case 9:
                return WARNING;
            case 10:
                return ERROR;
            default:
                return IN_PROGRESS;
        }
    }

    public static String toString(int value) {
        switch (value) {
            case 1:
                return "On Air";
            case 2:
                return "Later";
            case 3:
                return "Declined";
            case 4:
                return "Left";
            case 5:
                return "Missed";
            case 6:
                return "Reserved";
            case 7:
                return "Connecting";
            case 8:
                return "Inactive";
            default:
                return "Pending invite";
        }
    }
    }
