package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonProperty;

import voxeet.com.sdk.networking.DeviceType;

/**
 * Created by RomainB on 5/17/16.
 */
public class UserInfo {

    private String name;

    private String externalId;

    private String avatarUrl;

    @JsonProperty("deviceType")
    private DeviceType deviceType;

    @JsonProperty("deviceIdentifier")
    private String deviceIdentifier;

    @JsonProperty("devicePushToken")
    private String devicePushToken;

    public UserInfo() {
        this.name = "";

        this.externalId = "";

        this.avatarUrl = "";
    }

    public UserInfo(String name, String externalId, String avatarUrl) {
        this.name = name;

        this.externalId = externalId;

        this.avatarUrl = avatarUrl;
    }

    public DeviceType getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceIdentifier() {
        return deviceIdentifier;
    }

    public void setDeviceIdentifier(String deviceIdentifier) {
        this.deviceIdentifier = deviceIdentifier;
    }

    public String getDevicePushToken() {
        return devicePushToken;
    }

    public void setDevicePushToken(String devicePushToken) {
        this.devicePushToken = devicePushToken;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExternalId() {
        return externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getAvatarUrl() {
        return avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }
}
