package voxeet.com.sdk.core;

import android.app.Application;
import android.support.annotation.NonNull;

import voxeet.com.sdk.core.impl.ConferenceSdkService;
import voxeet.com.sdk.core.services.UserService;
import voxeet.com.sdk.json.UserInfo;

/**
 * Created by kevinleperf on 14/11/2017.
 */

public final class VoxeetSdk extends VoxeetSdkTemplate<ConferenceSdkService> {

    private static VoxeetSdkTemplate sCurrentInstance;

    protected static void setInstance(@NonNull VoxeetSdkTemplate sdk) {
        sCurrentInstance = sdk;
    }

    public static VoxeetSdkTemplate getInstance() {
        return sCurrentInstance;
    }

    /**
     * This function initializes the Voxeet SDK, the behavior of Voxeet SDK functions are
     * undetermined if this function is not called. It should be called as early as possible.
     *
     * @param application The application context
     * @param appId       the app id
     * @param password    the password
     * @param userInfo    the user info
     */
    public static synchronized void initialize(@NonNull final Application application,
                                                       @NonNull String appId,
                                                       @NonNull String password,
                                                       @NonNull final UserInfo userInfo) {

        VoxeetSdk sdk = new VoxeetSdk(application,
                appId,
                password,
                userInfo);

        VoxeetSdk.setInstance(sdk);
        VoxeetSdkFactory.validate(sdk);
    }

    private VoxeetSdk(@NonNull Application application_context, @NonNull String appId, @NonNull String password, @NonNull UserInfo userInfo) {
        super(application_context, appId, password, userInfo, false);
    }

    @Override
    public void logout() {
        getConferenceService().logout();
    }

    @Override
    public void onSdkPreinit() {
        //nothing here
    }

    @Override
    protected void initServices() {
        getServices().put(ConferenceSdkService.class, new ConferenceSdkService(this, DEFAULT_TIMEOUT_MS));
        getServices().put(UserService.class, new UserService(this));
    }

    public UserService getUserService() {
        return getServiceForKlass(UserService.class);
    }

    @Override
    protected String getTag() {
        return VoxeetSdk.class.getSimpleName();
    }
}
