/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.audio;

import java.util.UUID;
import voxeet.com.sdk.audio.AudioPosition;
import voxeet.com.sdk.audio.AudioSession;
import voxeet.com.sdk.audio.AudioUserState;

public class ActiveUserState
implements AudioUserState {
    private final AudioSession audioSession;
    private final UUID userId;
    private final long ssrc;
    private AudioPosition position;

    public ActiveUserState(AudioSession audioSession, UUID userId, long ssrc) {
        this.audioSession = audioSession;
        this.userId = userId;
        this.ssrc = ssrc;
        this.position = DEFAULT_POSITION;
    }

    @Override
    public void updatePosition(double angle, double distance) {
        this.position = new AudioPosition(angle, distance);
        this.audioSession.updatePosition(this.userId, this.position.angle(), this.position.distance());
    }

    @Override
    public void updateGain(float gain) {
        this.audioSession.updateGain(this.userId, gain);
    }

    @Override
    public AudioPosition position() {
        return this.position;
    }
}

