package voxeet.com.sdk.core.network.websocket;

/**
 * Created by kevinleperf on 22/01/2018.
 */

import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketState;

/**
 * The interface Socket listener which can be used when trying to connect to the server.
 */
public interface SocketListener {
    /**
     * On connect.
     */
    void onConnect(WebSocket webSocket);

    void onTextMessage(String message);

    void onError(WebSocketException exception);

    void onClose();

    void onStateChanged(WebSocketState newState);

    void onDisconnected();
}
