/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.audio;

import java.net.InetSocketAddress;

public class AudioSettings {
    private String stunHost;
    private int stunPort;
    private boolean noiseSuppressionEnabled;
    private boolean automaticGainControlEnabled;
    private boolean echoControlEnabled;
    private boolean typingDetectionEnabled;
    private int delayMs;

    public AudioSettings(String stunHost, int stunPort) {
        this.stunHost = stunHost;
        this.stunPort = stunPort;
        this.noiseSuppressionEnabled = true;
        this.automaticGainControlEnabled = true;
        this.echoControlEnabled = true;
        this.typingDetectionEnabled = false;
        this.delayMs = 0;
    }

    public AudioSettings(String stunHost, int stunPort, boolean ns, boolean ag, boolean ec, boolean td) {
        this.noiseSuppressionEnabled = ns;
        this.automaticGainControlEnabled = ag;
        this.echoControlEnabled = ec;
        this.typingDetectionEnabled = td;
    }

    public String stunHost() {
        InetSocketAddress address = new InetSocketAddress(this.stunHost, this.stunPort);
        return address.toString();
    }

    public boolean noiseSuppressionEnabled() {
        return this.noiseSuppressionEnabled;
    }

    public void setNoiseSuppressionEnabled(boolean enabled) {
        this.noiseSuppressionEnabled = enabled;
    }

    public boolean automaticGainControlEnabled() {
        return this.automaticGainControlEnabled;
    }

    public void setAutomaticGainControlEnabled(boolean enabled) {
        this.automaticGainControlEnabled = enabled;
    }

    public boolean echoControlEnabled() {
        return this.echoControlEnabled;
    }

    public void setEchoControlEnabled(boolean enabled) {
        this.echoControlEnabled = enabled;
    }

    public boolean typingDetectionEnabled() {
        return this.typingDetectionEnabled;
    }

    public void setTypingDetectionEnabled(boolean enabled) {
        this.typingDetectionEnabled = enabled;
    }

    public int delayMs() {
        return this.delayMs;
    }

    public void setDelayMs(int delayMs) {
        this.delayMs = delayMs;
    }
}

