/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.jwt;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

class KeyConverter {
    private static final String PRIVATE_KEY_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static final String PRIVATE_KEY_FOOTER = "-----END PRIVATE KEY-----";
    private static final String PUBLIC_KEY_HEADER = "-----BEGIN PUBLIC KEY-----";
    private static final String PUBLIC_KEY_FOOTER = "-----END PUBLIC KEY-----";
    private final KeyFactory keyFactory;

    public KeyConverter(String algorithm) {
        try {
            this.keyFactory = KeyFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public KeyConverter() {
        this("RSA");
    }

    public RSAPrivateKey privateKey(String key) throws InvalidKeySpecException {
        return (RSAPrivateKey)this.keyFactory.generatePrivate(this.privateKeySpec(this.sanitize(key)));
    }

    public RSAPublicKey publicKey(String key) throws InvalidKeySpecException {
        return (RSAPublicKey)this.keyFactory.generatePublic(this.publicKeySpec(this.sanitize(key)));
    }

    private String sanitize(String key) {
        return key.replaceAll(PRIVATE_KEY_HEADER, "").replaceAll(PRIVATE_KEY_FOOTER, "").replaceAll(PUBLIC_KEY_HEADER, "").replaceAll(PUBLIC_KEY_FOOTER, "").replaceAll("\\s+", "");
    }

    private byte[] decode(String key) {
        return Base64.getDecoder().decode(key);
    }

    private PKCS8EncodedKeySpec privateKeySpec(String key) {
        return new PKCS8EncodedKeySpec(this.decode(key));
    }

    private X509EncodedKeySpec publicKeySpec(String key) {
        return new X509EncodedKeySpec(this.decode(key));
    }
}

