/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.voice.TalkRequest;
import com.vonage.client.voice.TalkResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;

class StartTalkMethod
extends AbstractMethod<TalkRequest, TalkResponse> {
    private static final Log LOG = LogFactory.getLog(StartTalkMethod.class);
    private static final String PATH = "/calls/";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{JWTAuthMethod.class};
    private String uri;

    StartTalkMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(TalkRequest request) throws UnsupportedEncodingException {
        return RequestBuilder.put((String)(this.httpWrapper.getHttpConfig().getVersionedApiBaseUri("v1") + PATH + request.getUuid() + "/talk")).setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(request.toJson(), ContentType.APPLICATION_JSON));
    }

    @Override
    public TalkResponse parseResponse(HttpResponse response) throws IOException {
        String json = new BasicResponseHandler().handleResponse(response);
        return TalkResponse.fromJson(json);
    }
}

