/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.voice.CallDirection;
import com.vonage.client.voice.CallStatus;
import com.vonage.client.voice.Endpoint;
import com.vonage.client.voice.PhoneEndpoint;
import java.io.IOException;
import java.util.Date;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"_links"}, ignoreUnknown=true)
public class CallInfo {
    private Endpoint to;
    private Endpoint from;
    private String conversationUuid = null;
    private CallDirection direction = null;
    private Integer duration = null;
    private Date endTime = null;
    private String network = null;
    private String price = null;
    private String rate = null;
    private Date startTime = null;
    private CallStatus status = null;
    private String uuid = null;

    public CallInfo() {
    }

    public CallInfo(String to, String from) {
        this(new PhoneEndpoint(to), new PhoneEndpoint(from));
    }

    public CallInfo(Endpoint to, Endpoint from) {
        this.to = to;
        this.from = from;
    }

    public Endpoint getTo() {
        return this.to;
    }

    public void setTo(Endpoint to) {
        this.to = to;
    }

    public Endpoint getFrom() {
        return this.from;
    }

    public void setFrom(Endpoint from) {
        this.from = from;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @JsonProperty(value="conversation_uuid")
    public String getConversationUuid() {
        return this.conversationUuid;
    }

    public void setConversationUuid(String conversationUuid) {
        this.conversationUuid = conversationUuid;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @JsonProperty(value="end_time")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getPrice() {
        return this.price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getRate() {
        return this.rate;
    }

    public void setRate(String rate) {
        this.rate = rate;
    }

    @JsonProperty(value="start_time")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public CallStatus getStatus() {
        return this.status;
    }

    public void setStatus(CallStatus status) {
        this.status = status;
    }

    public CallDirection getDirection() {
        return this.direction;
    }

    public void setDirection(CallDirection direction) {
        this.direction = direction;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public String toString() {
        return "<CallInfo " + "ID: " + this.getUuid() + ", " + "From: " + this.getFrom().toLog() + ", " + "To: " + this.getTo().toLog() + ", " + "Status: " + (Object)((Object)this.getStatus()) + ">";
    }

    public static CallInfo fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            return (CallInfo)mapper.readValue(json, CallInfo.class);
        }
        catch (IOException jpe) {
            throw new VonageUnexpectedException("Failed to produce json from CallInfo object.", jpe);
        }
    }
}

