/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CallDirection {
    OUTBOUND,
    INBOUND,
    UNKNOWN;

    private static final Map<String, CallDirection> CALL_DIRECTION_INDEX;

    @JsonValue
    public String toString() {
        return this.name().toLowerCase();
    }

    @JsonCreator
    public static CallDirection fromString(String name) {
        CallDirection foundCallDirection = CALL_DIRECTION_INDEX.get(name.toUpperCase());
        return foundCallDirection != null ? foundCallDirection : UNKNOWN;
    }

    static {
        CALL_DIRECTION_INDEX = new HashMap<String, CallDirection>();
        for (CallDirection callDirection : CallDirection.values()) {
            CALL_DIRECTION_INDEX.put(callDirection.name(), callDirection);
        }
    }
}

