/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.account;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageBadRequestException;
import com.vonage.client.account.SettingsRequest;
import com.vonage.client.account.SettingsResponse;
import com.vonage.client.auth.TokenAuthMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.util.EntityUtils;

class SettingsMethod
extends AbstractMethod<SettingsRequest, SettingsResponse> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/account/settings";

    SettingsMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(SettingsRequest request) throws UnsupportedEncodingException {
        return RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getRestBaseUri() + PATH)).addParameter("moCallBackUrl", request.getIncomingSmsUrl()).addParameter("drCallBackUrl", request.getDeliveryReceiptUrl());
    }

    @Override
    public SettingsResponse parseResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new VonageBadRequestException(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return SettingsResponse.fromJson(new BasicResponseHandler().handleResponse(response));
    }
}

