/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.Range;

public final class SubCharSequence
extends BasedSequenceImpl {
    private final char[] baseChars;
    private final SubCharSequence base;
    private final int startOffset;
    private final int endOffset;

    @Override
    public SubCharSequence getBase() {
        return this.base;
    }

    public char[] getBaseChars() {
        return this.baseChars;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    public SubCharSequence(CharSequence charSequence) {
        this(charSequence.toString());
    }

    public SubCharSequence(String text) {
        this(text.toCharArray());
    }

    public SubCharSequence(char[] chars) {
        int iMax = chars.length;
        for (int i = 0; i < iMax; ++i) {
            if (chars[i] != '\u0000') continue;
            chars[i] = 65533;
        }
        this.baseChars = chars;
        this.startOffset = 0;
        this.endOffset = this.baseChars.length;
        this.base = this;
    }

    private SubCharSequence(SubCharSequence baseSeq, int start, int end) {
        this.base = baseSeq;
        this.baseChars = baseSeq.baseChars;
        this.startOffset = this.base.startOffset + start;
        this.endOffset = this.base.startOffset + end;
    }

    public SubCharSequence(CharSequence charSequence, int start, int end) {
        this(charSequence.toString(), start, end);
    }

    public SubCharSequence(String text, int start, int end) {
        this(text.toCharArray(), start, end);
    }

    public SubCharSequence(char[] chars, int start, int end) {
        if (start == 0 && end == chars.length) {
            this.baseChars = chars;
            this.startOffset = 0;
            this.endOffset = chars.length;
            this.base = this;
        } else if (start >= 0 && end <= chars.length) {
            this.base = new SubCharSequence(chars);
            this.baseChars = this.base.baseChars;
            this.startOffset = this.base.startOffset + start;
            this.endOffset = this.base.startOffset + end;
        } else {
            if (start < 0) {
                throw new StringIndexOutOfBoundsException("beginIndex:" + start + " must be at least 0");
            }
            if (end < 0) {
                throw new StringIndexOutOfBoundsException("endIndex:" + end + " must be at least 0");
            }
            if (end < start) {
                throw new StringIndexOutOfBoundsException("endIndex:" + end + " must not be less than beginIndex:" + start);
            }
            throw new StringIndexOutOfBoundsException("endIndex:" + end + " must not be greater than length");
        }
    }

    @Override
    public int length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public Range getSourceRange() {
        return new Range(this.startOffset, this.endOffset);
    }

    @Override
    public int getIndexOffset(int index) {
        if (index >= 0 || index <= this.endOffset - this.startOffset) {
            return this.startOffset + index;
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + index + " out of range: 0, " + this.length());
    }

    @Override
    public char charAt(int index) {
        if (index >= 0 || index < this.endOffset - this.startOffset) {
            return this.baseChars[index + this.startOffset];
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + index + " out of range: 0, " + this.length());
    }

    @Override
    public SubCharSequence subSequence(int start, int end) {
        if (start >= 0 && end <= this.endOffset - this.startOffset) {
            return this.base.baseSubSequence(this.startOffset + start, this.startOffset + end);
        }
        if (start < 0 || this.startOffset + start > this.endOffset) {
            throw new StringIndexOutOfBoundsException("SubCharSequence index: " + start + " out of range: 0, " + this.length());
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + end + " out of range: 0, " + this.length());
    }

    @Override
    public SubCharSequence baseSubSequence(int start, int end) {
        if (start >= 0 && end <= this.baseChars.length) {
            return start == this.startOffset && end == this.endOffset ? this : (this.base != this ? this.base.baseSubSequence(start, end) : new SubCharSequence(this.base, start, end));
        }
        if (start < 0 || start > this.base.length()) {
            throw new StringIndexOutOfBoundsException("SubCharSequence index: " + start + " out of range: 0, " + this.length());
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + end + " out of range: 0, " + this.length());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSequence && this.toString().equals(obj.toString());
    }

    @Override
    public String toString() {
        return String.valueOf(this.baseChars, this.startOffset, this.endOffset - this.startOffset);
    }
}

