/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.BlockContent;
import com.vladsch.flexmark.ast.Content;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import com.vladsch.flexmark.util.sequence.SubSequence;
import java.util.List;

public abstract class ContentNode
extends Node
implements Content {
    protected List<BasedSequence> lineSegments = BasedSequence.EMPTY_LIST;

    public ContentNode() {
    }

    public ContentNode(BasedSequence chars) {
        super(chars);
    }

    public ContentNode(BasedSequence chars, List<BasedSequence> lineSegments) {
        super(chars);
        this.lineSegments = lineSegments;
    }

    public ContentNode(List<BasedSequence> lineSegments) {
        this(ContentNode.getSpanningChars(lineSegments), lineSegments);
    }

    public ContentNode(BlockContent blockContent) {
        this(blockContent.getSpanningChars(), blockContent.getLines());
    }

    public void setContent(BasedSequence chars, List<BasedSequence> lineSegments) {
        this.setChars(chars);
        this.lineSegments = lineSegments;
    }

    public void setContent(List<BasedSequence> lineSegments) {
        this.lineSegments = lineSegments;
        this.setChars(this.getSpanningChars());
    }

    public void setContent(BlockContent blockContent) {
        this.setChars(blockContent.getSpanningChars());
        this.lineSegments = blockContent.getLines();
    }

    @Override
    public BasedSequence getSpanningChars() {
        return ContentNode.getSpanningChars(this.lineSegments);
    }

    private static BasedSequence getSpanningChars(List<BasedSequence> lineSegments) {
        return lineSegments.size() > 0 ? new SubSequence(lineSegments.get(0).getBase(), lineSegments.get(0).getStartOffset(), lineSegments.get(lineSegments.size() - 1).getEndOffset()) : BasedSequence.NULL;
    }

    @Override
    public int getLineCount() {
        return this.lineSegments.size();
    }

    @Override
    public BasedSequence getLineChars(int index) {
        return this.lineSegments.get(index);
    }

    @Override
    public List<BasedSequence> getContentLines() {
        return this.getContentLines(0, this.lineSegments.size());
    }

    @Override
    public List<BasedSequence> getContentLines(int startLine, int endLine) {
        return this.lineSegments.subList(startLine, endLine);
    }

    @Override
    public BasedSequence getContentChars() {
        return SegmentedSequence.of(this.lineSegments, this.getChars().subSequence(this.getChars().length()));
    }

    @Override
    public BasedSequence getContentChars(int startLine, int endLine) {
        return SegmentedSequence.of(this.getContentLines(startLine, endLine), this.getChars());
    }

    public void setContentLines(List<BasedSequence> contentLines) {
        this.lineSegments = contentLines;
    }
}

