/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.mappers.CharMapper;
import com.vladsch.flexmark.util.mappers.LowerCaseMapper;
import com.vladsch.flexmark.util.mappers.UpperCaseMapper;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import com.vladsch.flexmark.util.sequence.MappedSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.SubSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class BasedSequenceImpl
implements BasedSequence {
    private static int[] EMPTY_INDICES = new int[0];
    private static final Map<Character, String> visibleSpacesMap;

    public static BasedSequence firstNonNull(BasedSequence ... sequences) {
        for (BasedSequence sequence : sequences) {
            if (sequence == null || sequence == NULL) continue;
            return sequence;
        }
        return NULL;
    }

    static boolean isVisibleWhitespace(char c) {
        return visibleSpacesMap.containsKey(Character.valueOf(c));
    }

    @Override
    public BasedSequence endSequence(int start, int end) {
        int length = this.length();
        int useStart = length - start;
        int useEnd = length - end;
        if (useStart < 0) {
            useStart = 0;
        } else if (useStart > length) {
            useStart = length;
        }
        if (useEnd < 0) {
            useEnd = 0;
        } else if (useEnd > length) {
            useEnd = length;
        }
        if (useStart > useEnd) {
            useStart = useEnd;
        }
        if (useStart == 0 && useEnd == length) {
            return this;
        }
        return this.subSequence(useStart, useEnd);
    }

    @Override
    public BasedSequence endSequence(int start) {
        int length = this.length();
        if (start <= 0) {
            return this.subSequence(length, length);
        }
        if (start >= length) {
            return this;
        }
        return this.subSequence(length - start, length);
    }

    @Override
    public char endCharAt(int index) {
        if (index < 0 || index >= this.length()) {
            return '\u0000';
        }
        return this.charAt(this.length() - index);
    }

    @Override
    public BasedSequence midSequence(int start, int end) {
        int useEnd;
        int length = this.length();
        int useStart = start < 0 ? length + start : start;
        int n = useEnd = end < 0 ? length + end : end;
        if (useStart < 0) {
            useStart = 0;
        } else if (useStart > length) {
            useStart = length;
        }
        if (useEnd < 0) {
            useEnd = 0;
        } else if (useEnd > length) {
            useEnd = length;
        }
        if (useStart > useEnd) {
            useStart = useEnd;
        }
        if (useStart == 0 && useEnd == length) {
            return this;
        }
        return this.subSequence(useStart, useEnd);
    }

    @Override
    public BasedSequence midSequence(int start) {
        int useStart;
        int length = this.length();
        int n = useStart = start < 0 ? length + start : start;
        if (useStart <= 0) {
            return this;
        }
        if (useStart >= length) {
            return this.subSequence(length, length);
        }
        return this.subSequence(useStart, length);
    }

    @Override
    public char midCharAt(int index) {
        if (index < -this.length() || index >= this.length()) {
            return '\u0000';
        }
        return this.charAt(index < 0 ? this.length() + index : index);
    }

    @Override
    public char lastChar() {
        return this.isEmpty() ? (char)'\u0000' : this.charAt(this.length() - 1);
    }

    @Override
    public char firstChar() {
        return this.isEmpty() ? (char)'\u0000' : this.charAt(0);
    }

    @Override
    public int indexOf(CharSequence s) {
        return this.indexOf(s, 0, this.length());
    }

    @Override
    public int indexOf(CharSequence s, int fromIndex) {
        return this.indexOf(s, fromIndex, this.length());
    }

    @Override
    public int indexOf(CharSequence s, int fromIndex, int endIndex) {
        int sMax = s.length();
        if (sMax == 0) {
            return fromIndex;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        if (fromIndex < endIndex) {
            char firstChar = s.charAt(0);
            int pos = fromIndex;
            while ((pos = this.indexOf(firstChar, pos)) >= 0 && pos + sMax <= endIndex) {
                if (this.matchChars(s, pos)) {
                    return pos;
                }
                if (++pos + sMax < endIndex) continue;
            }
        }
        return -1;
    }

    @Override
    public int indexOf(char c) {
        return this.indexOf(c, 0, this.length());
    }

    @Override
    public int indexOfAny(char c1, char c2) {
        return this.indexOfAny(c1, c2, 0, this.length());
    }

    @Override
    public int indexOfAny(char c1, char c2, char c3) {
        return this.indexOfAny(c1, c2, c3, 0, this.length());
    }

    @Override
    public int indexOfAny(CharSequence s) {
        return this.indexOfAny(s, 0, this.length());
    }

    @Override
    public int indexOf(char c, int fromIndex) {
        return this.indexOf(c, fromIndex, this.length());
    }

    @Override
    public int indexOfAny(char c1, char c2, int fromIndex) {
        return this.indexOfAny(c1, c2, fromIndex, this.length());
    }

    @Override
    public int indexOfAny(char c1, char c2, char c3, int fromIndex) {
        return this.indexOfAny(c1, c2, c3, fromIndex, this.length());
    }

    @Override
    public int indexOfAny(CharSequence s, int index) {
        return this.indexOfAny(s, index, this.length());
    }

    @Override
    public int indexOf(char c, int fromIndex, int endIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            if (this.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOfAny(char c1, char c2, int fromIndex, int endIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (c != c1 && c != c2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOfAny(char c1, char c2, char c3, int fromIndex, int endIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (c != c1 && c != c2 && c != c3) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOfAny(CharSequence s, int fromIndex, int endIndex) {
        switch (s.length()) {
            case 0: {
                return fromIndex;
            }
            case 1: {
                return this.indexOf(s.charAt(0), fromIndex, endIndex);
            }
            case 2: {
                return this.indexOfAny(s.charAt(0), s.charAt(1), fromIndex, endIndex);
            }
            case 3: {
                return this.indexOfAny(s.charAt(0), s.charAt(1), s.charAt(2), fromIndex, endIndex);
            }
        }
        BasedSequence sequence = BasedSequenceImpl.of(s);
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (sequence.indexOf(c) == -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOfNot(char c) {
        return this.indexOfNot(c, 0, this.length());
    }

    @Override
    public int indexOfAnyNot(char c1, char c2) {
        return this.indexOfAnyNot(c1, c2, 0, this.length());
    }

    @Override
    public int indexOfAnyNot(char c1, char c2, char c3) {
        return this.indexOfAnyNot(c1, c2, c3, 0, this.length());
    }

    @Override
    public int indexOfAnyNot(CharSequence s) {
        return this.indexOfAnyNot(s, 0, this.length());
    }

    @Override
    public int indexOfNot(char c, int fromIndex) {
        return this.indexOfNot(c, fromIndex, this.length());
    }

    @Override
    public int indexOfAnyNot(char c1, char c2, int fromIndex) {
        return this.indexOfAnyNot(c1, c2, fromIndex, this.length());
    }

    @Override
    public int indexOfAnyNot(char c1, char c2, char c3, int fromIndex) {
        return this.indexOfAnyNot(c1, c2, c3, fromIndex, this.length());
    }

    @Override
    public int indexOfAnyNot(CharSequence s, int fromIndex) {
        return this.indexOfAnyNot(s, fromIndex, this.length());
    }

    @Override
    public int indexOfNot(char c, int fromIndex, int endIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            if (this.charAt(i) == c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOfAnyNot(char c1, char c2, int fromIndex, int endIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (c == c1 || c == c2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOfAnyNot(char c1, char c2, char c3, int fromIndex, int endIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (c == c1 || c == c2 || c == c3) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOfAnyNot(CharSequence s, int fromIndex, int endIndex) {
        switch (s.length()) {
            case 0: {
                return fromIndex;
            }
            case 1: {
                return this.indexOfNot(s.charAt(0), fromIndex, endIndex);
            }
            case 2: {
                return this.indexOfAnyNot(s.charAt(0), s.charAt(1), fromIndex, endIndex);
            }
            case 3: {
                return this.indexOfAnyNot(s.charAt(0), s.charAt(1), s.charAt(2), fromIndex, endIndex);
            }
        }
        BasedSequence sequence = BasedSequenceImpl.of(s);
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (sequence.indexOf(c) != -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(CharSequence s) {
        return this.lastIndexOf(s, 0, this.length());
    }

    @Override
    public int lastIndexOf(CharSequence s, int fromIndex) {
        return this.lastIndexOf(s, 0, fromIndex);
    }

    @Override
    public int lastIndexOf(CharSequence s, int startIndex, int fromIndex) {
        int sMax = s.length();
        if (sMax == 0) {
            return startIndex;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (fromIndex >= this.length()) {
            fromIndex = this.length();
        }
        if (startIndex < fromIndex) {
            int pos = fromIndex;
            char lastChar = s.charAt(sMax - 1);
            while ((pos = this.lastIndexOf(lastChar, pos)) + 1 >= startIndex + sMax) {
                if (this.matchCharsReversed(s, pos)) {
                    return pos + 1 - sMax;
                }
                if (--pos + 1 >= startIndex + sMax) continue;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(char c) {
        return this.lastIndexOf(c, 0, this.length());
    }

    @Override
    public int lastIndexOfAny(char c1, char c2) {
        return this.lastIndexOfAny(c1, c2, 0, this.length());
    }

    @Override
    public int lastIndexOfAny(char c1, char c2, char c3) {
        return this.lastIndexOfAny(c1, c2, c3, 0, this.length());
    }

    @Override
    public int lastIndexOfAny(CharSequence s) {
        return this.indexOfAny(s, 0, this.length());
    }

    @Override
    public int lastIndexOf(char c, int fromIndex) {
        return this.lastIndexOf(c, 0, fromIndex);
    }

    @Override
    public int lastIndexOfAny(char c1, char c2, int fromIndex) {
        return this.lastIndexOfAny(c1, c2, 0, fromIndex);
    }

    @Override
    public int lastIndexOfAny(char c1, char c2, char c3, int fromIndex) {
        return this.lastIndexOfAny(c1, c2, c3, 0, fromIndex);
    }

    @Override
    public int lastIndexOfAny(CharSequence s, int fromIndex) {
        return this.lastIndexOfAny(s, 0, fromIndex);
    }

    @Override
    public int lastIndexOf(char c, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            if (this.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfAny(char c1, char c2, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (c != c1 && c != c2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfAny(char c1, char c2, char c3, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (c != c1 && c != c2 && c != c3) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfAny(CharSequence s, int startIndex, int fromIndex) {
        switch (s.length()) {
            case 0: {
                return startIndex;
            }
            case 1: {
                return this.lastIndexOf(s.charAt(0), startIndex, fromIndex);
            }
            case 2: {
                return this.lastIndexOfAny(s.charAt(0), s.charAt(1), startIndex, fromIndex);
            }
            case 3: {
                return this.lastIndexOfAny(s.charAt(0), s.charAt(1), s.charAt(2), startIndex, fromIndex);
            }
        }
        BasedSequence sequence = BasedSequenceImpl.of(s);
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (sequence.indexOf(c) == -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfNot(char c) {
        return this.lastIndexOfNot(c, 0, this.length());
    }

    @Override
    public int lastIndexOfAnyNot(char c1, char c2) {
        return this.lastIndexOfAnyNot(c1, c2, 0, this.length());
    }

    @Override
    public int lastIndexOfAnyNot(char c1, char c2, char c3) {
        return this.lastIndexOfAnyNot(c1, c2, c3, 0, this.length());
    }

    @Override
    public int lastIndexOfAnyNot(CharSequence s) {
        return this.indexOfAnyNot(s, 0, this.length());
    }

    @Override
    public int lastIndexOfNot(char c, int fromIndex) {
        return this.lastIndexOfNot(c, 0, fromIndex);
    }

    @Override
    public int lastIndexOfAnyNot(char c1, char c2, int fromIndex) {
        return this.lastIndexOfAnyNot(c1, c2, 0, fromIndex);
    }

    @Override
    public int lastIndexOfAnyNot(char c1, char c2, char c3, int fromIndex) {
        return this.lastIndexOfAnyNot(c1, c2, c3, 0, fromIndex);
    }

    @Override
    public int lastIndexOfAnyNot(CharSequence s, int fromIndex) {
        return this.lastIndexOfAnyNot(s, 0, fromIndex);
    }

    @Override
    public int lastIndexOfNot(char c, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            if (this.charAt(i) == c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfAnyNot(char c1, char c2, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (c == c1 || c == c2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfAnyNot(char c1, char c2, char c3, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (c == c1 || c == c2 || c == c3) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfAnyNot(CharSequence s, int startIndex, int fromIndex) {
        switch (s.length()) {
            case 0: {
                return startIndex;
            }
            case 1: {
                return this.lastIndexOfNot(s.charAt(0), startIndex, fromIndex);
            }
            case 2: {
                return this.lastIndexOfAnyNot(s.charAt(0), s.charAt(1), startIndex, fromIndex);
            }
            case 3: {
                return this.lastIndexOfAnyNot(s.charAt(0), s.charAt(1), s.charAt(2), startIndex, fromIndex);
            }
        }
        BasedSequence sequence = BasedSequenceImpl.of(s);
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (sequence.indexOf(c) != -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int startOfDelimitedBy(CharSequence s, int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.length()) {
            index = this.length();
        }
        int offset = this.lastIndexOf(s, index - 1);
        return offset == -1 ? 0 : offset + 1;
    }

    @Override
    public int startOfDelimitedByAny(CharSequence s, int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.length()) {
            index = this.length();
        }
        int offset = this.lastIndexOfAny(s, index - 1);
        return offset == -1 ? 0 : offset + 1;
    }

    @Override
    public int startOfDelimitedByAnyNot(CharSequence s, int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.length()) {
            index = this.length();
        }
        int offset = this.lastIndexOfAnyNot(s, index - 1);
        return offset == -1 ? 0 : offset + 1;
    }

    @Override
    public int endOfDelimitedBy(CharSequence s, int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.length()) {
            index = this.length();
        }
        int offset = this.indexOf(s, index);
        return offset == -1 ? this.length() : offset;
    }

    @Override
    public int endOfDelimitedByAny(CharSequence s, int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.length()) {
            index = this.length();
        }
        int offset = this.indexOfAny(s, index);
        return offset == -1 ? this.length() : offset;
    }

    @Override
    public int endOfDelimitedByAnyNot(CharSequence s, int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.length()) {
            index = this.length();
        }
        int offset = this.indexOfAnyNot(s, index);
        return offset == -1 ? this.length() : offset;
    }

    @Override
    public int endOfLine(int index) {
        return this.endOfDelimitedBy(EOL, index);
    }

    @Override
    public int endOfLineAnyEOL(int index) {
        return this.endOfDelimitedByAny("\r\n", index);
    }

    @Override
    public int startOfLine(int index) {
        return this.startOfDelimitedBy(EOL, index);
    }

    @Override
    public int startOfLineAnyEOL(int index) {
        return this.startOfDelimitedByAny("\r\n", index);
    }

    @Override
    public BasedSequence lineAt(int index) {
        return this.subSequence(this.startOfLine(index), this.endOfLine(index));
    }

    @Override
    public BasedSequence lineAtAnyEOL(int index) {
        return this.subSequence(this.startOfLineAnyEOL(index), this.endOfLineAnyEOL(index));
    }

    @Override
    public int countLeading(char c) {
        return this.countChars(c, 0, this.length());
    }

    @Override
    public int countLeadingNot(char c) {
        return this.countNotChars(c, 0, this.length());
    }

    @Override
    public int countLeading(char c, int fromIndex) {
        return this.countChars(c, fromIndex, this.length());
    }

    @Override
    public int countLeadingNot(char c, int fromIndex) {
        return this.countNotChars(c, fromIndex, this.length());
    }

    @Override
    public int countLeading(char c, int fromIndex, int endIndex) {
        return this.countChars(c, fromIndex, endIndex);
    }

    @Override
    public int countLeadingNot(char c, int fromIndex, int endIndex) {
        return this.countNotChars(c, fromIndex, endIndex);
    }

    @Override
    public int countTrailing(char c) {
        return this.countCharsReversed(c, 0, this.length());
    }

    @Override
    public int countTrailingNot(char c) {
        return this.countNotCharsReversed(c, 0, this.length());
    }

    @Override
    public int countTrailing(char c, int fromIndex) {
        return this.countCharsReversed(c, 0, fromIndex);
    }

    @Override
    public int countTrailingNot(char c, int fromIndex) {
        return this.countNotCharsReversed(c, 0, fromIndex);
    }

    @Override
    public int countTrailing(char c, int startIndex, int fromIndex) {
        return this.countCharsReversed(c, startIndex, fromIndex);
    }

    @Override
    public int countTrailingNot(char c, int startIndex, int fromIndex) {
        return this.countNotCharsReversed(c, startIndex, fromIndex);
    }

    @Override
    public int countChars(char c) {
        return this.countChars(c, 0, this.length());
    }

    @Override
    public int countNotChars(char c) {
        return this.countNotChars(c, 0, this.length());
    }

    @Override
    public int countChars(char c, int fromIndex) {
        return this.countChars(c, fromIndex, this.length());
    }

    @Override
    public int countNotChars(char c, int fromIndex) {
        return this.countNotChars(c, fromIndex, this.length());
    }

    @Override
    public int countCharsReversed(char c) {
        return this.countCharsReversed(c, 0, this.length());
    }

    @Override
    public int countNotCharsReversed(char c) {
        return this.countNotCharsReversed(c, 0, this.length());
    }

    @Override
    public int countCharsReversed(char c, int fromIndex) {
        return this.countCharsReversed(c, 0, fromIndex);
    }

    @Override
    public int countNotCharsReversed(char c, int fromIndex) {
        return this.countNotCharsReversed(c, 0, fromIndex);
    }

    @Override
    public int countChars(char c, int fromIndex, int endIndex) {
        int index;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        if (fromIndex > endIndex) {
            fromIndex = endIndex;
        }
        return (index = this.indexOfNot(c, fromIndex, endIndex)) == -1 ? endIndex - fromIndex : index - fromIndex;
    }

    @Override
    public int countCharsReversed(char c, int startIndex, int fromIndex) {
        int index;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (fromIndex > this.length()) {
            fromIndex = this.length();
        }
        if (startIndex > fromIndex) {
            startIndex = fromIndex;
        }
        return (index = this.lastIndexOfNot(c, startIndex, fromIndex)) == -1 ? fromIndex - startIndex : fromIndex - index - 1;
    }

    @Override
    public int countNotChars(char c, int fromIndex, int endIndex) {
        int index;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        if (fromIndex > endIndex) {
            fromIndex = endIndex;
        }
        return (index = this.indexOf(c, fromIndex, endIndex)) == -1 ? endIndex - fromIndex : index - fromIndex;
    }

    @Override
    public int countNotCharsReversed(char c, int startIndex, int fromIndex) {
        int index;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (fromIndex > this.length()) {
            fromIndex = this.length();
        }
        if (startIndex > fromIndex) {
            startIndex = fromIndex;
        }
        return (index = this.lastIndexOf(c, startIndex, fromIndex)) == -1 ? fromIndex - startIndex : fromIndex - index - 1;
    }

    @Override
    public int countLeading(CharSequence chars) {
        return this.countChars(chars, 0, this.length());
    }

    @Override
    public int countLeadingNot(CharSequence chars) {
        return this.countNotChars(chars, 0, this.length());
    }

    @Override
    public int countLeading(CharSequence chars, int fromIndex) {
        return this.countChars(chars, fromIndex, this.length());
    }

    @Override
    public int countLeadingNot(CharSequence chars, int fromIndex) {
        return this.countNotChars(chars, fromIndex, this.length());
    }

    @Override
    public int countLeading(CharSequence chars, int fromIndex, int endIndex) {
        return this.countChars(chars, fromIndex, endIndex);
    }

    @Override
    public int countLeadingNot(CharSequence chars, int fromIndex, int endIndex) {
        return this.countNotChars(chars, fromIndex, endIndex);
    }

    @Override
    public int countTrailing(CharSequence chars) {
        return this.countCharsReversed(chars, 0, this.length());
    }

    @Override
    public int countTrailingNot(CharSequence chars) {
        return this.countNotCharsReversed(chars, 0, this.length());
    }

    @Override
    public int countTrailing(CharSequence chars, int fromIndex) {
        return this.countCharsReversed(chars, 0, fromIndex);
    }

    @Override
    public int countTrailingNot(CharSequence chars, int fromIndex) {
        return this.countNotCharsReversed(chars, 0, fromIndex);
    }

    @Override
    public int countTrailing(CharSequence chars, int startIndex, int fromIndex) {
        return this.countCharsReversed(chars, startIndex, fromIndex);
    }

    @Override
    public int countTrailingNot(CharSequence chars, int startIndex, int fromIndex) {
        return this.countNotCharsReversed(chars, startIndex, fromIndex);
    }

    @Override
    public int countChars(CharSequence chars) {
        return this.countChars(chars, 0, this.length());
    }

    @Override
    public int countNotChars(CharSequence chars) {
        return this.countNotChars(chars, 0, this.length());
    }

    @Override
    public int countChars(CharSequence chars, int fromIndex) {
        return this.countChars(chars, fromIndex, this.length());
    }

    @Override
    public int countNotChars(CharSequence chars, int fromIndex) {
        return this.countNotChars(chars, fromIndex, this.length());
    }

    @Override
    public int countCharsReversed(CharSequence chars) {
        return this.countCharsReversed(chars, 0, this.length());
    }

    @Override
    public int countNotCharsReversed(CharSequence chars) {
        return this.countNotCharsReversed(chars, 0, this.length());
    }

    @Override
    public int countCharsReversed(CharSequence chars, int fromIndex) {
        return this.countCharsReversed(chars, 0, fromIndex);
    }

    @Override
    public int countNotCharsReversed(CharSequence chars, int fromIndex) {
        return this.countNotCharsReversed(chars, 0, fromIndex);
    }

    @Override
    public int countChars(CharSequence chars, int fromIndex, int endIndex) {
        int index;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        if (fromIndex > endIndex) {
            fromIndex = endIndex;
        }
        return (index = this.indexOfAnyNot(chars, fromIndex, endIndex)) == -1 ? endIndex - fromIndex : index - fromIndex;
    }

    @Override
    public int countCharsReversed(CharSequence chars, int startIndex, int fromIndex) {
        int index;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (fromIndex > this.length()) {
            fromIndex = this.length();
        }
        if (startIndex > fromIndex) {
            startIndex = fromIndex;
        }
        return (index = this.lastIndexOfAnyNot(chars, startIndex, fromIndex)) == -1 ? fromIndex - startIndex : fromIndex - index - 1;
    }

    @Override
    public int countNotChars(CharSequence chars, int fromIndex, int endIndex) {
        int index;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        if (fromIndex > endIndex) {
            fromIndex = endIndex;
        }
        return (index = this.indexOfAny(chars, fromIndex, endIndex)) == -1 ? endIndex - fromIndex : index - fromIndex;
    }

    @Override
    public int countNotCharsReversed(CharSequence chars, int startIndex, int fromIndex) {
        int index;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (fromIndex > this.length()) {
            fromIndex = this.length();
        }
        if (startIndex > fromIndex) {
            startIndex = fromIndex;
        }
        return (index = this.lastIndexOfAny(chars, startIndex, fromIndex)) == -1 ? fromIndex - startIndex : fromIndex - index - 1;
    }

    @Override
    public BasedSequence trimStart(CharSequence chars) {
        int trim = this.countChars(chars, 0, this.length());
        return trim > 0 ? this.subSequence(trim, this.length()) : this;
    }

    @Override
    public BasedSequence trimmedStart(CharSequence chars) {
        int trim = this.countChars(chars, 0, this.length());
        return trim > 0 ? this.subSequence(0, trim) : BasedSequence.NULL;
    }

    @Override
    public BasedSequence trimEnd(CharSequence chars) {
        int trim = this.countCharsReversed(chars, 0, this.length());
        return trim > 0 ? this.subSequence(0, this.length() - trim) : this;
    }

    @Override
    public BasedSequence trimmedEnd(CharSequence chars) {
        int trim = this.countCharsReversed(chars, 0, this.length());
        return trim > 0 ? this.subSequence(this.length() - trim) : BasedSequence.NULL;
    }

    @Override
    public BasedSequence trim(CharSequence chars) {
        int trimEnd;
        int trimStart = this.countChars(chars, 0, this.length());
        int trimmed = trimStart + (trimEnd = this.countCharsReversed(chars, 0, this.length()));
        return trimmed > 0 ? (trimmed >= this.length() ? this.subSequence(0, 0) : this.subSequence(trimStart, this.length() - trimEnd)) : this;
    }

    @Override
    public BasedSequence trimStart() {
        int trim = this.countChars(" \t\r\n", 0, this.length());
        return trim > 0 ? this.subSequence(trim, this.length()) : this;
    }

    @Override
    public BasedSequence trimmedStart() {
        int trim = this.countChars(" \t\r\n", 0, this.length());
        return trim > 0 ? this.subSequence(0, trim) : BasedSequence.NULL;
    }

    @Override
    public BasedSequence trimEnd() {
        int trim = this.countCharsReversed(" \t\r\n", 0, this.length());
        return trim > 0 ? this.subSequence(0, this.length() - trim) : this;
    }

    @Override
    public BasedSequence trimmedEnd() {
        int trim = this.countCharsReversed(" \t\r\n", 0, this.length());
        return trim > 0 ? this.subSequence(this.length() - trim) : BasedSequence.NULL;
    }

    @Override
    public int eolLength() {
        return this.countCharsReversed("\r\n", 0, this.length());
    }

    @Override
    public BasedSequence trimEOL() {
        int trim = this.eolLength();
        return trim > 0 ? this.subSequence(0, this.length() - trim) : this;
    }

    @Override
    public BasedSequence trimmedEOL() {
        int trim = this.eolLength();
        return trim > 0 ? this.subSequence(this.length() - trim) : BasedSequence.NULL;
    }

    @Override
    public BasedSequence trim() {
        int trimStart = this.countChars(" \t\r\n", 0, this.length());
        if (trimStart == this.length()) {
            return this.subSequence(trimStart, trimStart);
        }
        int trimEnd = this.countCharsReversed(" \t\r\n", 0, this.length());
        return trimStart > 0 || trimEnd > 0 ? this.subSequence(trimStart, this.length() - trimEnd) : this;
    }

    @Override
    public BasedSequence ifNull(BasedSequence other) {
        return this.isNull() ? other : this;
    }

    @Override
    public BasedSequence ifNullEmptyAfter(BasedSequence other) {
        return this.isNull() ? other.subSequence(other.length(), other.length()) : this;
    }

    @Override
    public BasedSequence ifNullEmptyBefore(BasedSequence other) {
        return this.isNull() ? other.subSequence(0, 0) : this;
    }

    @Override
    public BasedSequence nullIfEmpty() {
        return this.isEmpty() ? BasedSequence.NULL : this;
    }

    @Override
    public BasedSequence nullIfBlank() {
        return this.isBlank() ? BasedSequence.NULL : this;
    }

    @Override
    public BasedSequence nullIf(boolean condition) {
        return condition ? BasedSequence.NULL : this;
    }

    @Override
    public BasedSequence nullIf(CharSequence ... matches) {
        for (CharSequence match : matches) {
            if (!this.matches(match)) continue;
            return BasedSequence.NULL;
        }
        return this;
    }

    @Override
    public BasedSequence nullIfNot(CharSequence ... matches) {
        for (CharSequence match : matches) {
            if (!this.matches(match)) continue;
            return this;
        }
        return BasedSequence.NULL;
    }

    @Override
    public BasedSequence nullIfStartsWith(CharSequence ... matches) {
        for (CharSequence match : matches) {
            if (!this.startsWith(match)) continue;
            return BasedSequence.NULL;
        }
        return this;
    }

    @Override
    public BasedSequence nullIfStartsWithNot(CharSequence ... matches) {
        for (CharSequence match : matches) {
            if (!this.startsWith(match)) continue;
            return this;
        }
        return BasedSequence.NULL;
    }

    @Override
    public BasedSequence nullIfEndsWith(CharSequence ... matches) {
        for (CharSequence match : matches) {
            if (!this.endsWith(match)) continue;
            return BasedSequence.NULL;
        }
        return this;
    }

    @Override
    public BasedSequence nullIfEndsWithNot(CharSequence ... matches) {
        for (CharSequence match : matches) {
            if (!this.endsWith(match)) continue;
            return this;
        }
        return BasedSequence.NULL;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public boolean isBlank() {
        int trim = this.countChars(" \t\r\n", 0, this.length());
        return trim == this.length();
    }

    @Override
    public boolean isNull() {
        return this == BasedSequence.NULL;
    }

    @Override
    public boolean isNotNull() {
        return this != BasedSequence.NULL;
    }

    @Override
    public boolean endsWith(CharSequence suffix) {
        return this.length() > 0 && this.matchCharsReversed(suffix, this.length() - 1);
    }

    @Override
    public boolean startsWith(CharSequence prefix) {
        return this.length() > 0 && this.matchChars(prefix, 0);
    }

    @Override
    public BasedSequence removeSuffix(CharSequence suffix) {
        return !this.endsWith(suffix) ? this : this.subSequence(0, this.length() - suffix.length());
    }

    @Override
    public BasedSequence removePrefix(CharSequence prefix) {
        return !this.startsWith(prefix) ? this : this.subSequence(prefix.length(), this.length());
    }

    @Override
    public BasedSequence removeProperSuffix(CharSequence suffix) {
        return this.length() <= suffix.length() || !this.endsWith(suffix) ? this : this.subSequence(0, this.length() - suffix.length());
    }

    @Override
    public BasedSequence removeProperPrefix(CharSequence prefix) {
        return this.length() <= prefix.length() || !this.startsWith(prefix) ? this : this.subSequence(prefix.length(), this.length());
    }

    @Override
    public MappedSequence toLowerCase() {
        return this.toMapped(LowerCaseMapper.INSTANCE);
    }

    @Override
    public MappedSequence toUpperCase() {
        return this.toMapped(UpperCaseMapper.INSTANCE);
    }

    @Override
    public MappedSequence toLowerCase(Locale locale) {
        return this.toMapped(new LowerCaseMapper(locale));
    }

    @Override
    public MappedSequence toUpperCase(Locale locale) {
        return this.toMapped(new UpperCaseMapper(locale));
    }

    @Override
    public final MappedSequence toMapped(CharMapper mapper) {
        return MappedSequence.of(mapper, this);
    }

    @Override
    public boolean matches(CharSequence chars) {
        return chars.length() == this.length() && this.matchChars(chars);
    }

    @Override
    public boolean matchChars(CharSequence chars) {
        return this.matchChars(chars, 0);
    }

    @Override
    public boolean matchChars(CharSequence chars, int startIndex) {
        int iMax = chars.length();
        if (iMax > this.length() - startIndex) {
            return false;
        }
        for (int i = 0; i < iMax; ++i) {
            if (chars.charAt(i) == this.charAt(i + startIndex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchCharsReversed(CharSequence chars, int endIndex) {
        return endIndex + 1 >= chars.length() && this.matchChars(chars, endIndex + 1 - chars.length());
    }

    @Override
    public BasedSequence subSequence(Range range) {
        return this.subSequence(range.getStart(), range.getEnd());
    }

    @Override
    public BasedSequence subSequence(int start) {
        return this.subSequence(start, this.length());
    }

    @Override
    public BasedSequence trimTailBlankLines() {
        int iMax;
        int lastEOL = iMax = this.length();
        int i = iMax;
        while (i-- > 0) {
            char c = this.charAt(i);
            if (c == '\n') {
                lastEOL = i + 1;
                continue;
            }
            if (lastEOL != iMax && (c == ' ' || c == '\t')) continue;
            break;
        }
        if (i < 0) {
            return this.subSequence(0, 0);
        }
        if (lastEOL != iMax) {
            return this.subSequence(0, lastEOL);
        }
        return this;
    }

    @Override
    public BasedSequence trimLeadBlankLines() {
        int i;
        int iMax = this.length();
        int lastEOL = 0;
        for (i = 0; i < iMax; ++i) {
            char c = this.charAt(i);
            if (c == '\n') {
                lastEOL = i + 1;
                continue;
            }
            if (c != ' ' && c != '\t') break;
        }
        if (i == iMax) {
            return this.subSequence(iMax, iMax);
        }
        if (lastEOL != 0) {
            return this.subSequence(lastEOL);
        }
        return this;
    }

    @Override
    public String toString() {
        int iMax = this.length();
        StringBuilder sb = new StringBuilder(iMax);
        for (int i = 0; i < iMax; ++i) {
            sb.append(this.charAt(i));
        }
        return sb.toString();
    }

    @Override
    public String unescape() {
        return Escaping.unescapeString(this);
    }

    @Override
    public BasedSequence unescape(ReplacedTextMapper textMapper) {
        return Escaping.unescape(this, textMapper);
    }

    @Override
    public String normalizeEOL() {
        return Escaping.normalizeEOL(this.toString());
    }

    @Override
    public BasedSequence normalizeEOL(ReplacedTextMapper textMapper) {
        return Escaping.normalizeEOL(this, textMapper);
    }

    @Override
    public String normalizeEndWithEOL() {
        return Escaping.normalizeEndWithEOL(this.toString());
    }

    @Override
    public BasedSequence normalizeEndWithEOL(ReplacedTextMapper textMapper) {
        return Escaping.normalizeEndWithEOL(this, textMapper);
    }

    @Override
    public String toVisibleWhitespaceString() {
        StringBuilder sb = new StringBuilder();
        int iMax = this.length();
        for (int i = 0; i < iMax; ++i) {
            char c = this.charAt(i);
            String s = visibleSpacesMap.get(Character.valueOf(c));
            if (s != null) {
                sb.append(s);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public boolean isContinuedBy(BasedSequence other) {
        return other.length() > 0 && this.length() > 0 && other.getBase() == this.getBase() && other.getStartOffset() == this.getEndOffset();
    }

    @Override
    public boolean isContinuationOf(BasedSequence other) {
        return other.length() > 0 && this.length() > 0 && other.getBase() == this.getBase() && other.getEndOffset() == this.getStartOffset();
    }

    @Override
    public BasedSequence spliceAtEnd(BasedSequence other) {
        assert (this.isContinuedBy(other)) : "sequence[" + this.getStartOffset() + ", " + this.getEndOffset() + "] is not continued by other[" + other.getStartOffset() + ", " + other.getEndOffset() + "]";
        return this.baseSubSequence(this.getStartOffset(), other.getEndOffset());
    }

    @Override
    public boolean containsAllOf(BasedSequence other) {
        return this.getBase() == other.getBase() && other.getStartOffset() >= this.getStartOffset() && other.getEndOffset() <= this.getEndOffset();
    }

    @Override
    public boolean containsSomeOf(BasedSequence other) {
        return this.getBase() == other.getBase() && this.getStartOffset() < other.getEndOffset() && this.getEndOffset() > other.getStartOffset();
    }

    @Override
    public BasedSequence intersect(BasedSequence other) {
        if (this.getBase() != other.getBase()) {
            return SubSequence.NULL;
        }
        if (other.getEndOffset() <= this.getStartOffset()) {
            return this.subSequence(0, 0);
        }
        if (other.getStartOffset() >= this.getEndOffset()) {
            return this.subSequence(this.length(), this.length());
        }
        return this.baseSubSequence(Utils.max(this.getStartOffset(), other.getStartOffset()), Utils.min(this.getEndOffset(), other.getEndOffset()));
    }

    @Override
    public BasedSequence prefixOf(BasedSequence other) {
        if (this.getBase() != other.getBase()) {
            return SubSequence.NULL;
        }
        if (other.getStartOffset() <= this.getStartOffset()) {
            return this.subSequence(0, 0);
        }
        if (other.getStartOffset() >= this.getEndOffset()) {
            return this.subSequence(0, 0);
        }
        return this.baseSubSequence(this.getStartOffset(), other.getStartOffset());
    }

    @Override
    public BasedSequence suffixOf(BasedSequence other) {
        if (this.getBase() != other.getBase()) {
            return SubSequence.NULL;
        }
        if (other.getStartOffset() <= this.getStartOffset()) {
            return this.subSequence(this.length(), this.length());
        }
        if (other.getStartOffset() >= this.getEndOffset()) {
            return this.subSequence(this.length(), this.length());
        }
        return this.baseSubSequence(other.getEndOffset(), this.getEndOffset());
    }

    @Override
    public BasedSequence[] split(char delimiter) {
        return this.split(delimiter, 0);
    }

    @Override
    public BasedSequence[] split(char delimiter, int limit) {
        return this.split(delimiter, limit, 0);
    }

    @Override
    public BasedSequence[] split(char delimiter, int limit, int flags) {
        return this.split(delimiter, limit, flags, " \t\r\n");
    }

    @Override
    public BasedSequence[] split(CharSequence delimiter) {
        return this.split(delimiter, 0);
    }

    @Override
    public BasedSequence[] split(CharSequence delimiter, int limit) {
        return this.split(delimiter, limit, 0);
    }

    @Override
    public BasedSequence[] split(CharSequence delimiter, int limit, int flags) {
        return this.split(delimiter, limit, flags, " \t\r\n");
    }

    @Override
    public BasedSequence[] split(char delimiter, int limit, int flags, String trimChars) {
        if (trimChars == null) {
            trimChars = " \t\r\n";
        }
        if (limit < 1) {
            limit = Integer.MAX_VALUE;
        }
        boolean includeDelimiterParts = (flags & 8) != 0;
        int includeDelimiter = !includeDelimiterParts && (flags & 1) != 0 ? 1 : 0;
        boolean trimParts = (flags & 2) != 0;
        boolean skipEmpty = (flags & 4) != 0;
        ArrayList<BasedSequence> items = new ArrayList<BasedSequence>();
        int lastPos = 0;
        int length = this.length();
        if (limit > 1) {
            int pos;
            while (lastPos < length && (pos = this.indexOf(delimiter, lastPos)) >= 0) {
                if (lastPos < pos || !skipEmpty) {
                    BasedSequence item = this.subSequence(lastPos, pos + includeDelimiter);
                    if (trimParts) {
                        item = item.trim(trimChars);
                    }
                    if (!item.isEmpty() || !skipEmpty) {
                        items.add(item);
                        if (includeDelimiterParts) {
                            items.add(this.subSequence(pos, pos + 1));
                        }
                        if (items.size() >= limit - 1) {
                            lastPos = pos + 1;
                            break;
                        }
                    }
                }
                lastPos = pos + 1;
            }
        }
        if (lastPos < length) {
            BasedSequence item = this.subSequence(lastPos, length);
            if (trimParts) {
                item = item.trim(trimChars);
            }
            if (!item.isEmpty() || !skipEmpty) {
                items.add(item);
            }
        }
        return items.toArray(new BasedSequence[items.size()]);
    }

    @Override
    public BasedSequence[] split(CharSequence delimiter, int limit, int flags, String trimChars) {
        if (trimChars == null) {
            trimChars = " \t\r\n";
        }
        if (limit < 1) {
            limit = Integer.MAX_VALUE;
        }
        boolean includeDelimiterParts = (flags & 8) != 0;
        int includeDelimiter = !includeDelimiterParts && (flags & 1) != 0 ? delimiter.length() : 0;
        boolean trimParts = (flags & 2) != 0;
        boolean skipEmpty = (flags & 4) != 0;
        ArrayList<BasedSequence> items = new ArrayList<BasedSequence>();
        int lastPos = 0;
        int length = this.length();
        if (limit > 1) {
            int pos;
            while (lastPos < length && (pos = this.indexOf(delimiter, lastPos)) >= 0) {
                if (lastPos < pos || !skipEmpty) {
                    BasedSequence item = this.subSequence(lastPos, pos + includeDelimiter);
                    if (trimParts) {
                        item = item.trim(trimChars);
                    }
                    if (!item.isEmpty() || !skipEmpty) {
                        items.add(item);
                        if (includeDelimiterParts) {
                            items.add(this.subSequence(pos, pos + delimiter.length()));
                        }
                        if (items.size() >= limit - 1) {
                            lastPos = pos + 1;
                            break;
                        }
                    }
                }
                lastPos = pos + 1;
            }
        }
        if (lastPos < length) {
            BasedSequence item = this.subSequence(lastPos, length);
            if (trimParts) {
                item = item.trim(trimChars);
            }
            if (!item.isEmpty() || !skipEmpty) {
                items.add(item);
            }
        }
        return items.toArray(new BasedSequence[items.size()]);
    }

    @Override
    public BasedSequence appendTo(StringBuilder out) {
        return this.appendTo(out, 0, this.length());
    }

    @Override
    public BasedSequence appendTo(StringBuilder out, int start) {
        return this.appendTo(out, start, this.length());
    }

    @Override
    public BasedSequence appendTo(StringBuilder out, int start, int end) {
        out.append(this, start, end);
        return this;
    }

    public static int[] expandTo(int[] indices, int length, int step) {
        int remainder = length & step;
        int next = length + (remainder != 0 ? step : 0);
        if (indices.length < length) {
            int[] replace = new int[length];
            System.arraycopy(indices, 0, replace, 0, indices.length);
            return replace;
        }
        return indices;
    }

    public static int[] truncateTo(int[] indices, int length) {
        if (indices.length > length) {
            int[] replace = new int[length];
            System.arraycopy(indices, 0, replace, 0, length);
            return replace;
        }
        return indices;
    }

    @Override
    public int[] indexOfAll(CharSequence s) {
        int length = s.length();
        if (length == 0) {
            return EMPTY_INDICES;
        }
        int pos = this.indexOf(s);
        if (pos == -1) {
            return EMPTY_INDICES;
        }
        int iMax = 0;
        int[] indices = new int[32];
        indices[iMax++] = pos;
        while ((pos = this.indexOf(s, pos + length)) != -1) {
            if (indices.length < iMax) {
                indices = BasedSequenceImpl.expandTo(indices, iMax, 32);
            }
            indices[iMax++] = pos;
        }
        return BasedSequenceImpl.truncateTo(indices, iMax);
    }

    @Override
    public BasedSequence replace(CharSequence find, CharSequence replace) {
        int[] indices = this.indexOfAll(find);
        if (indices.length == 0) {
            return this;
        }
        int iMax = indices.length;
        StringBuilder sb = new StringBuilder(this.length() + (replace.length() - find.length()) * iMax);
        BasedSequence basedReplace = SubSequence.of(replace);
        int i = 0;
        int lastPos = 0;
        while (i < iMax) {
            int pos;
            int endPos;
            int n = endPos = (pos = indices[i++]) == -1 ? this.length() : pos;
            if (lastPos < endPos) {
                this.appendTo(sb, lastPos, pos);
            }
            if (pos == -1) break;
            lastPos = pos + find.length();
            basedReplace.appendTo(sb);
        }
        return CharSubSequence.of(sb);
    }

    @Override
    public BasedSequence append(CharSequence ... others) {
        if (others.length > 0) {
            int total = 0;
            for (CharSequence other : others) {
                total += other.length();
            }
            StringBuilder sb = new StringBuilder(this.length() + total);
            this.appendTo(sb);
            for (CharSequence other : others) {
                if (other instanceof BasedSequence) {
                    ((BasedSequence)other).appendTo(sb);
                    continue;
                }
                sb.append(other);
            }
            return CharSubSequence.of(sb);
        }
        return this;
    }

    public static BasedSequence of(CharSequence charSequence) {
        if (charSequence instanceof BasedSequence) {
            return (BasedSequence)charSequence;
        }
        if (charSequence instanceof String) {
            return CharSubSequence.of(charSequence);
        }
        return SubSequence.of(charSequence);
    }

    public static BasedSequence of(CharSequence charSequence, int start) {
        if (charSequence instanceof BasedSequence) {
            return ((BasedSequence)charSequence).subSequence(start);
        }
        if (charSequence instanceof String) {
            return CharSubSequence.of(charSequence, start);
        }
        return SubSequence.of(charSequence, start);
    }

    public static BasedSequence of(CharSequence charSequence, int start, int end) {
        if (charSequence instanceof BasedSequence) {
            return ((BasedSequence)charSequence).subSequence(start, end);
        }
        if (charSequence instanceof String) {
            return CharSubSequence.of(charSequence, start, end);
        }
        return SubSequence.of(charSequence, start, end);
    }

    static {
        HashMap<Character, String> charMap = new HashMap<Character, String>();
        visibleSpacesMap = charMap;
        charMap.put(Character.valueOf('\n'), "\\n");
        charMap.put(Character.valueOf('\r'), "\\r");
        charMap.put(Character.valueOf('\f'), "\\f");
        charMap.put(Character.valueOf('\t'), "\\u2192");
    }
}

