/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence.mappers;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.mappers.SpecialLeadInHandler;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecialLeadInStartsWithCharsHandler
implements SpecialLeadInHandler {
    final CharPredicate predicate;

    protected SpecialLeadInStartsWithCharsHandler(CharPredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean escape(@NotNull BasedSequence sequence, @Nullable DataHolder options, @NotNull Consumer<CharSequence> consumer) {
        if (sequence.length() >= 1 && this.predicate.test(sequence.charAt(0))) {
            consumer.accept("\\");
            consumer.accept(sequence);
            return true;
        }
        return false;
    }

    @Override
    public boolean unEscape(@NotNull BasedSequence sequence, @Nullable DataHolder options, @NotNull Consumer<CharSequence> consumer) {
        if (sequence.length() >= 2 && sequence.charAt(0) == '\\' && this.predicate.test(sequence.charAt(1))) {
            consumer.accept((CharSequence)sequence.subSequence(1));
            return true;
        }
        return false;
    }

    @NotNull
    public static SpecialLeadInStartsWithCharsHandler create(char leadInChar) {
        return new SpecialLeadInStartsWithCharsHandler(CharPredicate.anyOf((char[])new char[]{leadInChar}));
    }

    @NotNull
    public static SpecialLeadInStartsWithCharsHandler create(@NotNull CharSequence leadInChar) {
        return new SpecialLeadInStartsWithCharsHandler(CharPredicate.anyOf((CharSequence)leadInChar));
    }
}

