/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.experimental.util.collection.iteration;

import com.vladsch.flexmark.experimental.util.collection.iteration.IPositionHolder;
import com.vladsch.flexmark.experimental.util.collection.iteration.IPositionListener;
import com.vladsch.flexmark.experimental.util.collection.iteration.IPositionUpdater;
import com.vladsch.flexmark.experimental.util.collection.iteration.IPreviewPositionListener;
import com.vladsch.flexmark.experimental.util.collection.iteration.PositionFactory;
import com.vladsch.flexmark.experimental.util.collection.iteration.PositionIterator;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.PositionAnchor;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class PositionListBase<T, P extends IPositionHolder<T, P>>
implements Iterable<P>,
IPositionUpdater<T, P> {
    @NotNull
    private final List<T> myList;
    @NotNull
    private final WeakHashMap<IPositionListener, Integer> myListeners = new WeakHashMap();
    @Nullable
    private WeakHashMap<IPreviewPositionListener, Boolean> myPreviewListeners = null;
    @NotNull
    private final PositionFactory<T, P> myFactory;
    @NotNull
    private final Stack<FrameLevel> myFrames = new Stack();
    private int myLastFrameId;
    private int myMaxListeners;

    public PositionListBase(@NotNull List<T> list, @NotNull PositionFactory<T, P> factory) {
        this.myList = list;
        this.myFactory = factory;
    }

    @TestOnly
    public int getListeners() {
        int count = 0;
        for (IPositionListener position : this.myListeners.keySet()) {
            if (position == null) continue;
            ++count;
        }
        return count;
    }

    @TestOnly
    public int getMaxListeners() {
        return this.myMaxListeners;
    }

    @TestOnly
    public int getPreviewListeners() {
        if (this.myPreviewListeners != null) {
            int count = 0;
            for (IPreviewPositionListener position : this.myPreviewListeners.keySet()) {
                if (position == null) continue;
                ++count;
            }
            if (count == 0) {
                this.myPreviewListeners = null;
            }
            return count;
        }
        return -1;
    }

    @Override
    public void addPositionListener(@NotNull IPositionListener listener) {
        int frameId = this.myFrames.isEmpty() ? -1 : this.myFrames.peek().frameId;
        this.myListeners.put(listener, frameId);
        if (listener instanceof IPreviewPositionListener) {
            if (this.myPreviewListeners == null) {
                this.myPreviewListeners = new WeakHashMap();
            }
            this.myPreviewListeners.put((IPreviewPositionListener)listener, true);
        }
    }

    @Override
    public void removePositionListener(@NotNull IPositionListener listener) {
        this.myListeners.remove(listener);
        if (this.myPreviewListeners != null && listener instanceof IPreviewPositionListener) {
            this.myPreviewListeners.remove(listener);
            if (this.myPreviewListeners.isEmpty()) {
                this.myPreviewListeners = null;
            }
        }
    }

    @Override
    @NotNull
    public Iterator<P> iterator() {
        return this.iterator(this.getPosition(0, PositionAnchor.NEXT));
    }

    @NotNull
    public Iterator<P> reversedIterator() {
        return this.iterator(this.getPosition(Math.max(0, this.myList.size() - 1), PositionAnchor.PREVIOUS));
    }

    @NotNull
    public Iterable<P> reversed() {
        return this::reversedIterator;
    }

    @Override
    @NotNull
    public Iterator<P> iterator(@NotNull P position) {
        assert (position.getAnchor() != PositionAnchor.CURRENT);
        return new PositionIterator(position);
    }

    @Override
    @NotNull
    public List<T> getList() {
        return this.myList;
    }

    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.myList.isEmpty();
    }

    public T get(int index) {
        return this.myList.get(index);
    }

    public T getOrNull(int index) {
        return (T)Utils.getOrNull(this.myList, (int)index);
    }

    public <S extends T> S getOrNull(int index, Class<S> elementClass) {
        return (S)Utils.getOrNull(this.myList, (int)index, elementClass);
    }

    public Object openFrame() {
        FrameLevel frameLevel;
        int frameId = ++this.myLastFrameId;
        if (this.myFrames.isEmpty()) {
            frameLevel = new FrameLevel(this.getListParentId(), null, frameId, Thread.currentThread().getStackTrace());
        } else {
            FrameLevel parentFrame = this.myFrames.peek();
            frameLevel = new FrameLevel(this.getListParentId(), parentFrame, frameId, Thread.currentThread().getStackTrace());
        }
        this.myFrames.push(frameLevel);
        return frameLevel;
    }

    @NotNull
    public String getListParentId() {
        return this.getClass().getSimpleName() + "@" + Integer.toString(super.hashCode(), 16);
    }

    public void closeFrame(Object frameId) {
        if (!(frameId instanceof FrameLevel)) {
            throw new IllegalStateException("Invalid frame id: " + frameId);
        }
        FrameLevel frameLevel = (FrameLevel)frameId;
        if (!frameLevel.parentList.equals(this.getListParentId())) {
            throw new IllegalStateException("FrameId created by: " + frameLevel.parentList + ", not by this list: " + this.getListParentId());
        }
        if (this.myFrames.isEmpty()) {
            throw new IllegalStateException("No frames open");
        }
        FrameLevel openFrame = this.myFrames.peek();
        int openFrameId = openFrame.frameId;
        if (openFrameId != frameLevel.frameId) {
            StringBuilder out = new StringBuilder();
            out.append("closeFrame(").append(") open nested frames, ");
            this.throwIllegalStateWithOpenFrameTrace(out, frameLevel);
        }
        this.myFrames.pop();
        int[] listenerCount = new int[]{0};
        this.myListeners.entrySet().removeIf(entry -> {
            listenerCount[0] = listenerCount[0] + 1;
            if (entry.getKey() != null) {
                if ((Integer)entry.getValue() != openFrameId) {
                    return false;
                }
                if (entry.getKey() instanceof IPositionHolder) {
                    ((IPositionHolder)entry.getKey()).setDetached();
                }
                if (this.myPreviewListeners != null && entry.getKey() instanceof IPreviewPositionListener) {
                    this.myPreviewListeners.remove(entry.getKey());
                }
            }
            return true;
        });
        this.myMaxListeners = Math.max(this.myMaxListeners, listenerCount[0]);
        if (this.myPreviewListeners != null && this.myPreviewListeners.isEmpty()) {
            this.myPreviewListeners = null;
        }
    }

    private void throwIllegalStateWithOpenFrameTrace(@Nullable StringBuilder out, FrameLevel frame) {
        if (!this.myFrames.isEmpty()) {
            if (out == null) {
                out = new StringBuilder();
            }
            out.append("openFrame trace:\n");
            int indent = 4;
            for (FrameLevel openFrame : this.myFrames) {
                if (!openFrame.isDescendantOf(frame)) continue;
                openFrame.appendStackTrace(out, RepeatedSequence.ofSpaces((int)(indent + 2 * (openFrame.frameLevel - frame.frameLevel))), 2);
            }
            throw new IllegalStateException(out.toString());
        }
    }

    @Override
    public P getPosition(int index, @NotNull PositionAnchor anchor) {
        if (index < 0 || index > this.myList.size()) {
            throw new IndexOutOfBoundsException("ListPosition.get(" + index + "), index out valid range [0, " + this.myList.size() + "]");
        }
        P listPosition = this.myFactory.create(this, index, anchor);
        this.addPositionListener((IPositionListener)listPosition);
        return listPosition;
    }

    @Override
    public void unframe(P position) {
        if (this.myListeners.containsKey(position)) {
            this.myListeners.put((IPositionListener)position, -1);
        }
    }

    public P getFirst() {
        return this.getPosition(0, PositionAnchor.CURRENT);
    }

    public P getLast() {
        return this.myList.isEmpty() ? this.getPosition(0, PositionAnchor.CURRENT) : this.getPosition(this.myList.size() - 1, PositionAnchor.CURRENT);
    }

    public P getEnd() {
        return this.getPosition(this.myList.size(), PositionAnchor.CURRENT);
    }

    @Override
    public void clear() {
        if (!this.myList.isEmpty()) {
            this.myList.clear();
            this.deleted(0, Integer.MAX_VALUE);
            int[] listenerCount = new int[]{0};
            this.myListeners.entrySet().removeIf(entry -> {
                listenerCount[0] = listenerCount[0] + 1;
                if (entry.getKey() instanceof IPositionHolder) {
                    ((IPositionHolder)entry.getKey()).setDetached();
                }
                if (this.myPreviewListeners != null && entry.getKey() instanceof IPreviewPositionListener) {
                    this.myPreviewListeners.remove(entry.getKey());
                }
                return true;
            });
            this.myMaxListeners = Math.max(this.myMaxListeners, listenerCount[0]);
            this.myListeners.clear();
            this.myPreviewListeners = null;
        }
    }

    @Override
    public void inserted(int index, int count) {
        assert (count >= 0);
        assert (index >= 0 && index <= this.myList.size() - count);
        int[] listenerCount = new int[]{0};
        this.myListeners.entrySet().removeIf(entry -> {
            listenerCount[0] = listenerCount[0] + 1;
            if (entry.getKey() == null) {
                return true;
            }
            ((IPositionListener)entry.getKey()).inserted(index, count);
            return false;
        });
        this.myMaxListeners = Math.max(this.myMaxListeners, listenerCount[0]);
    }

    @Override
    public void deleted(int index, int count) {
        assert (count >= 0);
        assert (index >= 0 && index + count <= this.myList.size() + count);
        int[] listenerCount = new int[]{0};
        this.myListeners.entrySet().removeIf(entry -> {
            listenerCount[0] = listenerCount[0] + 1;
            if (entry.getKey() == null) {
                return true;
            }
            ((IPositionListener)entry.getKey()).deleted(index, count);
            return false;
        });
        this.myMaxListeners = Math.max(this.myMaxListeners, listenerCount[0]);
    }

    @Override
    public void deleting(int index, int count) {
        if (this.myPreviewListeners != null) {
            this.myPreviewListeners.entrySet().removeIf(entry -> {
                if (entry.getKey() == null) {
                    return true;
                }
                ((IPreviewPositionListener)entry.getKey()).deleting(index, count);
                return false;
            });
        }
    }

    @Override
    public Object changing(int index, Object value) {
        return this.set(index, value);
    }

    @Override
    public void changed(int index, Object oldValue, Object newValue) {
        throw new IllegalStateException("Should not be called. Use set() or changing(index, value) to change list value");
    }

    public T set(int index, T value) {
        if (index == this.myList.size()) {
            this.add(value);
            return null;
        }
        if (this.myPreviewListeners != null) {
            Object[] useValue = new Object[]{value};
            this.myPreviewListeners.entrySet().removeIf(entry -> {
                if (entry.getKey() == null) {
                    return true;
                }
                Object wasValue = useValue[0];
                useValue[0] = ((IPreviewPositionListener)entry.getKey()).changing(index, wasValue);
                assert (useValue[0] == wasValue || value.getClass().isInstance(useValue[0]));
                return false;
            });
            Object oldValue = this.myList.get(index);
            Object newValue = useValue[0];
            Object result = this.myList.set(index, newValue);
            this.myPreviewListeners.entrySet().removeIf(entry -> {
                if (entry.getKey() == null) {
                    return true;
                }
                ((IPreviewPositionListener)entry.getKey()).changed(index, oldValue, newValue);
                return false;
            });
            return (T)result;
        }
        return this.myList.set(index, value);
    }

    public T remove(int index) {
        assert (index >= 0 && index < this.myList.size());
        this.deleting(index, 1);
        T value = this.myList.remove(index);
        this.deleted(index, 1);
        return value;
    }

    public void remove(int startIndex, int endIndex) {
        if (startIndex < endIndex) {
            assert (startIndex >= 0 && endIndex <= this.myList.size());
            this.deleting(startIndex, endIndex - startIndex);
            this.myList.subList(startIndex, endIndex).clear();
            this.deleted(startIndex, endIndex - startIndex);
        }
    }

    public boolean add(T element) {
        int index = this.myList.size();
        this.myList.add(element);
        this.inserted(index, 1);
        return true;
    }

    public boolean add(int index, T element) {
        assert (index >= 0 && index <= this.myList.size());
        this.myList.add(index, element);
        this.inserted(index, 1);
        return true;
    }

    public boolean addAll(@NotNull PositionListBase<T, P> other) {
        return this.addAll(this.myList.size(), other.myList);
    }

    public boolean addAll(int index, @NotNull PositionListBase<T, P> other) {
        return this.addAll(index, other.myList);
    }

    public boolean addAll(@NotNull Collection<? extends T> elements) {
        return this.addAll(this.myList.size(), elements);
    }

    public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
        assert (index >= 0 && index <= this.myList.size());
        this.myList.addAll(index, elements);
        this.inserted(index, elements.size());
        return true;
    }

    public int size() {
        return this.myList.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PositionListBase)) {
            return false;
        }
        PositionListBase list = (PositionListBase)o;
        return this.myList.equals(list.myList);
    }

    public int hashCode() {
        return this.myList.hashCode();
    }

    private static class FrameLevel {
        @NotNull
        final String parentList;
        @Nullable
        final FrameLevel parentFrame;
        final int frameLevel;
        final int frameId;
        final StackTraceElement[] openStackTrace;

        public FrameLevel(@NotNull String parentList, @Nullable FrameLevel parentFrame, int frameId, StackTraceElement[] openStackTrace) {
            this.parentList = parentList;
            this.parentFrame = parentFrame;
            this.frameLevel = parentFrame == null ? 0 : parentFrame.frameLevel + 1;
            this.frameId = frameId;
            this.openStackTrace = openStackTrace;
        }

        boolean isDescendantOf(@NotNull FrameLevel parentFrame) {
            return parentFrame == this.parentFrame || this.parentFrame != null && this.parentFrame.isDescendantOf(parentFrame);
        }

        void appendStackTrace(@NotNull StringBuilder out, @NotNull CharSequence indent, int stackOffset) {
            int iMax = this.openStackTrace.length;
            for (int i = stackOffset; i < iMax; ++i) {
                StackTraceElement element = this.openStackTrace[i];
                out.append(indent).append(element.toString()).append("\n");
            }
        }
    }
}

