/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.experimental.util.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyedItemFactoryMap<K, I, P>
implements Map<K, Function<P, I>> {
    @NotNull
    protected final HashMap<K, Function<P, I>> factoryMap;
    @NotNull
    protected final HashMap<K, I> itemMap;
    @NotNull
    protected final P param;

    public KeyedItemFactoryMap(@NotNull P param) {
        this(param, 0);
    }

    public KeyedItemFactoryMap(@NotNull P param, int capacity) {
        this.factoryMap = new HashMap(capacity);
        this.itemMap = new HashMap();
        this.param = param;
    }

    @Nullable
    public I getItem(@NotNull K key) {
        I item = this.itemMap.get(key);
        if (item == null) {
            Function<P, I> factory = this.factoryMap.get(key);
            if (factory == null) {
                throw new IllegalStateException("Factory for key: " + key + " is not defined");
            }
            item = factory.apply(this.param);
            this.itemMap.put(key, item);
        }
        return item;
    }

    @Override
    public int size() {
        return this.factoryMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.factoryMap.isEmpty();
    }

    @Override
    @Nullable
    public Function<P, I> get(@Nullable Object o) {
        return this.factoryMap.get(o);
    }

    @Override
    public boolean containsKey(@Nullable Object o) {
        return this.factoryMap.containsKey(o);
    }

    @Override
    @Nullable
    public Function<P, I> put(@NotNull K k, @NotNull Function<P, I> factory) {
        return this.factoryMap.put(k, factory);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends Function<P, I>> map) {
        this.factoryMap.putAll(map);
    }

    @Override
    @Nullable
    public Function<P, I> remove(@Nullable Object o) {
        return this.factoryMap.remove(o);
    }

    @Override
    public void clear() {
        this.factoryMap.clear();
    }

    @Override
    public boolean containsValue(Object o) {
        return this.factoryMap.containsValue(o);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.factoryMap.keySet();
    }

    @Override
    @NotNull
    public Collection<Function<P, I>> values() {
        return this.factoryMap.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, Function<P, I>>> entrySet() {
        return this.factoryMap.entrySet();
    }
}

