/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util.spec;

import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.test.util.spec.ResourceLocation;
import com.vladsch.flexmark.util.misc.Utils;
import java.io.File;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecExample {
    public static final SpecExample NULL = new SpecExample(ResourceLocation.NULL, 0, null, "", 0, "", "", null, null, true);
    @NotNull
    private final ResourceLocation resourceLocation;
    private final int lineNumber;
    @Nullable
    private final String optionsSet;
    @Nullable
    private final String section;
    private final int exampleNumber;
    @NotNull
    private final String source;
    @NotNull
    private final String html;
    @Nullable
    private final String ast;
    @Nullable
    private final String comment;
    private final boolean isNull;
    private static final ConcurrentMap<String, String> classMap = new ConcurrentHashMap<String, String>();

    public SpecExample(@NotNull ResourceLocation resourceLocation, int lineNumber, @Nullable String optionsSet, @Nullable String section, int exampleNumber, @NotNull String source, @NotNull String html, @Nullable String ast, String comment) {
        this(resourceLocation, lineNumber, optionsSet, section, exampleNumber, source, html, ast, comment, false);
    }

    private SpecExample(@NotNull ResourceLocation resourceLocation, int lineNumber, @Nullable String optionsSet, @Nullable String section, int exampleNumber, @NotNull String source, @NotNull String html, @Nullable String ast, String comment, boolean isNull) {
        String trimmedSet;
        this.resourceLocation = resourceLocation;
        this.lineNumber = lineNumber;
        this.section = section;
        this.exampleNumber = exampleNumber;
        this.source = source;
        this.html = html;
        this.ast = ast;
        this.comment = comment == null ? null : comment.trim();
        this.isNull = isNull;
        this.optionsSet = optionsSet == null ? null : ((trimmedSet = optionsSet.trim()).isEmpty() ? null : trimmedSet);
    }

    public SpecExample withResourceLocation(@NotNull ResourceLocation location) {
        return new SpecExample(location, this.lineNumber, this.optionsSet, this.section, this.exampleNumber, this.source, this.html, this.ast, this.comment, this.isNull);
    }

    public SpecExample withOptionsSet(@Nullable String optionsSet) {
        return new SpecExample(this.resourceLocation, this.lineNumber, optionsSet, this.section, this.exampleNumber, this.source, this.html, this.ast, this.comment, this.isNull);
    }

    public SpecExample withSection(@Nullable String section) {
        return new SpecExample(this.resourceLocation, this.lineNumber, this.optionsSet, section, this.exampleNumber, this.source, this.html, this.ast, this.comment, this.isNull);
    }

    public SpecExample withExampleNumber(int exampleNumber) {
        return new SpecExample(this.resourceLocation, this.lineNumber, this.optionsSet, this.section, exampleNumber, this.source, this.html, this.ast, this.comment, this.isNull);
    }

    public SpecExample withSource(@NotNull String source) {
        return new SpecExample(this.resourceLocation, this.lineNumber, this.optionsSet, this.section, this.exampleNumber, source, this.html, this.ast, this.comment, this.isNull);
    }

    public SpecExample withHtml(@NotNull String html) {
        return new SpecExample(this.resourceLocation, this.lineNumber, this.optionsSet, this.section, this.exampleNumber, this.source, html, this.ast, this.comment, this.isNull);
    }

    public SpecExample withAst(@Nullable String ast) {
        return new SpecExample(this.resourceLocation, this.lineNumber, this.optionsSet, this.section, this.exampleNumber, this.source, this.html, ast, this.comment, this.isNull);
    }

    public boolean isFullSpecExample() {
        return this != NULL && this.isNull && !Objects.equals(this.resourceLocation, SpecExample.NULL.resourceLocation) && Objects.equals(this.optionsSet, SpecExample.NULL.optionsSet) && Objects.equals(this.section, SpecExample.NULL.section) && this.exampleNumber == SpecExample.NULL.exampleNumber && Objects.equals(this.source, SpecExample.NULL.source) && Objects.equals(this.html, SpecExample.NULL.html) && Objects.equals(this.ast, SpecExample.NULL.ast) && Objects.equals(this.comment, SpecExample.NULL.comment);
    }

    public boolean isNull() {
        return this.isNull;
    }

    public boolean isSpecExample() {
        return this.isNotNull() && !this.isFullSpecExample();
    }

    public boolean isNotNull() {
        return !this.isNull;
    }

    @Nullable
    public String getOptionsSet() {
        return this.optionsSet;
    }

    @NotNull
    public String getFileUrlWithLineNumber() {
        return this.getFileUrlWithLineNumber(0);
    }

    @NotNull
    public String getFileUrlWithLineNumber(int lineOffset) {
        return this.resourceLocation.getFileUrl(Utils.minLimit((int)(this.lineNumber + lineOffset), (int[])new int[]{0}));
    }

    @NotNull
    public String getFileUrl() {
        return this.resourceLocation.getFileUrl();
    }

    @NotNull
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    @NotNull
    public String getSource() {
        return this.source;
    }

    @NotNull
    public String getHtml() {
        return this.html;
    }

    @Nullable
    public String getAst() {
        return this.ast;
    }

    @Nullable
    public String getSection() {
        return this.section;
    }

    public int getExampleNumber() {
        return this.exampleNumber;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public String toString() {
        if (this.isFullSpecExample()) {
            return "Full Spec";
        }
        if (this == NULL) {
            return "NULL";
        }
        return this.section + ": " + this.exampleNumber;
    }

    @NotNull
    public static SpecExample ofCaller(int callNesting, Class<?> resourceClass, @NotNull String source, @NotNull String html, @Nullable String ast) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        StackTraceElement traceElement = trace[callNesting + 2];
        String javaClassFile = (String)classMap.get(resourceClass.getName());
        if (javaClassFile == null) {
            String fileName = traceElement.getFileName();
            String javaFilePath = resourceClass.getName().replace('.', '/');
            File javaPathFile = new File("/" + javaFilePath).getParentFile();
            String javaPath = javaPathFile.getPath() + "/" + fileName;
            URL url = null;
            String prefix = null;
            String resourcePath = null;
            do {
                String absolutePath;
                if ((url = resourceClass.getResource("/" + (resourcePath = Utils.removePrefix((String)(absolutePath = Utils.removeSuffix((String)javaPathFile.getPath(), (String)"/")), (char)'/').replace('/', '.') + ".txt"))) == null) continue;
                prefix = Utils.getResourceAsString(resourceClass, (String)("/" + resourcePath)).trim();
                break;
            } while ((javaPathFile = javaPathFile.getParentFile()) != null);
            if (url == null) {
                throw new IllegalStateException("Class mapping file not found for Class " + resourceClass + " add file under test resources with package for name and .txt extension");
            }
            String fileUrl = TestUtils.adjustedFileUrl(url);
            javaClassFile = fileUrl.replaceFirst("/resources((?:/[^/]*?)*)/" + resourcePath, Utils.prefixWith((String)Utils.removeSuffix((String)prefix, (char)'/'), (char)'/') + "$1" + javaPath);
            classMap.put(resourceClass.getName(), javaClassFile);
        }
        ResourceLocation location = new ResourceLocation(resourceClass, "", javaClassFile);
        return new SpecExample(location, traceElement.getLineNumber() - 1, null, traceElement.getMethodName(), 0, source, html, ast, "");
    }
}

