/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeVisitorBase;

public class AstCollectingVisitor
extends NodeVisitorBase {
    public static final String EOL = "\n";
    protected StringBuilder output = new StringBuilder();
    protected int indent = 0;
    protected boolean eolPending = false;

    public String getAst() {
        return this.output.toString();
    }

    public void clear() {
        this.output = new StringBuilder();
        this.indent = 0;
        this.eolPending = false;
    }

    protected void appendIndent() {
        for (int i = 0; i < this.indent * 2; ++i) {
            this.output.append(' ');
        }
        this.eolPending = true;
    }

    protected void appendEOL() {
        this.output.append(EOL);
        this.eolPending = false;
    }

    protected void appendPendingEOL() {
        if (this.eolPending) {
            this.appendEOL();
        }
    }

    public String collectAndGetAstText(Node node) {
        this.visit(node);
        return this.getAst();
    }

    public void collect(Node node) {
        this.visit(node);
    }

    protected void visit(Node node) {
        this.appendIndent();
        node.astString(this.output, true);
        this.output.append(EOL);
        ++this.indent;
        try {
            super.visitChildren(node);
        }
        finally {
            --this.indent;
        }
    }
}

