/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test;

import com.vladsch.flexmark.spec.SpecExample;
import com.vladsch.flexmark.spec.SpecReader;
import com.vladsch.flexmark.test.RenderingTestCase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class FileSpecTestCase
extends RenderingTestCase {
    protected final SpecExample example;

    public FileSpecTestCase(SpecExample example) {
        this.example = example;
    }

    @Override
    public SpecExample example() {
        return this.example;
    }

    protected abstract String dumpDir();

    protected abstract String dumpHeader();

    @Override
    protected void actualSource(String source, String optionSet) {
    }

    @Override
    protected void actualHtml(String html, String optionSet) {
    }

    @Override
    protected void actualAst(String ast, String optionSet) {
    }

    @Override
    protected void specExample(String expected, String actual, String optionSet) {
        if (this.dumpDir() != null) {
            File file = new File(this.dumpDir() + this.example.getSection() + "_ast_spec.md");
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(file);
                outputStream.write(this.dumpHeader().getBytes(Charset.defaultCharset()));
                outputStream.write(actual.getBytes(Charset.defaultCharset()));
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> data() {
        return FileSpecTestCase.dataFromSeparateFiles(new String[0], "", false, false);
    }

    public static List<Object[]> dataFromSeparateFiles(String[] fileNames, String prefix, boolean dumpHtml, boolean dumpAst) {
        ArrayList<SpecExample> examples = new ArrayList<SpecExample>();
        for (String name : fileNames) {
            String source = FileSpecTestCase.readResource(prefix + name + ".md");
            String html = null;
            String ast = null;
            try {
                html = FileSpecTestCase.readResource(name + ".html");
            }
            catch (RuntimeException ignored) {
                html = dumpHtml ? "" : null;
            }
            try {
                ast = FileSpecTestCase.readResource(name + ".ast");
            }
            catch (RuntimeException ignored) {
                String string = ast = dumpAst ? "" : null;
            }
            if (ast != null) {
                examples.add(new SpecExample("", name, 0, source, html, ast));
                continue;
            }
            examples.add(new SpecExample("", name, 0, source, html));
        }
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{SpecExample.NULL});
        for (SpecExample example : examples) {
            data.add(new Object[]{example});
        }
        return data;
    }

    public static List<Object[]> dataFromFiles(String[] fileNames, String prefix) {
        ArrayList<SpecExample> examples = new ArrayList<SpecExample>();
        for (String name : fileNames) {
            List<SpecExample> fileExamples = SpecReader.readExamples(prefix + name + "_ast_spec.md");
            int i = 1;
            for (SpecExample example : fileExamples) {
                examples.add(example.withSection(name).withExampleNumber(i++));
            }
        }
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (SpecExample example : examples) {
            data.add(new Object[]{example});
        }
        return data;
    }

    @Override
    protected boolean useActualHtml() {
        return true;
    }

    protected static String readResource(String resourcePath) {
        InputStream stream = FileSpecTestCase.class.getResourceAsStream(resourcePath);
        return FileSpecTestCase.readStream(stream);
    }

    protected static String readStream(InputStream stream) {
        try {
            String line;
            StringBuilder out = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8")));
            while ((line = reader.readLine()) != null) {
                out.append(line).append('\n');
            }
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testHtmlRendering() {
        if (!this.example.isSpecExample()) {
            return;
        }
        if (this.example.getAst() != null) {
            this.assertRenderingAst(this.example.getSource(), this.example.getHtml(), this.example.getAst(), this.example.getOptionsSet());
        } else {
            this.assertRendering(this.example.getSource(), this.example.getHtml(), this.example.getOptionsSet());
        }
    }
}

