/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables.internal;

import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.tables.internal.TableParserOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TableNodeRenderer
implements NodeRenderer {
    private final TableParserOptions options;

    public TableNodeRenderer(DataHolder options) {
        this.options = new TableParserOptions(options);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler<TableBlock>(TableBlock.class, this::render), new NodeRenderingHandler<TableHead>(TableHead.class, this::render), new NodeRenderingHandler<TableSeparator>(TableSeparator.class, this::render), new NodeRenderingHandler<TableBody>(TableBody.class, this::render), new NodeRenderingHandler<TableRow>(TableRow.class, this::render), new NodeRenderingHandler<TableCell>(TableCell.class, this::render), new NodeRenderingHandler<TableCaption>(TableCaption.class, this::render)));
    }

    private void render(TableBlock node, NodeRendererContext context, HtmlWriter html) {
        if (!this.options.className.isEmpty()) {
            html.attr("class", this.options.className);
        }
        ((HtmlWriter)html.srcPosWithEOL(node.getChars()).withAttr().tagLineIndent("table", () -> context.renderChildren(node))).line();
    }

    private void render(TableHead node, NodeRendererContext context, HtmlWriter html) {
        ((HtmlWriter)html.withAttr().withCondIndent()).tagLine((CharSequence)"thead", () -> context.renderChildren(node));
    }

    private void render(TableSeparator tableSeparator, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(TableBody node, NodeRendererContext context, HtmlWriter html) {
        ((HtmlWriter)html.withAttr().withCondIndent()).tagLine((CharSequence)"tbody", () -> context.renderChildren(node));
    }

    private void render(TableRow node, NodeRendererContext context, HtmlWriter html) {
        html.srcPos(node.getChars()).withAttr().tagLine((CharSequence)"tr", () -> context.renderChildren(node));
    }

    private void render(TableCaption node, NodeRendererContext context, HtmlWriter html) {
        html.srcPos(node.getChars()).withAttr().tagLine((CharSequence)"caption", () -> context.renderChildren(node));
    }

    private void render(TableCell node, NodeRendererContext context, HtmlWriter html) {
        String tag;
        String string = tag = node.isHeader() ? "th" : "td";
        if (node.getAlignment() != null) {
            html.attr("align", TableNodeRenderer.getAlignValue(node.getAlignment()));
        }
        if (this.options.columnSpans && node.getSpan() > 1) {
            html.attr("colspan", String.valueOf(node.getSpan()));
        }
        html.srcPos(node.getText()).withAttr().tag(tag);
        context.renderChildren(node);
        html.tag("/" + tag);
    }

    private static String getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new TableNodeRenderer(options);
        }
    }
}

