/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.jekyll.tag;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public class JekyllTag
extends Node {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence tag = BasedSequence.NULL;
    protected BasedSequence parameters = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.tag, this.parameters, this.closingMarker};
    }

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        JekyllTag.segmentSpanChars(out, this.openingMarker, "open");
        JekyllTag.segmentSpanChars(out, this.tag, "tag");
        JekyllTag.segmentSpanChars(out, this.parameters, "parameters");
        JekyllTag.segmentSpanChars(out, this.closingMarker, "close");
    }

    public JekyllTag() {
    }

    public JekyllTag(BasedSequence chars) {
        super(chars);
    }

    public JekyllTag(BasedSequence openingMarker, BasedSequence tag, BasedSequence parameters, BasedSequence closingMarker) {
        super(openingMarker.baseSubSequence(openingMarker.getStartOffset(), closingMarker.getEndOffset()));
        this.openingMarker = openingMarker;
        this.tag = tag;
        this.parameters = parameters;
        this.closingMarker = closingMarker;
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getTag() {
        return this.tag;
    }

    public void setTag(BasedSequence text) {
        this.tag = text;
    }

    public BasedSequence getParameters() {
        return this.parameters;
    }

    public void setParameters(BasedSequence parameters) {
        this.parameters = parameters;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }
}

