/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.youtrack.converter.internal;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlBlockBase;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.HtmlInlineBase;
import com.vladsch.flexmark.ast.HtmlInlineComment;
import com.vladsch.flexmark.ast.HtmlInnerBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.IndentedCodeBlock;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphItemContainer;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.ThematicBreak;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class YouTrackConverterNodeRenderer
implements NodeRenderer {
    private final ReferenceRepository referenceRepository;
    private final ListOptions listOptions;
    private int inBlockQuote = 0;
    private final boolean recheckUndefinedReferences;

    public YouTrackConverterNodeRenderer(DataHolder options) {
        this.referenceRepository = options.get(Parser.REFERENCES);
        this.recheckUndefinedReferences = HtmlRenderer.RECHECK_UNDEFINED_REFERENCES.getFrom(options);
        this.listOptions = ListOptions.getFrom(options);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler<AutoLink>(AutoLink.class, new CustomNodeRenderer<AutoLink>(){

            @Override
            public void render(AutoLink node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<BlockQuote>(BlockQuote.class, new CustomNodeRenderer<BlockQuote>(){

            @Override
            public void render(BlockQuote node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<BulletList>(BulletList.class, new CustomNodeRenderer<BulletList>(){

            @Override
            public void render(BulletList node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<BulletListItem>(BulletListItem.class, new CustomNodeRenderer<BulletListItem>(){

            @Override
            public void render(BulletListItem node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Code>(Code.class, new CustomNodeRenderer<Code>(){

            @Override
            public void render(Code node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Document>(Document.class, new CustomNodeRenderer<Document>(){

            @Override
            public void render(Document node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Emphasis>(Emphasis.class, new CustomNodeRenderer<Emphasis>(){

            @Override
            public void render(Emphasis node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<FencedCodeBlock>(FencedCodeBlock.class, new CustomNodeRenderer<FencedCodeBlock>(){

            @Override
            public void render(FencedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HardLineBreak>(HardLineBreak.class, new CustomNodeRenderer<HardLineBreak>(){

            @Override
            public void render(HardLineBreak node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Heading>(Heading.class, new CustomNodeRenderer<Heading>(){

            @Override
            public void render(Heading node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlBlock>(HtmlBlock.class, new CustomNodeRenderer<HtmlBlock>(){

            @Override
            public void render(HtmlBlock node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlCommentBlock>(HtmlCommentBlock.class, new CustomNodeRenderer<HtmlCommentBlock>(){

            @Override
            public void render(HtmlCommentBlock node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlEntity>(HtmlEntity.class, new CustomNodeRenderer<HtmlEntity>(){

            @Override
            public void render(HtmlEntity node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlInline>(HtmlInline.class, new CustomNodeRenderer<HtmlInline>(){

            @Override
            public void render(HtmlInline node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlInlineComment>(HtmlInlineComment.class, new CustomNodeRenderer<HtmlInlineComment>(){

            @Override
            public void render(HtmlInlineComment node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlInnerBlock>(HtmlInnerBlock.class, new CustomNodeRenderer<HtmlInnerBlock>(){

            @Override
            public void render(HtmlInnerBlock node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlInnerBlockComment>(HtmlInnerBlockComment.class, new CustomNodeRenderer<HtmlInnerBlockComment>(){

            @Override
            public void render(HtmlInnerBlockComment node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Image>(Image.class, new CustomNodeRenderer<Image>(){

            @Override
            public void render(Image node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<ImageRef>(ImageRef.class, new CustomNodeRenderer<ImageRef>(){

            @Override
            public void render(ImageRef node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<IndentedCodeBlock>(IndentedCodeBlock.class, new CustomNodeRenderer<IndentedCodeBlock>(){

            @Override
            public void render(IndentedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Link>(Link.class, new CustomNodeRenderer<Link>(){

            @Override
            public void render(Link node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<LinkRef>(LinkRef.class, new CustomNodeRenderer<LinkRef>(){

            @Override
            public void render(LinkRef node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<MailLink>(MailLink.class, new CustomNodeRenderer<MailLink>(){

            @Override
            public void render(MailLink node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<OrderedList>(OrderedList.class, new CustomNodeRenderer<OrderedList>(){

            @Override
            public void render(OrderedList node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<OrderedListItem>(OrderedListItem.class, new CustomNodeRenderer<OrderedListItem>(){

            @Override
            public void render(OrderedListItem node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Paragraph>(Paragraph.class, new CustomNodeRenderer<Paragraph>(){

            @Override
            public void render(Paragraph node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Reference>(Reference.class, new CustomNodeRenderer<Reference>(){

            @Override
            public void render(Reference node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<SoftLineBreak>(SoftLineBreak.class, new CustomNodeRenderer<SoftLineBreak>(){

            @Override
            public void render(SoftLineBreak node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<StrongEmphasis>(StrongEmphasis.class, new CustomNodeRenderer<StrongEmphasis>(){

            @Override
            public void render(StrongEmphasis node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Text>(Text.class, new CustomNodeRenderer<Text>(){

            @Override
            public void render(Text node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<TextBase>(TextBase.class, new CustomNodeRenderer<TextBase>(){

            @Override
            public void render(TextBase node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<ThematicBreak>(ThematicBreak.class, new CustomNodeRenderer<ThematicBreak>(){

            @Override
            public void render(ThematicBreak node, NodeRendererContext context, HtmlWriter html) {
                YouTrackConverterNodeRenderer.this.render(node, context, html);
            }
        })));
    }

    private void render(Document node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren(node);
    }

    private String repeat(String s, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    private void render(Heading node, NodeRendererContext context, HtmlWriter html) {
        String s = this.repeat("=", node.getLevel());
        ((HtmlWriter)html.line()).raw(s);
        context.renderChildren(node);
        html.raw(s);
        this.tailBlankLine(node, html);
    }

    private HtmlWriter tailBlankLine(Node node, HtmlWriter html) {
        return this.tailBlankLine(node, 1, html);
    }

    public boolean isLastBlockQuoteChild(Node node) {
        Node parent = node.getParent();
        return parent instanceof BlockQuote && parent.getLastChild() == node;
    }

    public HtmlWriter tailBlankLine(Node node, int count, HtmlWriter html) {
        if (this.isLastBlockQuoteChild(node)) {
            CharSequence prefix = html.getPrefix();
            html.popPrefix();
            html.blankLine(count);
            html.pushPrefix();
            html.setPrefix(prefix, false);
        } else {
            html.blankLine(count);
        }
        return html;
    }

    private void render(BlockQuote node, NodeRendererContext context, HtmlWriter html) {
        ++this.inBlockQuote;
        String repeat = this.repeat(">", this.inBlockQuote) + " ";
        html.pushPrefix();
        ((HtmlWriter)((HtmlWriter)html.line()).setPrefix("")).raw(repeat);
        html.setPrefix(repeat);
        context.renderChildren(node);
        --this.inBlockQuote;
        html.popPrefix();
        this.tailBlankLine(node, html);
    }

    private void render(FencedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        BasedSequence info = node.getInfo();
        if (info.isNotNull() && !info.isBlank()) {
            ((HtmlWriter)((HtmlWriter)html.line()).raw("{code:lang=" + info.unescape() + "}")).line();
        } else {
            ((HtmlWriter)((HtmlWriter)html.line()).raw("{code}")).line();
        }
        html.raw(node.getContentChars().normalizeEOL());
        ((HtmlWriter)html.line()).raw("{code}");
        this.tailBlankLine(node, html);
    }

    private void render(ThematicBreak node, NodeRendererContext context, HtmlWriter html) {
        ((HtmlWriter)html.line()).raw("-----");
        this.tailBlankLine(node, html);
    }

    private void render(IndentedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        ((HtmlWriter)((HtmlWriter)html.line()).raw("{noformat}")).line();
        html.raw(((BasedSequence)node.getContentChars().trimTailBlankLines()).normalizeEndWithEOL());
        ((HtmlWriter)((HtmlWriter)html.line()).raw("{noformat}")).line();
    }

    private void renderListItemPrefix(ListItem node, NodeRendererContext context, HtmlWriter html) {
        Node parent = node;
        StringBuilder prefix = new StringBuilder();
        while (parent instanceof ListBlock || parent instanceof ListItem) {
            if (parent instanceof BulletList) {
                prefix.append('*');
            } else if (parent instanceof OrderedList) {
                prefix.append('#');
            }
            parent = ((Node)parent).getParent();
        }
        if (prefix.length() > 0) {
            prefix.append(' ');
        }
        ((HtmlWriter)html.line()).raw(prefix.toString());
    }

    private void renderListItem(ListItem node, NodeRendererContext context, HtmlWriter html) {
        this.renderListItemPrefix(node, context, html);
        if (this.listOptions.isTightListItem(node)) {
            context.renderChildren(node);
        } else {
            context.renderChildren(node);
            if (node.getFirstChild().getNext() != null) {
                this.tailBlankLine(node, html);
            }
        }
    }

    private void renderList(ListBlock node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren(node);
        if (node.getParent() instanceof Document && (node.getLastChild() == null || this.listOptions.isTightListItem((ListItem)node.getLastChild()))) {
            this.tailBlankLine(node, html);
        }
    }

    private void render(BulletList node, NodeRendererContext context, HtmlWriter html) {
        this.renderList(node, context, html);
    }

    private void render(OrderedList node, NodeRendererContext context, HtmlWriter html) {
        this.renderList(node, context, html);
    }

    private void render(BulletListItem node, NodeRendererContext context, HtmlWriter html) {
        this.renderListItem(node, context, html);
    }

    private void render(OrderedListItem node, NodeRendererContext context, HtmlWriter html) {
        this.renderListItem(node, context, html);
    }

    private static void renderTextBlockParagraphLines(Node node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren(node);
        html.line();
    }

    private void renderLooseParagraph(Paragraph node, NodeRendererContext context, HtmlWriter html) {
        YouTrackConverterNodeRenderer.renderTextBlockParagraphLines(node, context, html);
        if (this.inBlockQuote > 0 && node.getNext() == null) {
            html.line();
        } else {
            this.tailBlankLine(node, html);
        }
    }

    private void render(Paragraph node, NodeRendererContext context, HtmlWriter html) {
        if (!(node.getParent() instanceof ParagraphItemContainer) || !((ParagraphItemContainer)((Object)node.getParent())).isParagraphWrappingDisabled(node, this.listOptions, context.getOptions())) {
            this.renderLooseParagraph(node, context, html);
        } else {
            YouTrackConverterNodeRenderer.renderTextBlockParagraphLines(node, context, html);
        }
    }

    public static BasedSequence getSoftLineBreakSpan(Node node) {
        if (node == null) {
            return BasedSequence.NULL;
        }
        Node lastNode = node;
        for (Node nextNode = node.getNext(); nextNode != null && !(nextNode instanceof SoftLineBreak); nextNode = nextNode.getNext()) {
            lastNode = nextNode;
        }
        return Node.spanningChars(node.getChars(), lastNode.getChars());
    }

    private void render(SoftLineBreak node, NodeRendererContext context, HtmlWriter html) {
        html.raw(" ");
    }

    private void render(HardLineBreak node, NodeRendererContext context, HtmlWriter html) {
        html.line();
    }

    private void render(Emphasis node, NodeRendererContext context, HtmlWriter html) {
        html.raw("''");
        context.renderChildren(node);
        html.raw("''");
    }

    private void render(StrongEmphasis node, NodeRendererContext context, HtmlWriter html) {
        html.raw("*");
        context.renderChildren(node);
        html.raw("*");
    }

    private void render(Text node, NodeRendererContext context, HtmlWriter html) {
        html.raw(Escaping.normalizeEOL(node.getChars().unescape()));
    }

    private void render(TextBase node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren(node);
    }

    private void render(Code node, NodeRendererContext context, HtmlWriter html) {
        html.raw("`");
        html.raw(Escaping.collapseWhitespace((CharSequence)node.getText(), true));
        html.raw("`");
    }

    private void render(HtmlBlock node, NodeRendererContext context, HtmlWriter html) {
        if (node.hasChildren()) {
            context.renderChildren(node);
        } else {
            this.renderHtmlBlock(node, context, html, context.getHtmlOptions().suppressHtmlBlocks, context.getHtmlOptions().escapeHtmlBlocks);
        }
    }

    private void render(HtmlCommentBlock node, NodeRendererContext context, HtmlWriter html) {
        this.renderHtmlBlock(node, context, html, context.getHtmlOptions().suppressHtmlCommentBlocks, context.getHtmlOptions().escapeHtmlCommentBlocks);
    }

    private void render(HtmlInnerBlock node, NodeRendererContext context, HtmlWriter html) {
        this.renderHtmlBlock(node, context, html, context.getHtmlOptions().suppressHtmlBlocks, context.getHtmlOptions().escapeHtmlBlocks);
    }

    private void render(HtmlInnerBlockComment node, NodeRendererContext context, HtmlWriter html) {
        this.renderHtmlBlock(node, context, html, context.getHtmlOptions().suppressHtmlCommentBlocks, context.getHtmlOptions().escapeHtmlCommentBlocks);
    }

    public void renderHtmlBlock(HtmlBlockBase node, NodeRendererContext context, HtmlWriter html, boolean suppress, boolean escape) {
        if (suppress) {
            return;
        }
        ((HtmlWriter)((HtmlWriter)html.line()).raw("{code:html}")).line();
        html.raw(node.getContentChars().normalizeEOL());
        ((HtmlWriter)((HtmlWriter)html.line()).raw("{code:html}")).line();
    }

    private void render(HtmlInline node, NodeRendererContext context, HtmlWriter html) {
        this.renderInlineHtml(node, context, html, context.getHtmlOptions().suppressInlineHtml, context.getHtmlOptions().escapeInlineHtml);
    }

    private void render(HtmlInlineComment node, NodeRendererContext context, HtmlWriter html) {
        this.renderInlineHtml(node, context, html, context.getHtmlOptions().suppressInlineHtmlComments, context.getHtmlOptions().escapeInlineHtmlComments);
    }

    public void renderInlineHtml(HtmlInlineBase node, NodeRendererContext context, HtmlWriter html, boolean suppress, boolean escape) {
        if (suppress) {
            return;
        }
        ((HtmlWriter)((HtmlWriter)html.raw("`")).raw(node.getChars().normalizeEOL())).raw("`");
    }

    private void render(Reference node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(HtmlEntity node, NodeRendererContext context, HtmlWriter html) {
        html.raw(node.getChars().unescape());
    }

    private void render(AutoLink node, NodeRendererContext context, HtmlWriter html) {
        String text = node.getText().toString();
        if (context.isDoNotRenderLinks()) {
            html.text(text);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, text, null);
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.raw("[")).raw(text)).raw("|")).raw(resolvedLink.getUrl());
        }
    }

    private void render(MailLink node, NodeRendererContext context, HtmlWriter html) {
        String text = node.getText().unescape();
        if (context.isDoNotRenderLinks()) {
            html.text(text);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, text, null);
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.raw("[")).raw(text)).raw("|mailto:")).raw(resolvedLink.getUrl())).raw("]");
        }
    }

    private void render(Image node, NodeRendererContext context, HtmlWriter html) {
        if (!context.isDoNotRenderLinks()) {
            String altText = new TextCollectingVisitor(new Class[0]).collectAndGetText(node);
            ResolvedLink resolvedLink = context.resolveLink(LinkType.IMAGE, node.getUrl().unescape(), null);
            ((HtmlWriter)((HtmlWriter)html.raw("!")).raw(resolvedLink.getUrl())).raw("!");
        }
    }

    private void render(Link node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            context.renderChildren(node);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, node.getUrl().unescape(), null);
            html.raw("[");
            context.renderChildren(node);
            ((HtmlWriter)((HtmlWriter)html.raw("|")).raw(resolvedLink.getUrl())).raw("]");
        }
    }

    private void render(ImageRef node, NodeRendererContext context, HtmlWriter html) {
        if (!node.isDefined() && this.recheckUndefinedReferences && node.getReferenceNode(this.referenceRepository) != null) {
            node.setDefined(true);
        }
        if (!node.isDefined()) {
            assert (!node.isDefined());
            html.text(node.getChars().unescape());
        } else if (!context.isDoNotRenderLinks()) {
            Reference reference = node.getReferenceNode(this.referenceRepository);
            assert (reference != null);
            String altText = new TextCollectingVisitor(new Class[0]).collectAndGetText(node);
            ResolvedLink resolvedLink = context.resolveLink(LinkType.IMAGE, reference.getUrl().unescape(), null);
            ((HtmlWriter)((HtmlWriter)html.raw("!")).raw(resolvedLink.getUrl())).raw("!");
        }
    }

    private void render(LinkRef node, NodeRendererContext context, HtmlWriter html) {
        if (!node.isDefined() && this.recheckUndefinedReferences && node.getReferenceNode(this.referenceRepository) != null) {
            node.setDefined(true);
        }
        if (!node.isDefined()) {
            assert (!node.isDefined());
            html.raw("[");
            context.renderChildren(node);
            html.raw("]");
            if (!node.isReferenceTextCombined()) {
                html.raw("[");
                html.raw(node.getReference().unescape());
                html.raw("]");
            }
        } else if (context.isDoNotRenderLinks()) {
            context.renderChildren(node);
        } else {
            Reference reference = node.getReferenceNode(this.referenceRepository);
            assert (reference != null);
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, reference.getUrl().unescape(), null);
            html.raw("[");
            context.renderChildren(node);
            html.raw("|");
            html.raw(resolvedLink.getUrl());
            html.raw("]");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        public NodeRenderer apply(DataHolder options) {
            return new YouTrackConverterNodeRenderer(options);
        }
    }
}

