/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html2md.converter;

import com.vladsch.flexmark.html2md.converter.ExtensionConversion;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import com.vladsch.flexmark.html2md.converter.LinkConversion;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSetter;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.html.CellAlignment;
import java.util.Map;
import java.util.regex.Pattern;

public class HtmlConverterOptions
implements MutableDataSetter {
    public boolean listContentIndent;
    public boolean setextHeadings;
    public boolean outputUnknownTags;
    public boolean typographicQuotes;
    public boolean typographicSmarts;
    public boolean outputAttributesIdAttr;
    public boolean wrapAutoLinks;
    public boolean extractAutoLinks;
    public boolean renderComments;
    public boolean dotOnlyNumericLists;
    public boolean commentOriginalNonNumericListItem;
    public boolean preCodePreserveEmphasis;
    public boolean listsEndOnDoubleBlank;
    public boolean divAsParagraph;
    public boolean brAsParaBreaks;
    public boolean brAsExtraBlankLines;
    public boolean ignoreTableHeadingAfterRows;
    public boolean addTrailingEol;
    public boolean skipHeading1;
    public boolean skipHeading2;
    public boolean skipHeading3;
    public boolean skipHeading4;
    public boolean skipHeading5;
    public boolean skipHeading6;
    public boolean skipAttributes;
    public boolean skipFencedCode;
    public boolean skipCharEscape;
    public ExtensionConversion extInlineStrong;
    public ExtensionConversion extInlineEmphasis;
    public ExtensionConversion extInlineCode;
    public ExtensionConversion extInlineDel;
    public ExtensionConversion extInlineIns;
    public ExtensionConversion extInlineSub;
    public ExtensionConversion extInlineSup;
    public ExtensionConversion extMath;
    public LinkConversion extInlineLink;
    public LinkConversion extInlineImage;
    public char orderedListDelimiter;
    public char unorderedListDelimiter;
    public int definitionMarkerSpaces;
    public int minSetextHeadingMarkerLength;
    public String codeIndent;
    public String eolInTitleAttribute;
    public String nbspText;
    public String thematicBreak;
    public String outputAttributesNamesRegex;
    public Pattern outputAttributesNamesRegexPattern;
    public String outputIdAttributeRegex;
    public Pattern outputIdAttributeRegexPattern;
    public Map<Object, CellAlignment> tableCellAlignmentMap;
    public TableFormatOptions tableOptions;
    public int formatFlags;
    public int maxBlankLines;
    public int maxTrailingBlankLines;
    public String[] unwrappedTags;
    public String[] wrappedTags;

    public HtmlConverterOptions() {
        this((DataHolder)null);
    }

    public HtmlConverterOptions(HtmlConverterOptions other) {
        this.listContentIndent = other.listContentIndent;
        this.setextHeadings = other.setextHeadings;
        this.outputUnknownTags = other.outputUnknownTags;
        this.typographicQuotes = other.typographicQuotes;
        this.typographicSmarts = other.typographicSmarts;
        this.outputAttributesIdAttr = other.outputAttributesIdAttr;
        this.wrapAutoLinks = other.wrapAutoLinks;
        this.extractAutoLinks = other.extractAutoLinks;
        this.renderComments = other.renderComments;
        this.dotOnlyNumericLists = other.dotOnlyNumericLists;
        this.commentOriginalNonNumericListItem = other.commentOriginalNonNumericListItem;
        this.preCodePreserveEmphasis = other.preCodePreserveEmphasis;
        this.listsEndOnDoubleBlank = other.listsEndOnDoubleBlank;
        this.divAsParagraph = other.divAsParagraph;
        this.brAsParaBreaks = other.brAsParaBreaks;
        this.brAsExtraBlankLines = other.brAsExtraBlankLines;
        this.ignoreTableHeadingAfterRows = other.ignoreTableHeadingAfterRows;
        this.addTrailingEol = other.addTrailingEol;
        this.skipHeading1 = other.skipHeading1;
        this.skipHeading2 = other.skipHeading2;
        this.skipHeading3 = other.skipHeading3;
        this.skipHeading4 = other.skipHeading4;
        this.skipHeading5 = other.skipHeading5;
        this.skipHeading6 = other.skipHeading6;
        this.skipAttributes = other.skipAttributes;
        this.skipFencedCode = other.skipFencedCode;
        this.skipCharEscape = other.skipCharEscape;
        this.extInlineStrong = other.extInlineStrong;
        this.extInlineEmphasis = other.extInlineEmphasis;
        this.extInlineCode = other.extInlineCode;
        this.extInlineDel = other.extInlineDel;
        this.extInlineIns = other.extInlineIns;
        this.extInlineSub = other.extInlineSub;
        this.extInlineSup = other.extInlineSup;
        this.orderedListDelimiter = other.orderedListDelimiter;
        this.unorderedListDelimiter = other.unorderedListDelimiter;
        this.definitionMarkerSpaces = other.definitionMarkerSpaces;
        this.minSetextHeadingMarkerLength = other.minSetextHeadingMarkerLength;
        this.codeIndent = other.codeIndent;
        this.eolInTitleAttribute = other.eolInTitleAttribute;
        this.nbspText = other.nbspText;
        this.thematicBreak = other.thematicBreak;
        this.outputAttributesNamesRegex = other.outputAttributesNamesRegex;
        this.outputAttributesNamesRegexPattern = other.outputAttributesNamesRegexPattern;
        this.tableCellAlignmentMap = other.tableCellAlignmentMap;
        this.tableOptions = other.tableOptions;
        this.outputIdAttributeRegex = other.outputIdAttributeRegex;
        this.outputIdAttributeRegexPattern = other.outputIdAttributeRegexPattern;
        this.extMath = other.extMath;
        this.extInlineLink = other.extInlineLink;
        this.extInlineImage = other.extInlineImage;
        this.formatFlags = other.formatFlags;
        this.maxBlankLines = other.maxBlankLines;
        this.maxTrailingBlankLines = other.maxTrailingBlankLines;
        this.unwrappedTags = other.unwrappedTags;
        this.wrappedTags = other.wrappedTags;
    }

    public HtmlConverterOptions(DataHolder options) {
        this.listContentIndent = FlexmarkHtmlConverter.LIST_CONTENT_INDENT.getFrom(options);
        this.setextHeadings = FlexmarkHtmlConverter.SETEXT_HEADINGS.getFrom(options);
        this.outputUnknownTags = FlexmarkHtmlConverter.OUTPUT_UNKNOWN_TAGS.getFrom(options);
        this.typographicQuotes = FlexmarkHtmlConverter.TYPOGRAPHIC_QUOTES.getFrom(options);
        this.typographicSmarts = FlexmarkHtmlConverter.TYPOGRAPHIC_SMARTS.getFrom(options);
        this.outputAttributesIdAttr = FlexmarkHtmlConverter.OUTPUT_ATTRIBUTES_ID.getFrom(options);
        this.wrapAutoLinks = FlexmarkHtmlConverter.WRAP_AUTO_LINKS.getFrom(options);
        this.extractAutoLinks = FlexmarkHtmlConverter.EXTRACT_AUTO_LINKS.getFrom(options);
        this.renderComments = FlexmarkHtmlConverter.RENDER_COMMENTS.getFrom(options);
        this.dotOnlyNumericLists = FlexmarkHtmlConverter.DOT_ONLY_NUMERIC_LISTS.getFrom(options);
        this.commentOriginalNonNumericListItem = FlexmarkHtmlConverter.COMMENT_ORIGINAL_NON_NUMERIC_LIST_ITEM.getFrom(options);
        this.preCodePreserveEmphasis = FlexmarkHtmlConverter.PRE_CODE_PRESERVE_EMPHASIS.getFrom(options);
        this.listsEndOnDoubleBlank = FlexmarkHtmlConverter.LISTS_END_ON_DOUBLE_BLANK.getFrom(options);
        this.divAsParagraph = FlexmarkHtmlConverter.DIV_AS_PARAGRAPH.getFrom(options);
        this.brAsParaBreaks = FlexmarkHtmlConverter.BR_AS_PARA_BREAKS.getFrom(options);
        this.brAsExtraBlankLines = FlexmarkHtmlConverter.BR_AS_EXTRA_BLANK_LINES.getFrom(options);
        this.ignoreTableHeadingAfterRows = FlexmarkHtmlConverter.IGNORE_TABLE_HEADING_AFTER_ROWS.getFrom(options);
        this.addTrailingEol = FlexmarkHtmlConverter.ADD_TRAILING_EOL.getFrom(options);
        this.skipHeading1 = FlexmarkHtmlConverter.SKIP_HEADING_1.getFrom(options);
        this.skipHeading2 = FlexmarkHtmlConverter.SKIP_HEADING_2.getFrom(options);
        this.skipHeading3 = FlexmarkHtmlConverter.SKIP_HEADING_3.getFrom(options);
        this.skipHeading4 = FlexmarkHtmlConverter.SKIP_HEADING_4.getFrom(options);
        this.skipHeading5 = FlexmarkHtmlConverter.SKIP_HEADING_5.getFrom(options);
        this.skipHeading6 = FlexmarkHtmlConverter.SKIP_HEADING_6.getFrom(options);
        this.skipAttributes = FlexmarkHtmlConverter.SKIP_ATTRIBUTES.getFrom(options);
        this.skipFencedCode = FlexmarkHtmlConverter.SKIP_FENCED_CODE.getFrom(options);
        this.skipCharEscape = FlexmarkHtmlConverter.SKIP_CHAR_ESCAPE.getFrom(options);
        this.extInlineStrong = FlexmarkHtmlConverter.EXT_INLINE_STRONG.getFrom(options);
        this.extInlineEmphasis = FlexmarkHtmlConverter.EXT_INLINE_EMPHASIS.getFrom(options);
        this.extInlineCode = FlexmarkHtmlConverter.EXT_INLINE_CODE.getFrom(options);
        this.extInlineDel = FlexmarkHtmlConverter.EXT_INLINE_DEL.getFrom(options);
        this.extInlineIns = FlexmarkHtmlConverter.EXT_INLINE_INS.getFrom(options);
        this.extInlineSub = FlexmarkHtmlConverter.EXT_INLINE_SUB.getFrom(options);
        this.extInlineSup = FlexmarkHtmlConverter.EXT_INLINE_SUP.getFrom(options);
        this.extMath = FlexmarkHtmlConverter.EXT_MATH.getFrom(options);
        this.extInlineLink = FlexmarkHtmlConverter.EXT_INLINE_LINK.getFrom(options);
        this.extInlineImage = FlexmarkHtmlConverter.EXT_INLINE_IMAGE.getFrom(options);
        this.orderedListDelimiter = FlexmarkHtmlConverter.ORDERED_LIST_DELIMITER.getFrom(options).charValue();
        this.unorderedListDelimiter = FlexmarkHtmlConverter.UNORDERED_LIST_DELIMITER.getFrom(options).charValue();
        this.definitionMarkerSpaces = FlexmarkHtmlConverter.DEFINITION_MARKER_SPACES.getFrom(options);
        this.minSetextHeadingMarkerLength = Utils.minLimit(FlexmarkHtmlConverter.MIN_SETEXT_HEADING_MARKER_LENGTH.getFrom(options), 3);
        this.codeIndent = FlexmarkHtmlConverter.CODE_INDENT.getFrom(options);
        this.eolInTitleAttribute = FlexmarkHtmlConverter.EOL_IN_TITLE_ATTRIBUTE.getFrom(options);
        this.nbspText = FlexmarkHtmlConverter.NBSP_TEXT.getFrom(options);
        this.thematicBreak = FlexmarkHtmlConverter.THEMATIC_BREAK.getFrom(options);
        this.outputAttributesNamesRegex = FlexmarkHtmlConverter.OUTPUT_ATTRIBUTES_NAMES_REGEX.getFrom(options);
        this.outputAttributesNamesRegexPattern = Pattern.compile(this.outputAttributesNamesRegex);
        this.outputIdAttributeRegex = FlexmarkHtmlConverter.OUTPUT_ID_ATTRIBUTE_REGEX.getFrom(options);
        this.outputIdAttributeRegexPattern = Pattern.compile(this.outputIdAttributeRegex);
        this.tableCellAlignmentMap = FlexmarkHtmlConverter.TABLE_CELL_ALIGNMENT_MAP.getFrom(options);
        this.tableOptions = new TableFormatOptions(options);
        this.formatFlags = FlexmarkHtmlConverter.FORMAT_FLAGS.getFrom(options);
        this.maxBlankLines = FlexmarkHtmlConverter.MAX_BLANK_LINES.getFrom(options);
        this.maxTrailingBlankLines = FlexmarkHtmlConverter.MAX_TRAILING_BLANK_LINES.getFrom(options);
        this.unwrappedTags = FlexmarkHtmlConverter.UNWRAPPED_TAGS.getFrom(options);
        this.wrappedTags = FlexmarkHtmlConverter.WRAPPED_TAGS.getFrom(options);
    }

    @Override
    public MutableDataHolder setIn(MutableDataHolder dataHolder) {
        dataHolder.set(FlexmarkHtmlConverter.LIST_CONTENT_INDENT, this.listContentIndent);
        dataHolder.set(FlexmarkHtmlConverter.SETEXT_HEADINGS, this.setextHeadings);
        dataHolder.set(FlexmarkHtmlConverter.OUTPUT_UNKNOWN_TAGS, this.outputUnknownTags);
        dataHolder.set(FlexmarkHtmlConverter.TYPOGRAPHIC_QUOTES, this.typographicQuotes);
        dataHolder.set(FlexmarkHtmlConverter.TYPOGRAPHIC_SMARTS, this.typographicSmarts);
        dataHolder.set(FlexmarkHtmlConverter.OUTPUT_ATTRIBUTES_ID, this.outputAttributesIdAttr);
        dataHolder.set(FlexmarkHtmlConverter.WRAP_AUTO_LINKS, this.wrapAutoLinks);
        dataHolder.set(FlexmarkHtmlConverter.EXTRACT_AUTO_LINKS, this.extractAutoLinks);
        dataHolder.set(FlexmarkHtmlConverter.RENDER_COMMENTS, this.renderComments);
        dataHolder.set(FlexmarkHtmlConverter.DOT_ONLY_NUMERIC_LISTS, this.dotOnlyNumericLists);
        dataHolder.set(FlexmarkHtmlConverter.COMMENT_ORIGINAL_NON_NUMERIC_LIST_ITEM, this.commentOriginalNonNumericListItem);
        dataHolder.set(FlexmarkHtmlConverter.PRE_CODE_PRESERVE_EMPHASIS, this.preCodePreserveEmphasis);
        dataHolder.set(FlexmarkHtmlConverter.LISTS_END_ON_DOUBLE_BLANK, this.listsEndOnDoubleBlank);
        dataHolder.set(FlexmarkHtmlConverter.DIV_AS_PARAGRAPH, this.divAsParagraph);
        dataHolder.set(FlexmarkHtmlConverter.BR_AS_PARA_BREAKS, this.brAsParaBreaks);
        dataHolder.set(FlexmarkHtmlConverter.BR_AS_EXTRA_BLANK_LINES, this.brAsExtraBlankLines);
        dataHolder.set(FlexmarkHtmlConverter.IGNORE_TABLE_HEADING_AFTER_ROWS, this.ignoreTableHeadingAfterRows);
        dataHolder.set(FlexmarkHtmlConverter.ADD_TRAILING_EOL, this.addTrailingEol);
        dataHolder.set(FlexmarkHtmlConverter.SKIP_HEADING_1, this.skipHeading1);
        dataHolder.set(FlexmarkHtmlConverter.SKIP_HEADING_2, this.skipHeading2);
        dataHolder.set(FlexmarkHtmlConverter.SKIP_HEADING_3, this.skipHeading3);
        dataHolder.set(FlexmarkHtmlConverter.SKIP_HEADING_4, this.skipHeading4);
        dataHolder.set(FlexmarkHtmlConverter.SKIP_HEADING_5, this.skipHeading5);
        dataHolder.set(FlexmarkHtmlConverter.SKIP_HEADING_6, this.skipHeading6);
        dataHolder.set(FlexmarkHtmlConverter.SKIP_ATTRIBUTES, this.skipAttributes);
        dataHolder.set(FlexmarkHtmlConverter.SKIP_FENCED_CODE, this.skipFencedCode);
        dataHolder.set(FlexmarkHtmlConverter.SKIP_CHAR_ESCAPE, this.skipCharEscape);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_STRONG, this.extInlineStrong);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_EMPHASIS, this.extInlineEmphasis);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_CODE, this.extInlineCode);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_DEL, this.extInlineDel);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_INS, this.extInlineIns);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_SUB, this.extInlineSub);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_SUP, this.extInlineSup);
        dataHolder.set(FlexmarkHtmlConverter.ORDERED_LIST_DELIMITER, Character.valueOf(this.orderedListDelimiter));
        dataHolder.set(FlexmarkHtmlConverter.UNORDERED_LIST_DELIMITER, Character.valueOf(this.unorderedListDelimiter));
        dataHolder.set(FlexmarkHtmlConverter.DEFINITION_MARKER_SPACES, this.definitionMarkerSpaces);
        dataHolder.set(FlexmarkHtmlConverter.MIN_SETEXT_HEADING_MARKER_LENGTH, this.minSetextHeadingMarkerLength);
        dataHolder.set(FlexmarkHtmlConverter.CODE_INDENT, this.codeIndent);
        dataHolder.set(FlexmarkHtmlConverter.EOL_IN_TITLE_ATTRIBUTE, this.eolInTitleAttribute);
        dataHolder.set(FlexmarkHtmlConverter.NBSP_TEXT, this.nbspText);
        dataHolder.set(FlexmarkHtmlConverter.THEMATIC_BREAK, this.thematicBreak);
        dataHolder.set(FlexmarkHtmlConverter.OUTPUT_ATTRIBUTES_NAMES_REGEX, this.outputAttributesNamesRegex);
        dataHolder.set(FlexmarkHtmlConverter.TABLE_CELL_ALIGNMENT_MAP, this.tableCellAlignmentMap);
        dataHolder.set(FlexmarkHtmlConverter.OUTPUT_ID_ATTRIBUTE_REGEX, this.outputIdAttributeRegex);
        dataHolder.set(FlexmarkHtmlConverter.EXT_MATH, this.extMath);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_LINK, this.extInlineLink);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_IMAGE, this.extInlineImage);
        dataHolder.setFrom(this.tableOptions);
        dataHolder.set(FlexmarkHtmlConverter.FORMAT_FLAGS, this.formatFlags);
        dataHolder.set(FlexmarkHtmlConverter.MAX_BLANK_LINES, this.maxBlankLines);
        dataHolder.set(FlexmarkHtmlConverter.MAX_TRAILING_BLANK_LINES, this.maxTrailingBlankLines);
        dataHolder.set(FlexmarkHtmlConverter.UNWRAPPED_TAGS, this.unwrappedTags);
        dataHolder.set(FlexmarkHtmlConverter.WRAPPED_TAGS, this.wrappedTags);
        return dataHolder;
    }
}

