/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference;

import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRepository;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferences;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceBlockParser;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceLinkRefProcessor;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceNodeFormatter;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceNodePostProcessor;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceNodeRenderer;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataValueFactory;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;

public class EnumeratedReferenceExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension,
Parser.ReferenceHoldingExtension,
Formatter.FormatterExtension {
    public static final DataKey<KeepType> ENUMERATED_REFERENCES_KEEP = new DataKey<KeepType>("ENUMERATED_REFERENCES_KEEP", KeepType.FIRST);
    public static final DataKey<EnumeratedReferenceRepository> ENUMERATED_REFERENCES = new DataKey<DataValueFactory>("ENUMERATED_REFERENCES", EnumeratedReferenceRepository::new);
    public static final DataKey<EnumeratedReferences> ENUMERATED_REFERENCE_ORDINALS = new DataKey<DataValueFactory>("ENUMERATED_REFERENCE_ORDINALS", EnumeratedReferences::new);
    public static final DataKey<ElementPlacement> ENUMERATED_REFERENCE_PLACEMENT = new DataKey<ElementPlacement>("ENUMERATED_REFERENCE_PLACEMENT", ElementPlacement.AS_IS);
    public static final DataKey<ElementPlacementSort> ENUMERATED_REFERENCE_SORT = new DataKey<ElementPlacementSort>("ENUMERATED_REFERENCE_SORT", ElementPlacementSort.AS_IS);

    private EnumeratedReferenceExtension() {
    }

    public static EnumeratedReferenceExtension create() {
        return new EnumeratedReferenceExtension();
    }

    @Override
    public void rendererOptions(MutableDataHolder options) {
    }

    @Override
    public void parserOptions(MutableDataHolder options) {
    }

    @Override
    public boolean transferReferences(MutableDataHolder document, DataHolder included) {
        if (document.contains(ENUMERATED_REFERENCES) && included.contains(ENUMERATED_REFERENCES)) {
            return Parser.transferReferences(ENUMERATED_REFERENCES.getFrom(document), ENUMERATED_REFERENCES.getFrom(included), ENUMERATED_REFERENCES_KEEP.getFrom(document) == KeepType.FIRST);
        }
        return false;
    }

    @Override
    public void extend(Parser.Builder parserBuilder) {
        parserBuilder.postProcessorFactory(new EnumeratedReferenceNodePostProcessor.Factory());
        parserBuilder.customBlockParserFactory(new EnumeratedReferenceBlockParser.Factory());
        parserBuilder.linkRefProcessorFactory(new EnumeratedReferenceLinkRefProcessor.Factory());
    }

    @Override
    public void extend(Formatter.Builder builder) {
        builder.nodeFormatterFactory(new EnumeratedReferenceNodeFormatter.Factory());
    }

    @Override
    public void extend(HtmlRenderer.Builder rendererBuilder, String rendererType) {
        if (rendererBuilder.isRendererType("HTML")) {
            rendererBuilder.nodeRendererFactory(new EnumeratedReferenceNodeRenderer.Factory());
        } else if (rendererBuilder.isRendererType("JIRA")) {
            // empty if block
        }
    }
}

