/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter.internal;

import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import java.util.Set;

public class MergeLinkResolver
implements LinkResolver {
    private final String docRelativeURL;
    private final String docRootURL;
    private final String[] relativeParts;

    public MergeLinkResolver(LinkResolverContext context) {
        String docRootURL;
        String docRelativeURL = Formatter.DOC_RELATIVE_URL.getFrom(context.getOptions());
        if (docRelativeURL != null) {
            docRelativeURL = Utils.removeStart(docRelativeURL, '/');
        }
        if ((docRootURL = Formatter.DOC_ROOT_URL.getFrom(context.getOptions())) != null) {
            docRootURL = Utils.removeStart(docRootURL, '/');
        }
        this.docRelativeURL = docRelativeURL;
        this.docRootURL = docRootURL;
        this.relativeParts = docRelativeURL.split("/");
    }

    @Override
    public ResolvedLink resolveLink(Node node, LinkResolverContext context, ResolvedLink link) {
        Document document = node.getDocument();
        if (node instanceof Image || node instanceof Link || node instanceof Reference) {
            String url = link.getUrl();
            if (this.docRelativeURL.isEmpty() && this.docRootURL.isEmpty()) {
                return link.withStatus(LinkStatus.VALID).withUrl(url);
            }
            if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://") || url.startsWith("sftp://")) {
                return link.withStatus(LinkStatus.VALID).withUrl(url);
            }
            if (url.startsWith("file:/")) {
                return link.withStatus(LinkStatus.VALID).withUrl(url);
            }
            if (url.startsWith("/")) {
                if (this.docRootURL != null && !this.docRootURL.isEmpty()) {
                    url = (!this.docRootURL.startsWith("/") ? "/" : "") + this.docRootURL + url;
                    return link.withStatus(LinkStatus.VALID).withUrl(url);
                }
            } else if (!url.matches("^(?:[a-z]+:|#|\\?)")) {
                String pageRef = url;
                String suffix = "";
                int pos = url.indexOf(35);
                if (pos == 0) {
                    return link.withStatus(LinkStatus.VALID);
                }
                if (pos > 0) {
                    suffix = url.substring(pos);
                    pageRef = url.substring(0, pos);
                } else if (url.contains("?")) {
                    suffix = url.substring(pos);
                    pageRef = url.substring(0, pos);
                }
                String[] pathParts = pageRef.split("/");
                int docParts = this.relativeParts.length;
                int iMax = pathParts.length;
                StringBuilder resolved = new StringBuilder();
                String sep = "";
                for (int i = 0; i < iMax; ++i) {
                    String part = pathParts[i];
                    if (part.equals(".")) continue;
                    if (part.equals("..")) {
                        if (docParts == 0) {
                            return link;
                        }
                        --docParts;
                        continue;
                    }
                    resolved.append(sep);
                    resolved.append(part);
                    sep = "/";
                }
                StringBuilder resolvedURL = new StringBuilder();
                sep = this.docRelativeURL.startsWith("/") ? "/" : "";
                iMax = docParts;
                for (int i = 0; i < iMax; ++i) {
                    resolvedURL.append(sep);
                    resolvedURL.append(this.relativeParts[i]);
                    sep = "/";
                }
                resolvedURL.append('/').append((CharSequence)resolved).append(suffix);
                return link.withStatus(LinkStatus.VALID).withUrl(resolvedURL.toString());
            }
        }
        return link;
    }

    public static class Factory
    implements LinkResolverFactory {
        @Override
        public Set<Class<? extends LinkResolverFactory>> getAfterDependents() {
            return null;
        }

        @Override
        public Set<Class<? extends LinkResolverFactory>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        public LinkResolver apply(LinkResolverContext context) {
            return new MergeLinkResolver(context);
        }
    }
}

