/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes.internal;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.util.AnchorRefTargetBlockVisitor;
import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributesDelimiter;
import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.attributes.internal.NodeAttributeRepository;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.ExplicitAttributeIdProvider;
import com.vladsch.flexmark.formatter.FormattingPhase;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.MergeContext;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.PhasedNodeFormatter;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.formatter.internal.CoreNodeFormatter;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributesNodeFormatter
implements PhasedNodeFormatter,
ExplicitAttributeIdProvider {
    public static final DataKey<Map<String, String>> ATTRIBUTE_TRANSLATION_MAP = new DataKey("ATTRIBUTE_TRANSLATION_MAP", new HashMap());
    public static final DataKey<Map<String, String>> ATTRIBUTE_TRANSLATED_MAP = new DataKey("ATTRIBUTE_TRANSLATED_MAP", new HashMap());
    public static final DataKey<Map<String, String>> ATTRIBUTE_ORIGINAL_ID_MAP = new DataKey("ATTRIBUTE_ORIGINAL_ID_MAP", new HashMap());
    public static final DataKey<Map<String, String>> ATTRIBUTE_UNIQUIFICATION_ID_MAP = CoreNodeFormatter.ATTRIBUTE_UNIQUIFICATION_ID_MAP;
    public static final DataKey<Map<String, String>> ATTRIBUTE_UNIQUIFICATION_CATEGORY_MAP = new DataKey("ATTRIBUTE_UNIQUIFICATION_CATEGORY_MAP", new HashMap());
    public static final DataKey<Integer> ATTRIBUTE_TRANSLATION_ID = new DataKey<Integer>("ATTRIBUTE_TRANSLATION_ID", 0);
    private Map<String, String> attributeTranslationMap;
    private Map<String, String> attributeTranslatedMap;
    private Map<String, String> attributeOriginalIdMap;
    private Map<String, String> attributeUniquificationIdMap;
    private Map<String, String> attributeCategoryUniquificationMap;
    private int attributeOriginalId;

    public AttributesNodeFormatter(DataHolder options) {
    }

    @Override
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    @Override
    public Set<FormattingPhase> getFormattingPhases() {
        return Collections.singleton(FormattingPhase.COLLECT);
    }

    @Override
    public void addExplicitId(Node node, String id, NodeFormatterContext context, MarkdownWriter markdown) {
        String uniqueId;
        if (node instanceof Heading && context.getRenderPurpose() == RenderPurpose.TRANSLATED && !this.hasIdAttribute(node) && this.attributeUniquificationIdMap != null && !(uniqueId = this.attributeUniquificationIdMap.getOrDefault(id, id)).equals(id)) {
            markdown.append(" {.");
            markdown.append(uniqueId);
            markdown.append("}");
        }
    }

    private boolean hasIdAttribute(Node node) {
        boolean haveIdAttribute = false;
        for (Node child : node.getChildren()) {
            if (!(child instanceof AttributesNode)) continue;
            for (Node attr : child.getChildren()) {
                if (!(attr instanceof AttributeNode) || !((AttributeNode)attr).isId()) continue;
                haveIdAttribute = true;
                break;
            }
            if (!haveIdAttribute) continue;
            break;
        }
        return haveIdAttribute;
    }

    @Override
    public void renderDocument(NodeFormatterContext context, MarkdownWriter markdown, Document document, FormattingPhase phase) {
        if (context.isTransformingText()) {
            context.getTranslationStore().set(ATTRIBUTE_TRANSLATION_ID, 0);
            this.attributeOriginalId = 0;
            if (phase == FormattingPhase.COLLECT && context.getRenderPurpose() == RenderPurpose.TRANSLATION_SPANS) {
                context.getTranslationStore().set(ATTRIBUTE_TRANSLATION_MAP, new HashMap());
                context.getTranslationStore().set(ATTRIBUTE_TRANSLATED_MAP, new HashMap());
                context.getTranslationStore().set(ATTRIBUTE_ORIGINAL_ID_MAP, new HashMap());
                MergeContext mergeContext = context.getMergeContext();
                if (mergeContext != null) {
                    final HashSet mergedUniquified = new HashSet();
                    mergeContext.forEachPrecedingDocument(document, (docContext, doc, index) -> {
                        NodeAttributeRepository attributes = AttributesExtension.NODE_ATTRIBUTES.getFrom(doc);
                        final Map<String, String> idUniquificationMap = docContext.getTranslationStore().get(ATTRIBUTE_UNIQUIFICATION_ID_MAP);
                        for (List list : attributes.values()) {
                            for (AttributesNode attributesNode : list) {
                                for (Node childNode : attributesNode.getChildren()) {
                                    String newKey;
                                    AttributeNode attributeNode;
                                    if (!(childNode instanceof AttributeNode) || !(attributeNode = (AttributeNode)childNode).isId()) continue;
                                    String key = attributeNode.getValue().toString();
                                    String string = newKey = idUniquificationMap == null ? key : idUniquificationMap.getOrDefault(key, key);
                                    if (mergedUniquified.contains(newKey)) {
                                        boolean bl = false;
                                        continue;
                                    }
                                    mergedUniquified.add(newKey);
                                }
                            }
                        }
                        final HtmlIdGenerator generator = context.getIdGenerator();
                        if (generator != null) {
                            new AnchorRefTargetBlockVisitor(){

                                @Override
                                protected void visit(AnchorRefTarget refTarget) {
                                    Node node = (Node)((Object)refTarget);
                                    if (!AttributesNodeFormatter.this.hasIdAttribute(node)) {
                                        String key = generator.getId(node);
                                        if (key == null) {
                                            String text = refTarget.getAnchorRefText();
                                            key = generator.getId(text);
                                            refTarget.setAnchorRefId(key);
                                        }
                                        if (key != null) {
                                            String newKey;
                                            String string = newKey = idUniquificationMap == null ? key : idUniquificationMap.getOrDefault(key, key);
                                            if (mergedUniquified.contains(newKey)) {
                                                boolean bl = false;
                                            } else {
                                                mergedUniquified.add(newKey);
                                            }
                                        }
                                    }
                                }
                            }.visit(document);
                        }
                    });
                    NodeAttributeRepository attributes = AttributesExtension.NODE_ATTRIBUTES.getFrom(document);
                    Map<String, String> idUniquificationMap = context.getTranslationStore().get(ATTRIBUTE_UNIQUIFICATION_ID_MAP);
                    Map<String, String> categoryUniquificationMap = context.getTranslationStore().get(ATTRIBUTE_UNIQUIFICATION_CATEGORY_MAP);
                    final HashMap<String, String> idMap = new HashMap<String, String>();
                    for (List list : attributes.values()) {
                        for (AttributesNode attributesNode : list) {
                            for (Node childNode : attributesNode.getChildren()) {
                                String key;
                                AttributeNode attributeNode;
                                if (!(childNode instanceof AttributeNode) || !(attributeNode = (AttributeNode)childNode).isId()) continue;
                                BasedSequence valueChars = attributeNode.getValue();
                                String useKey = key = valueChars.toString();
                                int pos = valueChars.indexOf(':');
                                if (pos != -1) {
                                    String category = ((BasedSequence)valueChars.subSequence(0, pos)).toString();
                                    String id = ((BasedSequence)valueChars.subSequence(pos + 1)).toString();
                                    String uniqueCategory = category;
                                    if (categoryUniquificationMap != null) {
                                        uniqueCategory = categoryUniquificationMap.getOrDefault(category, category);
                                    }
                                    useKey = String.format("%s:%s", uniqueCategory, id);
                                }
                                int i = 0;
                                String newKey = useKey;
                                while (mergedUniquified.contains(newKey)) {
                                    newKey = String.format("%s%d", useKey, ++i);
                                }
                                if (i <= 0 && newKey.equals(key)) continue;
                                idMap.put(key, newKey);
                            }
                        }
                    }
                    final HtmlIdGenerator generator = context.getIdGenerator();
                    if (generator != null) {
                        new AnchorRefTargetBlockVisitor(){

                            @Override
                            protected void visit(AnchorRefTarget refTarget) {
                                Node node = (Node)((Object)refTarget);
                                if (!AttributesNodeFormatter.this.hasIdAttribute(node)) {
                                    String key = generator.getId(node);
                                    if (key == null) {
                                        String text = refTarget.getAnchorRefText();
                                        key = generator.getId(text);
                                        refTarget.setAnchorRefId(key);
                                    }
                                    if (key != null) {
                                        int i = 0;
                                        String newKey = key;
                                        while (mergedUniquified.contains(newKey)) {
                                            newKey = String.format("%s%d", key, ++i);
                                        }
                                        if (i > 0 || !newKey.equals(key)) {
                                            idMap.put(key, newKey);
                                        }
                                    }
                                }
                            }
                        }.visit(document);
                    }
                    if (!idMap.isEmpty()) {
                        context.getTranslationStore().set(ATTRIBUTE_UNIQUIFICATION_ID_MAP, idMap);
                    }
                }
            }
        }
        this.attributeUniquificationIdMap = context.getTranslationStore().get(ATTRIBUTE_UNIQUIFICATION_ID_MAP);
        this.attributeTranslationMap = context.getTranslationStore().get(ATTRIBUTE_TRANSLATION_MAP);
        this.attributeTranslatedMap = context.getTranslationStore().get(ATTRIBUTE_TRANSLATED_MAP);
        this.attributeOriginalIdMap = context.getTranslationStore().get(ATTRIBUTE_ORIGINAL_ID_MAP);
    }

    @Override
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeFormattingHandler<AttributesNode>(AttributesNode.class, new CustomNodeFormatter<AttributesNode>(){

            @Override
            public void render(AttributesNode node, NodeFormatterContext context, MarkdownWriter markdown) {
                AttributesNodeFormatter.this.render(node, context, markdown);
            }
        }));
        set.add(new NodeFormattingHandler<AttributesDelimiter>(AttributesDelimiter.class, new CustomNodeFormatter<AttributesDelimiter>(){

            @Override
            public void render(AttributesDelimiter node, NodeFormatterContext context, MarkdownWriter markdown) {
                AttributesNodeFormatter.this.render(node, context, markdown);
            }
        }));
        return set;
    }

    public static String getEncodedIdAttribute(String category, String categoryId, NodeFormatterContext context, MarkdownWriter markdown) {
        Map<String, String> idUniquificationMap;
        Map<String, String> attributeTranslationMap = context.getTranslationStore().get(ATTRIBUTE_TRANSLATION_MAP);
        Map<String, String> attributeTranslatedMap = context.getTranslationStore().get(ATTRIBUTE_TRANSLATED_MAP);
        String id = AttributesNodeFormatter.getEncodedIdAttribute(category, categoryId, context, markdown, attributeTranslationMap, attributeTranslatedMap);
        if (context.getRenderPurpose() == RenderPurpose.TRANSLATED && (idUniquificationMap = context.getTranslationStore().get(ATTRIBUTE_UNIQUIFICATION_ID_MAP)) != null && !idUniquificationMap.isEmpty()) {
            String useId = idUniquificationMap.getOrDefault(id, id);
            return useId;
        }
        return id;
    }

    private static String getEncodedIdAttribute(String category, String categoryId, NodeFormatterContext context, MarkdownWriter markdown, Map<String, String> attributeTranslationMap, Map<String, String> attributeTranslatedMap) {
        String encodedCategory = category;
        String encodedId = categoryId;
        int placeholderId = context.getTranslationStore().get(ATTRIBUTE_TRANSLATION_ID);
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: {
                if (!attributeTranslationMap.containsKey(category)) {
                    encodedCategory = String.format(context.getFormatterOptions().translationIdFormat, ++placeholderId);
                    attributeTranslationMap.put(category, encodedCategory);
                    attributeTranslatedMap.put(encodedCategory, category);
                } else {
                    encodedCategory = attributeTranslationMap.get(category);
                }
                if (categoryId != null && !attributeTranslationMap.containsKey(categoryId)) {
                    encodedId = String.format(context.getFormatterOptions().translationIdFormat, ++placeholderId);
                    attributeTranslationMap.put(categoryId, encodedId);
                    attributeTranslatedMap.put(encodedId, categoryId);
                    break;
                }
                encodedId = attributeTranslationMap.get(categoryId);
                break;
            }
            case TRANSLATED_SPANS: {
                break;
            }
            case TRANSLATED: {
                encodedCategory = attributeTranslatedMap.get(category);
                if (categoryId == null) break;
                encodedId = attributeTranslatedMap.get(categoryId);
                break;
            }
        }
        context.getTranslationStore().set(ATTRIBUTE_TRANSLATION_ID, placeholderId);
        if (encodedId == null) {
            return encodedCategory;
        }
        return encodedCategory + ':' + encodedId;
    }

    private String getEncodedOriginalId(String attribute, NodeFormatterContext context) {
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: {
                String encodedAttribute = "#" + String.format(context.getFormatterOptions().translationIdFormat, ++this.attributeOriginalId);
                this.attributeOriginalIdMap.put(encodedAttribute, attribute);
                return encodedAttribute;
            }
            case TRANSLATED_SPANS: {
                return "#" + String.format(context.getFormatterOptions().translationIdFormat, ++this.attributeOriginalId);
            }
            case TRANSLATED: {
                ++this.attributeOriginalId;
                String id = this.attributeOriginalIdMap.get(attribute);
                if (this.attributeUniquificationIdMap != null) {
                    return this.attributeUniquificationIdMap.getOrDefault(id, id);
                }
                return id;
            }
        }
        return attribute;
    }

    void render(AttributesNode node, NodeFormatterContext context, MarkdownWriter markdown) {
        Node previous = node.getPrevious();
        if (!(previous == null || previous.getChars().isContinuedBy(node.getChars()) || previous.getChars().endsWith(" ") || node.getChars().startsWith(" "))) {
            markdown.append(' ');
        }
        if (context.isTransformingText()) {
            markdown.append(node.getOpeningMarker());
            boolean firstChild = true;
            for (Node child : node.getChildren()) {
                AttributeNode attributeNode = (AttributeNode)child;
                if (!firstChild) {
                    markdown.append(' ');
                }
                if (attributeNode.isId()) {
                    BasedSequence valueChars = attributeNode.getValue();
                    int pos = valueChars.indexOf(':');
                    if (pos == -1) {
                        String encodedOriginal = this.getEncodedOriginalId(attributeNode.getChars().toString(), context);
                        if (context.getRenderPurpose() == RenderPurpose.TRANSLATED && !this.attributeUniquificationIdMap.isEmpty()) {
                            String idOnly = encodedOriginal.substring(1);
                            encodedOriginal = "#" + this.attributeUniquificationIdMap.getOrDefault(idOnly, idOnly);
                        }
                        markdown.append(encodedOriginal);
                    } else {
                        String category = ((BasedSequence)valueChars.subSequence(0, pos)).toString();
                        String id = ((BasedSequence)valueChars.subSequence(pos + 1)).toString();
                        String encoded = AttributesNodeFormatter.getEncodedIdAttribute(category, id, context, markdown, this.attributeTranslationMap, this.attributeTranslatedMap);
                        switch (context.getRenderPurpose()) {
                            case TRANSLATION_SPANS: 
                            case TRANSLATED_SPANS: {
                                String encodedAttribute = "#" + encoded;
                                this.attributeOriginalIdMap.put(encodedAttribute, attributeNode.getChars().toString());
                                ((MarkdownWriter)markdown.append('#')).append(encoded);
                                break;
                            }
                            case TRANSLATED: {
                                String encodedOriginal = this.attributeOriginalIdMap.get("#" + valueChars.toString());
                                if (this.attributeUniquificationIdMap != null && !this.attributeUniquificationIdMap.isEmpty()) {
                                    String idOnly = encodedOriginal.substring(1);
                                    encodedOriginal = "#" + this.attributeUniquificationIdMap.getOrDefault(idOnly, idOnly);
                                }
                                markdown.append(encodedOriginal == null ? attributeNode.getChars().toString() : encodedOriginal);
                                break;
                            }
                            default: {
                                markdown.append(attributeNode.getChars());
                            }
                        }
                    }
                } else {
                    markdown.appendNonTranslating(".", attributeNode.getChars());
                }
                firstChild = false;
            }
            markdown.append(node.getClosingMarker());
        } else {
            markdown.append(node.getChars());
        }
        Node next = node.getNext();
        if (!(next == null || next instanceof AttributesNode || node.getChars().isContinuedBy(next.getChars()) || node.getChars().endsWith(" ") || next.getChars().startsWith(" "))) {
            markdown.append(' ');
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        @Override
        public NodeFormatter create(DataHolder options) {
            return new AttributesNodeFormatter(options);
        }
    }
}

