/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.Pair;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.html.LineFormattingAppendable;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.SubSequence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class LineFormattingAppendableImpl
implements LineFormattingAppendable {
    private static final char EOL = '\n';
    private final boolean myPassThrough;
    private int myOptions;
    private int myPreFormattedNesting;
    private int myPreFormattedFirstLine;
    private int myPreFormattedFirstLineOffset;
    private int myPreFormattedLastLine;
    private int myPreFormattedLastLineOffset;
    private StringBuilder myAppendable;
    private final ArrayList<BasedSequence> myLines;
    private final ArrayList<BasedSequence> myPrefixes;
    private int myTextLength;
    private int myPrefixLength;
    private BasedSequence myPrefix;
    private BasedSequence myPrefixAfterEol;
    private BasedSequence myIndentPrefix;
    private final Stack<BasedSequence> myPrefixStack;
    private final Stack<Boolean> myIndentPrefixStack;
    private int myLineStart;
    private boolean myAllWhitespace;
    private boolean myWasWhitespace;
    private int myLineOnFirstText;
    private ArrayList<Runnable> myIndentsOnFirstEol;

    public LineFormattingAppendableImpl(int formatOptions) {
        this.myOptions = formatOptions;
        this.myPassThrough = this.haveOptions(16);
        this.myPreFormattedNesting = 0;
        this.myPreFormattedFirstLine = -1;
        this.myPreFormattedLastLine = -1;
        this.myLineStart = 0;
        this.myTextLength = 0;
        this.myPrefixLength = 0;
        this.myAllWhitespace = true;
        this.myWasWhitespace = false;
        this.myAppendable = new StringBuilder();
        this.myLines = new ArrayList();
        this.myPrefixes = new ArrayList();
        this.myPrefixStack = new Stack();
        this.myIndentPrefixStack = new Stack();
        this.myPrefix = BasedSequence.EMPTY;
        this.myPrefixAfterEol = BasedSequence.EMPTY;
        this.myIndentPrefix = BasedSequence.EMPTY;
        this.myLineOnFirstText = 0;
        this.myIndentsOnFirstEol = new ArrayList();
    }

    @Override
    public int getOptions() {
        return this.myOptions;
    }

    @Override
    public LineFormattingAppendable setOptions(int options) {
        this.myOptions = options;
        return this;
    }

    private boolean haveOptions(int options) {
        return (this.myOptions & options) != 0;
    }

    private boolean isConvertingTabs() {
        return this.haveOptions(3);
    }

    private boolean isSuppressingTrailingWhitespace() {
        return this.haveOptions(4);
    }

    private boolean isAllowLeadingWhitespace() {
        return this.haveOptions(32);
    }

    private boolean isCollapseWhitespace() {
        return this.haveOptions(2);
    }

    @Override
    public CharSequence getIndentPrefix() {
        return this.myIndentPrefix;
    }

    @Override
    public LineFormattingAppendable setIndentPrefix(CharSequence prefix) {
        this.myIndentPrefix = prefix == null ? BasedSequence.NULL : BasedSequenceImpl.of(prefix);
        return this;
    }

    @Override
    public CharSequence getPrefix() {
        return this.myPrefixAfterEol;
    }

    @Override
    public LineFormattingAppendable addPrefix(CharSequence prefix, boolean afterEol) {
        if (!this.myPassThrough) {
            this.myPrefixAfterEol = afterEol ? this.combinedPrefix(this.myPrefixAfterEol, prefix) : (this.myPrefix = this.combinedPrefix(this.myPrefixAfterEol, prefix));
        }
        return this;
    }

    @Override
    public LineFormattingAppendable setPrefix(CharSequence prefix, boolean afterEol) {
        if (!this.myPassThrough) {
            this.myPrefixAfterEol = afterEol ? (prefix == null ? BasedSequence.NULL : BasedSequenceImpl.of(prefix)) : (this.myPrefix = prefix == null ? BasedSequence.NULL : BasedSequenceImpl.of(prefix));
        }
        return this;
    }

    @Override
    public LineFormattingAppendable indent() {
        if (!this.myPassThrough) {
            this.line();
            this.rawIndent();
        }
        return this;
    }

    private void rawIndent() {
        this.myPrefixStack.push(this.myPrefixAfterEol);
        this.myPrefixAfterEol = this.myPrefix = this.combinedPrefix(this.myPrefixAfterEol, this.myIndentPrefix);
        this.myIndentPrefixStack.push(true);
    }

    private void rawUnIndent() {
        if (this.myPrefixStack.isEmpty()) {
            throw new IllegalStateException("unIndent with an empty stack");
        }
        if (!this.myIndentPrefixStack.peek().booleanValue()) {
            throw new IllegalStateException("unIndent for element added by pushPrefix(), use popPrefix() instead");
        }
        this.myPrefixAfterEol = this.myPrefix = this.myPrefixStack.pop();
        this.myIndentPrefixStack.pop();
    }

    @Override
    public LineFormattingAppendable unIndent() {
        if (!this.myPassThrough) {
            this.line();
            this.rawUnIndent();
        }
        return this;
    }

    @Override
    public LineFormattingAppendable unIndentNoEol() {
        if (!this.myPassThrough) {
            if (this.isLastEol()) {
                this.rawUnIndent();
            } else {
                BasedSequence prefix = this.myPrefix;
                this.rawUnIndent();
                this.myPrefixAfterEol = this.myPrefix;
                this.myPrefix = prefix;
            }
        }
        return this;
    }

    @Override
    public LineFormattingAppendable pushPrefix() {
        if (!this.myPassThrough) {
            this.myPrefixStack.push(this.myPrefixAfterEol);
            this.myIndentPrefixStack.push(false);
        }
        return this;
    }

    @Override
    public LineFormattingAppendable popPrefix(boolean afterEol) {
        if (!this.myPassThrough) {
            if (this.myPrefixStack.isEmpty()) {
                throw new IllegalStateException("popPrefix with an empty stack");
            }
            if (this.myIndentPrefixStack.peek().booleanValue()) {
                throw new IllegalStateException("popPrefix for element added by indent(), use unIndent() instead");
            }
            this.myPrefixAfterEol = this.myPrefixStack.pop();
            if (!afterEol) {
                this.myPrefix = this.myPrefixAfterEol;
            }
            this.myIndentPrefixStack.pop();
        }
        return this;
    }

    private boolean isTrailingBlankLine() {
        int i = this.myLines.size();
        if (i-- > 0) {
            BasedSequence line = this.myLines.get(i);
            return line.isBlank();
        }
        return this.myAppendable.length() == 0;
    }

    private int lastNonBlankLine() {
        BasedSequence line;
        int i = this.myLines.size();
        while (i-- > 0 && (line = this.myLines.get(i)).isBlank()) {
        }
        return i + 1;
    }

    private int trailingBlankLines() {
        return this.myLines.size() - this.lastNonBlankLine();
    }

    private boolean isLastEol() {
        return this.myAppendable.length() > 0 && this.myAppendable.charAt(this.myAppendable.length() - 1) == '\n';
    }

    private void addLineRange(Range range, BasedSequence prefix) {
        assert (range.getStart() <= range.getEnd());
        this.myLines.add(range.isNull() ? BasedSequence.NULL : range.subSequence(this.myAppendable));
        if (range.isEmpty() && !prefix.isEmpty()) {
            prefix = (BasedSequence)prefix.trimEnd();
            this.myPrefixes.add(prefix);
        } else {
            this.myPrefixes.add(prefix);
        }
        this.myTextLength += range.getSpan() + 1;
        this.myPrefixLength += prefix.length();
    }

    private void appendEol() {
        this.myAppendable.append('\n');
        int startOffset = this.myLineStart;
        int endOffset = this.myLineStart = this.myAppendable.length();
        this.addLineRange(new Range(startOffset, endOffset - 1), this.myPrefix);
        this.myAllWhitespace = true;
        this.myWasWhitespace = false;
        this.myLineOnFirstText = 0;
        this.rawIndentsOnFirstEol();
    }

    private void rawIndentsOnFirstEol() {
        this.myPrefix = this.myPrefixAfterEol;
        while (!this.myIndentsOnFirstEol.isEmpty()) {
            Runnable runnable = this.myIndentsOnFirstEol.remove(this.myIndentsOnFirstEol.size() - 1);
            this.rawIndent();
            runnable.run();
        }
    }

    private void appendEol(int count) {
        while (count-- > 0) {
            this.appendEol();
        }
    }

    private Pair<Range, BasedSequence> getRangePrefixAfterEol() {
        int startOffset;
        boolean needPrefix;
        int endOffset = this.myAppendable.length() + 1;
        int currentLine = this.getLineCount();
        boolean bl = needPrefix = this.haveOptions(128) || this.myPreFormattedNesting == 0 && this.myPreFormattedLastLine != currentLine || this.myPreFormattedFirstLine == currentLine;
        if (this.myPassThrough) {
            return new Pair<Range, BasedSequence>(new Range(startOffset, endOffset - 1), needPrefix ? this.myPrefix : BasedSequence.NULL);
        }
        if (this.myAllWhitespace && this.myPreFormattedNesting == 0 && this.myPreFormattedFirstLine != currentLine && this.myPreFormattedLastLine != currentLine) {
            if (this.haveOptions(64) && this.myAppendable.length() == 0) {
                return new Pair<Range, BasedSequence>(new Range(startOffset, endOffset - 1), needPrefix ? this.myPrefix : BasedSequence.NULL);
            }
            return new Pair<Range, BasedSequence>(Range.NULL, BasedSequence.NULL);
        }
        if (!(this.haveOptions(32) || this.myPreFormattedNesting != 0 && this.myPreFormattedFirstLine != currentLine || this.myPreFormattedNesting != 0 || this.myPreFormattedLastLine == currentLine)) {
            if (this.myAllWhitespace) {
                startOffset = endOffset - 1;
            } else {
                for (startOffset = this.myLineStart; startOffset < endOffset && this.myAppendable.charAt(startOffset) == ' '; ++startOffset) {
                }
            }
        }
        if (this.haveOptions(4) && this.myPreFormattedNesting == 0) {
            if (this.myAllWhitespace) {
                startOffset = endOffset - 1;
            } else {
                while (startOffset < endOffset - 1 && this.myAppendable.charAt(endOffset - 2) == ' ') {
                    --endOffset;
                }
            }
        }
        if (this.myPreFormattedFirstLine == currentLine && startOffset > this.myPreFormattedFirstLineOffset) {
            startOffset = this.myPreFormattedFirstLineOffset;
        }
        if (this.myPreFormattedLastLine == currentLine && endOffset < this.myPreFormattedLastLineOffset + 1) {
            endOffset = this.myPreFormattedLastLineOffset + 1;
        }
        return new Pair<Range, BasedSequence>(new Range(startOffset, endOffset - 1), needPrefix ? this.myPrefix : BasedSequence.NULL);
    }

    private int offsetAfterEol(boolean includePrefixes) {
        Pair<Range, BasedSequence> rangePrefixAfterEol = this.getRangePrefixAfterEol();
        if (rangePrefixAfterEol.getFirst().isNull()) {
            return includePrefixes ? this.myTextLength + this.myPrefixLength : this.myTextLength;
        }
        Range range = rangePrefixAfterEol.getFirst();
        BasedSequence prefix = rangePrefixAfterEol.getSecond();
        if (range.isEmpty() && !prefix.isEmpty()) {
            prefix = (BasedSequence)prefix.trimEnd();
        }
        return includePrefixes ? this.myTextLength + rangePrefixAfterEol.getFirst().getSpan() + this.myPrefixLength + prefix.length() : this.myTextLength + rangePrefixAfterEol.getFirst().getSpan();
    }

    private void appendImpl(char c) {
        if (this.myPassThrough) {
            if (c == '\n') {
                this.appendEol();
            } else {
                if (this.myLineOnFirstText > 0) {
                    this.myLineOnFirstText = 0;
                    this.appendEol();
                }
                if (c != '\t' && c != ' ') {
                    this.myAllWhitespace = false;
                }
                this.myAppendable.append(c);
            }
        } else if (c == '\n') {
            Pair<Range, BasedSequence> rangePrefixAfterEol = this.getRangePrefixAfterEol();
            if (rangePrefixAfterEol.getFirst().isNull()) {
                this.myAppendable.append(c);
                this.myLineStart = this.myAppendable.length();
                this.myAllWhitespace = true;
                this.myWasWhitespace = false;
                this.rawIndentsOnFirstEol();
            } else {
                this.myAppendable.append(c);
                this.myLineStart = this.myAppendable.length();
                this.addLineRange(rangePrefixAfterEol.getFirst(), rangePrefixAfterEol.getSecond());
                this.myAllWhitespace = true;
                this.myWasWhitespace = false;
                this.rawIndentsOnFirstEol();
            }
        } else {
            if (this.myLineOnFirstText > 0) {
                this.myLineOnFirstText = 0;
                this.appendEol();
            }
            if (c == '\t') {
                if (this.myPreFormattedNesting == 0 && this.haveOptions(2)) {
                    if (!this.myWasWhitespace) {
                        this.myAppendable.append(' ');
                        this.myWasWhitespace = true;
                    }
                } else if (this.haveOptions(1)) {
                    int column = this.myAppendable.length() - this.myLineStart;
                    int spaces = 4 - column % 4;
                    this.myAppendable.append("    ", 0, spaces);
                } else {
                    this.myAppendable.append(c);
                }
            } else if (c == ' ') {
                if (this.myPreFormattedNesting == 0 && this.haveOptions(2)) {
                    if (!this.myWasWhitespace) {
                        this.myAppendable.append(' ');
                    }
                } else {
                    this.myAppendable.append(' ');
                }
                this.myWasWhitespace = true;
            } else {
                this.myAllWhitespace = false;
                this.myWasWhitespace = false;
                this.myAppendable.append(c);
            }
        }
    }

    private void appendImpl(CharSequence csq, int start, int end) {
        int i = start;
        while (i < end) {
            this.appendImpl(csq.charAt(i++));
        }
    }

    @Override
    public LineFormattingAppendable append(CharSequence csq) {
        this.appendImpl(csq, 0, csq.length());
        return this;
    }

    @Override
    public LineFormattingAppendable append(CharSequence csq, int start, int end) {
        this.appendImpl(csq, start, end);
        return this;
    }

    @Override
    public LineFormattingAppendable append(char c) {
        this.appendImpl(c);
        return this;
    }

    @Override
    public LineFormattingAppendable repeat(char c, int count) {
        int i = count;
        while (i-- > 0) {
            this.append(c);
        }
        return this;
    }

    @Override
    public LineFormattingAppendable repeat(CharSequence csq, int count) {
        int i = count;
        while (i-- > 0) {
            this.append(csq);
        }
        return this;
    }

    @Override
    public LineFormattingAppendable repeat(CharSequence csq, int start, int end, int count) {
        int i = count;
        while (i-- > 0) {
            this.append(csq, start, end);
        }
        return this;
    }

    private BasedSequence combinedPrefix(CharSequence prefix, CharSequence suffix) {
        if (prefix != null && prefix.length() > 0 && suffix != null && suffix.length() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append(suffix);
            return BasedSequenceImpl.of(sb.toString());
        }
        if (prefix != null && prefix.length() > 0) {
            return BasedSequenceImpl.of(prefix);
        }
        if (suffix != null && suffix.length() > 0) {
            return BasedSequenceImpl.of(suffix);
        }
        return BasedSequence.NULL;
    }

    @Override
    public boolean isPreFormattedLine(int line) {
        return this.getLinePrefix(line).isNull();
    }

    @Override
    public LineFormattingAppendable append(LineFormattingAppendable lineAppendable, int startLine, int endLine) {
        List<CharSequence> lines = lineAppendable.getLineContents(startLine, endLine);
        List<BasedSequence> prefixes = lineAppendable.getLinePrefixes(startLine, endLine);
        int iMax = lines.size();
        for (int i = 0; i < iMax; ++i) {
            CharSequence line = lines.get(i);
            BasedSequence prefix = prefixes.get(i);
            int startOffset = this.myAppendable.length();
            this.myAppendable.append(line);
            this.myAppendable.append('\n');
            int endOffset = this.myAppendable.length();
            BasedSequence combinedPrefix = this.haveOptions(128) || !lineAppendable.isPreFormattedLine(startLine + i) ? this.combinedPrefix(this.myPrefix, prefix) : SubSequence.NULL;
            this.addLineRange(new Range(startOffset, endOffset - 1), combinedPrefix);
            this.myLineStart = endOffset;
        }
        return this;
    }

    @Override
    public LineFormattingAppendable prefixLines(CharSequence prefix, boolean addAfterLinePrefix, int startLine, int endLine) {
        int useStartLine = Utils.minLimit(startLine, 0);
        int useEndLine = Utils.maxLimit(endLine, this.getLineCount());
        if (prefix != null && prefix.length() > 0 && useStartLine < useEndLine) {
            BasedSequence lastLinePrefix = BasedSequence.NULL;
            BasedSequence lastPrefix = addAfterLinePrefix ? this.combinedPrefix(lastLinePrefix, prefix) : this.combinedPrefix(prefix, lastLinePrefix);
            for (int i = useStartLine; i < useEndLine; ++i) {
                BasedSequence linePrefix = this.myPrefixes.get(i);
                if (this.haveOptions(128) || !this.isPreFormattedLine(i)) {
                    if (!linePrefix.equals(lastLinePrefix)) {
                        lastLinePrefix = linePrefix;
                        lastPrefix = addAfterLinePrefix ? this.combinedPrefix(lastLinePrefix, prefix) : this.combinedPrefix(prefix, lastLinePrefix);
                    }
                    this.myPrefixes.set(i, lastPrefix);
                    continue;
                }
                this.myPrefixes.set(i, SubSequence.NULL);
            }
        }
        return this;
    }

    @Override
    public LineFormattingAppendable removeLines(int startLine, int endLine) {
        int useStartLine = Utils.minLimit(startLine, 0);
        int useEndLine = Utils.maxLimit(endLine, this.getLineCount());
        if (useStartLine < useEndLine) {
            int count = useEndLine - useStartLine;
            while (count-- > 0) {
                BasedSequence line = this.myLines.remove(startLine);
                BasedSequence prefix = this.myPrefixes.remove(startLine);
                this.myTextLength -= line.length() + 1;
                this.myPrefixLength -= prefix.length();
            }
        }
        return this;
    }

    @Override
    public String toString(int maxBlankLines) {
        if (this.myPassThrough) {
            this.line();
            return this.myAppendable.toString();
        }
        StringBuilder out = new StringBuilder();
        try {
            this.appendTo(out, maxBlankLines);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    @Override
    public List<CharSequence> getLineContents(int startOffset, int endOffset) {
        this.line();
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        int iMax = Utils.maxLimit(endOffset, this.myLines.size());
        for (int i = startOffset; i < iMax; ++i) {
            BasedSequence line = this.myLines.get(i);
            result.add(line);
        }
        return result;
    }

    @Override
    public List<BasedSequence> getLinePrefixes(int startOffset, int endOffset) {
        this.line();
        ArrayList<BasedSequence> result = new ArrayList<BasedSequence>();
        int iMax = Utils.maxLimit(endOffset, this.myLines.size());
        for (int i = startOffset; i < iMax; ++i) {
            result.add(this.myPrefixes.get(i));
        }
        return result;
    }

    @Override
    public List<CharSequence> getLines(int startOffset, int endOffset) {
        this.line();
        StringBuilder sb = new StringBuilder();
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        int iMax = Utils.maxLimit(endOffset, this.myLines.size());
        for (int i = startOffset; i < iMax; ++i) {
            BasedSequence line = this.myLines.get(i);
            BasedSequence linePrefix = this.myPrefixes.get(i);
            int lineStart = sb.length();
            if (!linePrefix.isEmpty()) {
                sb.append(linePrefix);
            }
            sb.append(line);
            result.add(sb.subSequence(lineStart, sb.length()));
        }
        return result;
    }

    @Override
    public LineFormattingAppendable appendTo(Appendable out, int maxBlankLines, CharSequence prefix, int startLine, int endLine) throws IOException {
        this.line();
        int removeBlankLines = Utils.minLimit(this.trailingBlankLines() - Utils.minLimit(maxBlankLines, 0), 0);
        int iMax = Utils.min(endLine, this.myLines.size() - removeBlankLines);
        for (int i = startLine; i < iMax; ++i) {
            BasedSequence line = this.myLines.get(i);
            BasedSequence linePrefix = this.myPrefixes.get(i);
            if (!linePrefix.isEmpty()) {
                out.append(linePrefix);
            }
            if (prefix != null && prefix.length() > 0) {
                out.append(prefix);
            }
            out.append(line);
            if (maxBlankLines == -1 && i + 1 == iMax) continue;
            out.append('\n');
        }
        return this;
    }

    @Override
    public LineFormattingAppendable line() {
        if (this.myPreFormattedNesting > 0 || this.myLineStart < this.myAppendable.length() || this.haveOptions(64)) {
            this.appendImpl('\n');
        } else {
            this.rawIndentsOnFirstEol();
        }
        return this;
    }

    @Override
    public LineFormattingAppendable lineWithTrailingSpaces(int count) {
        if (this.myPreFormattedNesting > 0 || this.myLineStart < this.myAppendable.length() || this.haveOptions(64)) {
            int options = this.myOptions;
            this.myOptions &= 0xFFFFFFF9;
            if (count > 0) {
                this.repeat(' ', count);
            }
            this.appendImpl('\n');
            this.myOptions = options;
        }
        return this;
    }

    @Override
    public LineFormattingAppendable addLine() {
        this.appendImpl('\n');
        return this;
    }

    @Override
    public LineFormattingAppendable lineIf(boolean predicate) {
        if (predicate) {
            this.line();
        }
        return this;
    }

    @Override
    public LineFormattingAppendable blankLine() {
        this.line();
        if (!this.isTrailingBlankLine()) {
            this.appendEol();
        }
        return this;
    }

    @Override
    public LineFormattingAppendable blankLineIf(boolean predicate) {
        if (predicate) {
            this.blankLine();
        }
        return this;
    }

    @Override
    public LineFormattingAppendable blankLine(int count) {
        this.line();
        int addBlankLines = count - this.trailingBlankLines();
        this.appendEol(addBlankLines);
        return this;
    }

    @Override
    public int getLineCount() {
        return this.myLines.size();
    }

    @Override
    public int column() {
        return this.myAppendable.length() - this.myLineStart;
    }

    @Override
    public int offset() {
        return this.myTextLength + this.myPrefixLength;
    }

    @Override
    public int offsetWithPending() {
        return this.offsetAfterEol(true);
    }

    @Override
    public int textOnlyOffset() {
        return this.myTextLength;
    }

    @Override
    public int textOnlyOffsetWithPending() {
        return this.offsetAfterEol(false);
    }

    @Override
    public boolean isPendingSpace() {
        return this.myAppendable.length() > 0 && " \t".indexOf(this.myAppendable.charAt(this.myAppendable.length() - 1)) != -1;
    }

    @Override
    public int getPendingSpace() {
        int length = this.myAppendable.length();
        if (length == 0) {
            return 0;
        }
        int spaces = 0;
        while (length-- > 0 && " \t".indexOf(this.myAppendable.charAt(length)) != -1) {
            ++spaces;
        }
        return spaces;
    }

    @Override
    public int getPendingEOL() {
        int withPending = this.textOnlyOffsetWithPending();
        if (withPending == this.myTextLength) {
            return this.trailingBlankLines() + 1;
        }
        return 0;
    }

    @Override
    public boolean isPreFormatted() {
        return this.myPreFormattedNesting > 0;
    }

    @Override
    public LineFormattingAppendable openPreFormatted(boolean addPrefixToFirstLine) {
        if (this.myPreFormattedNesting == 0 && this.myPreFormattedFirstLine != this.myLines.size()) {
            this.myPreFormattedFirstLine = this.myLines.size();
            this.myPreFormattedFirstLineOffset = this.myAppendable.length();
        }
        ++this.myPreFormattedNesting;
        return this;
    }

    @Override
    public LineFormattingAppendable closePreFormatted() {
        if (this.myPreFormattedNesting <= 0) {
            throw new IllegalStateException("closePreFormatted called with nesting == 0");
        }
        --this.myPreFormattedNesting;
        if (this.myPreFormattedNesting == 0 && !this.isLastEol()) {
            this.myPreFormattedLastLine = this.myLines.size();
            this.myPreFormattedLastLineOffset = this.myAppendable.length();
        }
        return this;
    }

    public String toString() {
        return this.myAppendable.toString();
    }

    @Override
    public LineFormattingAppendable lineOnFirstText(boolean value) {
        if (value) {
            ++this.myLineOnFirstText;
        } else if (this.myLineOnFirstText > 0) {
            --this.myLineOnFirstText;
        }
        return this;
    }

    @Override
    public LineFormattingAppendable removeIndentOnFirstEOL(Runnable runnable) {
        this.myIndentsOnFirstEol.remove(runnable);
        return this;
    }

    @Override
    public LineFormattingAppendable addIndentOnFirstEOL(Runnable runnable) {
        this.myIndentsOnFirstEol.add(runnable);
        return this;
    }
}

