/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.convert.html;

import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.convert.html.ExtensionConversion;
import com.vladsch.flexmark.convert.html.HtmlParserOptions;
import com.vladsch.flexmark.convert.html.LinkConversion;
import com.vladsch.flexmark.ext.emoji.internal.EmojiReference;
import com.vladsch.flexmark.ext.emoji.internal.EmojiShortcuts;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.Ref;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.format.MarkdownTable;
import com.vladsch.flexmark.util.format.RomanNumeral;
import com.vladsch.flexmark.util.format.TableCell;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.format.options.TableCaptionHandling;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.html.LineFormattingAppendable;
import com.vladsch.flexmark.util.html.LineFormattingAppendableImpl;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;
import com.vladsch.flexmark.util.sequence.SubSequence;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

@Deprecated
public class FlexmarkHtmlParser {
    public static final DataKey<Boolean> LIST_CONTENT_INDENT = new DataKey<Boolean>("LIST_CONTENT_INDENT", true);
    public static final DataKey<Boolean> SETEXT_HEADINGS = new DataKey<Boolean>("SETEXT_HEADINGS", true);
    public static final DataKey<Boolean> OUTPUT_UNKNOWN_TAGS = new DataKey<Boolean>("OUTPUT_UNKNOWN_TAGS", false);
    public static final DataKey<Boolean> TYPOGRAPHIC_QUOTES = new DataKey<Boolean>("TYPOGRAPHIC_QUOTES", true);
    public static final DataKey<Boolean> TYPOGRAPHIC_SMARTS = new DataKey<Boolean>("TYPOGRAPHIC_SMARTS", true);
    public static final DataKey<Boolean> EXTRACT_AUTO_LINKS = new DataKey<Boolean>("EXTRACT_AUTO_LINKS", true);
    public static final DataKey<Boolean> OUTPUT_ATTRIBUTES_ID = new DataKey<Boolean>("OUTPUT_ATTRIBUTES_ID", true);
    public static final DataKey<String> OUTPUT_ATTRIBUTES_NAMES_REGEX = new DataKey<String>("OUTPUT_ATTRIBUTES_NAMES_REGEX", "");
    public static final DataKey<Boolean> WRAP_AUTO_LINKS = new DataKey<Boolean>("WRAP_AUTO_LINKS", true);
    public static final DataKey<Boolean> RENDER_COMMENTS = new DataKey<Boolean>("RENDER_COMMENTS", false);
    public static final DataKey<Boolean> DOT_ONLY_NUMERIC_LISTS = new DataKey<Boolean>("DOT_ONLY_NUMERIC_LISTS", true);
    public static final DataKey<Boolean> COMMENT_ORIGINAL_NON_NUMERIC_LIST_ITEM = new DataKey<Boolean>("COMMENT_ORIGINAL_NON_NUMERIC_LIST_ITEM", false);
    public static final DataKey<Boolean> PRE_CODE_PRESERVE_EMPHASIS = new DataKey<Boolean>("PRE_CODE_PRESERVE_EMPHASIS", false);
    public static final DataKey<Character> ORDERED_LIST_DELIMITER = new DataKey<Character>("ORDERED_LIST_DELIMITER", Character.valueOf('.'));
    public static final DataKey<Character> UNORDERED_LIST_DELIMITER = new DataKey<Character>("UNORDERED_LIST_DELIMITER", Character.valueOf('*'));
    public static final DataKey<Integer> DEFINITION_MARKER_SPACES = new DataKey<Integer>("DEFINITION_MARKER_SPACES", 3);
    public static final DataKey<Integer> MIN_SETEXT_HEADING_MARKER_LENGTH = new DataKey<Integer>("MIN_SETEXT_HEADING_MARKER_LENGTH", 3);
    public static final DataKey<String> CODE_INDENT = new DataKey<String>("CODE_INDENT", "    ");
    public static final DataKey<String> NBSP_TEXT = new DataKey<String>("NBSP_TEXT", " ");
    public static final DataKey<String> EOL_IN_TITLE_ATTRIBUTE = new DataKey<String>("EOL_IN_TITLE_ATTRIBUTE", " ");
    public static final DataKey<String> THEMATIC_BREAK = new DataKey<String>("THEMATIC_BREAK", "*** ** * ** ***");
    public static final DataKey<String> OUTPUT_ID_ATTRIBUTE_REGEX = new DataKey<String>("OUTPUT_ID_ATTRIBUTE_REGEX", "^user-content-(.*)$");
    public static final DataKey<Integer> TABLE_MIN_SEPARATOR_COLUMN_WIDTH = TableFormatOptions.FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH;
    public static final DataKey<Integer> TABLE_MIN_SEPARATOR_DASHES = TableFormatOptions.FORMAT_TABLE_MIN_SEPARATOR_DASHES;
    public static final DataKey<Boolean> TABLE_LEAD_TRAIL_PIPES = TableFormatOptions.FORMAT_TABLE_LEAD_TRAIL_PIPES;
    public static final DataKey<Boolean> TABLE_SPACE_AROUND_PIPES = TableFormatOptions.FORMAT_TABLE_SPACE_AROUND_PIPES;
    public static final DataKey<TableCaptionHandling> TABLE_CAPTION = TableFormatOptions.FORMAT_TABLE_CAPTION;
    public static final DataKey<Boolean> LISTS_END_ON_DOUBLE_BLANK = new DataKey<Boolean>("LISTS_END_ON_DOUBLE_BLANK", false);
    public static final DataKey<Boolean> DIV_AS_PARAGRAPH = new DataKey<Boolean>("DIV_AS_PARAGRAPH", false);
    public static final DataKey<Boolean> BR_AS_PARA_BREAKS = new DataKey<Boolean>("BR_AS_PARA_BREAKS", true);
    public static final DataKey<Boolean> BR_AS_EXTRA_BLANK_LINES = new DataKey<Boolean>("BR_AS_EXTRA_BLANK_LINES", true);
    public static final DataKey<Boolean> ADD_TRAILING_EOL = new DataKey<Boolean>("ADD_TRAILING_EOL", true);
    @Deprecated
    public static final DataKey<Boolean> SKIP_INLINE_STRONG = new DataKey<Boolean>("SKIP_INLINE_STRONG", false);
    @Deprecated
    public static final DataKey<Boolean> SKIP_INLINE_EMPHASIS = new DataKey<Boolean>("SKIP_INLINE_EMPHASIS", false);
    @Deprecated
    public static final DataKey<Boolean> SKIP_INLINE_CODE = new DataKey<Boolean>("SKIP_INLINE_CODE", false);
    @Deprecated
    public static final DataKey<Boolean> SKIP_INLINE_DEL = new DataKey<Boolean>("SKIP_INLINE_DEL", false);
    @Deprecated
    public static final DataKey<Boolean> SKIP_INLINE_INS = new DataKey<Boolean>("SKIP_INLINE_INS", false);
    @Deprecated
    public static final DataKey<Boolean> SKIP_INLINE_SUB = new DataKey<Boolean>("SKIP_INLINE_SUB", false);
    @Deprecated
    public static final DataKey<Boolean> SKIP_INLINE_SUP = new DataKey<Boolean>("SKIP_INLINE_SUP", false);
    @Deprecated
    public static final DataKey<Boolean> SKIP_LINKS = new DataKey<Boolean>("SKIP_LINKS", false);
    public static final DataKey<Boolean> SKIP_HEADING_1 = new DataKey<Boolean>("SKIP_HEADING_1", false);
    public static final DataKey<Boolean> SKIP_HEADING_2 = new DataKey<Boolean>("SKIP_HEADING_2", false);
    public static final DataKey<Boolean> SKIP_HEADING_3 = new DataKey<Boolean>("SKIP_HEADING_3", false);
    public static final DataKey<Boolean> SKIP_HEADING_4 = new DataKey<Boolean>("SKIP_HEADING_4", false);
    public static final DataKey<Boolean> SKIP_HEADING_5 = new DataKey<Boolean>("SKIP_HEADING_5", false);
    public static final DataKey<Boolean> SKIP_HEADING_6 = new DataKey<Boolean>("SKIP_HEADING_6", false);
    public static final DataKey<Boolean> SKIP_ATTRIBUTES = new DataKey<Boolean>("SKIP_ATTRIBUTES", false);
    public static final DataKey<Boolean> SKIP_FENCED_CODE = new DataKey<Boolean>("SKIP_FENCED_CODE", false);
    public static final DataKey<Boolean> SKIP_CHAR_ESCAPE = new DataKey<Boolean>("SKIP_CHAR_ESCAPE", false);
    public static final DataKey<ExtensionConversion> EXT_INLINE_STRONG = new DataKey<ExtensionConversion>("EXT_INLINE_STRONG", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_EMPHASIS = new DataKey<ExtensionConversion>("EXT_INLINE_EMPHASIS", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_CODE = new DataKey<ExtensionConversion>("EXT_INLINE_CODE", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_DEL = new DataKey<ExtensionConversion>("EXT_INLINE_DEL", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_INS = new DataKey<ExtensionConversion>("EXT_INLINE_INS", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_SUB = new DataKey<ExtensionConversion>("EXT_INLINE_SUB", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_SUP = new DataKey<ExtensionConversion>("EXT_INLINE_SUP", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_MATH = new DataKey<ExtensionConversion>("EXT_MATH", ExtensionConversion.HTML);
    public static final DataKey<ExtensionConversion> EXT_TABLES = new DataKey<ExtensionConversion>("EXT_TABLES", ExtensionConversion.MARKDOWN);
    public static final DataKey<LinkConversion> EXT_INLINE_LINK = new DataKey<LinkConversion>("EXT_INLINE_LINK", LinkConversion.MARKDOWN_EXPLICIT);
    public static final DataKey<LinkConversion> EXT_INLINE_IMAGE = new DataKey<LinkConversion>("EXT_INLINE_IMAGE", LinkConversion.MARKDOWN_EXPLICIT);
    public static final DataKey<Ref<Document>> FOR_DOCUMENT = new DataKey<Ref<Document>>("FOR_DOCUMENT", new Ref<Document>(null));
    public static final DataKey<? extends Map<String, String>> TYPOGRAPHIC_REPLACEMENT_MAP = new DataKey("TYPOGRAPHIC_REPLACEMENT_MAP", new HashMap());
    public static final DataKey<Boolean> IGNORE_TABLE_HEADING_AFTER_ROWS = new DataKey<Boolean>("IGNORE_TABLE_HEADING_AFTER_ROWS", true);
    private static final Map<Object, CellAlignment> tableCellAlignments = new LinkedHashMap<Object, CellAlignment>();
    private static final String EMOJI_ALT_PREFIX = "emoji ";
    private static final Map<String, String> specialCharsMap;
    private static final String typographicQuotes = "\u201c|\u201d|\u2018|\u2019|\u00ab|\u00bb|&ldquo;|&rdquo;|&lsquo;|&rsquo;|&apos;|&laquo;|&raquo;";
    private static final String typographicSmarts = "\u2026|\u2013|\u2014|&hellip;|&endash;|&emdash;";
    private static final Pattern NUMERIC_DOT_LIST;
    private static final Pattern NUMERIC_PAREN_LIST;
    private static final Pattern NON_NUMERIC_DOT_LIST;
    private static final Pattern NON_NUMERIC_PAREN_LIST;
    private static final Pattern BULLET_LIST;
    private static final Pattern ALPHA_NUMERAL;
    public static final DataKey<Map<Object, CellAlignment>> TABLE_CELL_ALIGNMENT_MAP;
    private final HtmlParserOptions myOptions;
    private final Pattern specialCharsPattern;
    private Stack<State> myStateStack;
    private HashMap<String, String> myAbbreviations;
    private HashMap<String, Reference> myReferenceUrlToReferenceMap;
    private HashSet<Reference> myExternalReferences;
    private HashMap<String, String> myMacrosMap;
    private Map<String, String> mySpecialCharsMap;
    private State myState;
    private boolean myTrace;
    private boolean myInlineCode;
    private Parser myParser = null;
    private final DataHolder myFullOptions;
    static HashSet<TagType> explicitLinkTextTags;
    private MarkdownTable myTable;
    private boolean myTableSuppressColumns = false;
    private static final Map<String, TagParam> ourTagProcessors;

    private FlexmarkHtmlParser(DataHolder options) {
        this.myFullOptions = options;
        this.myOptions = new HtmlParserOptions(options);
        this.specialCharsPattern = this.myOptions.typographicQuotes && this.myOptions.typographicSmarts ? Pattern.compile("\u201c|\u201d|\u2018|\u2019|\u00ab|\u00bb|&ldquo;|&rdquo;|&lsquo;|&rsquo;|&apos;|&laquo;|&raquo;|\u2026|\u2013|\u2014|&hellip;|&endash;|&emdash;") : (this.myOptions.typographicQuotes ? Pattern.compile(typographicQuotes) : (this.myOptions.typographicSmarts ? Pattern.compile(typographicSmarts) : null));
        this.resetForParse();
    }

    private void resetForParse() {
        ReferenceRepository referenceRepository;
        this.myStateStack = new Stack();
        this.myAbbreviations = new HashMap();
        this.myReferenceUrlToReferenceMap = new HashMap();
        this.myExternalReferences = new HashSet();
        this.myMacrosMap = new HashMap();
        this.myState = null;
        Map<String, String> typographicReplacementMap = TYPOGRAPHIC_REPLACEMENT_MAP.getFrom(this.myFullOptions);
        this.mySpecialCharsMap = !typographicReplacementMap.isEmpty() ? typographicReplacementMap : specialCharsMap;
        Ref<Document> document = FOR_DOCUMENT.getFrom(this.myFullOptions);
        if (document.value != null && (referenceRepository = Parser.REFERENCES.getFrom((DataHolder)document.value)) != null) {
            for (Reference reference : referenceRepository.getValues()) {
                this.myReferenceUrlToReferenceMap.put(reference.getUrl().toString(), reference);
                this.myReferenceUrlToReferenceMap.put(reference.getReference().toString(), reference);
                this.myExternalReferences.add(reference);
            }
        }
    }

    public HtmlParserOptions getOptions() {
        return this.myOptions;
    }

    public boolean isTrace() {
        return this.myTrace;
    }

    void excludeAttributes(String ... excludes) {
        for (String exclude : excludes) {
            this.myState.myAttributes.remove(exclude);
        }
    }

    int outputAttributes(LineFormattingAppendable out, String initialSep) {
        Attributes attributes = this.myState.myAttributes;
        int startOffset = out.offsetWithPending();
        if (!attributes.isEmpty() && !this.myOptions.skipAttributes) {
            String sep = "";
            out.append(initialSep);
            out.append("{");
            for (String attrName : attributes.keySet()) {
                String value = attributes.getValue(attrName);
                out.append(sep);
                if (attrName.equals("id") || attrName.equals("name")) {
                    Matcher matcher;
                    boolean handled = false;
                    if (!this.myOptions.outputIdAttributeRegex.isEmpty() && (matcher = this.myOptions.outputIdAttributeRegexPattern.matcher(value)).matches()) {
                        StringBuilder sb = new StringBuilder();
                        int iMax = matcher.groupCount();
                        for (int i = 0; i < iMax; ++i) {
                            String group = matcher.group(i + 1);
                            if (group == null || group.isEmpty()) continue;
                            sb.append(group);
                        }
                        value = sb.toString().trim();
                        handled = value.isEmpty();
                    }
                    if (!handled) {
                        out.append("#").append(value);
                    }
                } else if (attrName.equals("class")) {
                    out.append(".").append(value);
                } else {
                    out.append(attrName).append("=");
                    if (!value.contains("\"")) {
                        out.append('\"').append(value).append('\"');
                    } else if (!value.contains("'")) {
                        out.append('\'').append(value).append('\'');
                    } else {
                        out.append('\"').append(value.replace("\"", "\\\"")).append('\"');
                    }
                }
                sep = " ";
            }
            out.append("}");
            this.myState.myAttributes.clear();
        }
        return out.offsetWithPending() - startOffset;
    }

    void processAttributes(org.jsoup.nodes.Node node) {
        Attributes attributes = this.myState.myAttributes;
        if (this.myOptions.outputAttributesIdAttr || !this.myOptions.outputAttributesNamesRegex.isEmpty()) {
            org.jsoup.nodes.Attributes nodeAttributes = node.attributes();
            boolean idDone = false;
            if (this.myOptions.outputAttributesIdAttr) {
                String id = nodeAttributes.get("id");
                if (id == null || id.isEmpty()) {
                    id = nodeAttributes.get("name");
                }
                if (id != null && !id.isEmpty()) {
                    attributes.replaceValue("id", id);
                    idDone = true;
                }
            }
            if (!this.myOptions.outputAttributesNamesRegex.isEmpty()) {
                for (Attribute attribute : nodeAttributes) {
                    if (idDone && (attribute.getKey().equals("id") || attribute.getKey().equals("name")) || !attribute.getKey().matches(this.myOptions.outputAttributesNamesRegex)) continue;
                    attributes.replaceValue(attribute.getKey(), attribute.getValue());
                }
            }
        }
    }

    public void setTrace(boolean trace) {
        this.myTrace = trace;
    }

    public void parse(LineFormattingAppendable out, String html) {
        this.resetForParse();
        org.jsoup.nodes.Document document = Jsoup.parse((String)html);
        Element body = document.body();
        if (this.myTrace) {
            LineFormattingAppendableImpl trace = new LineFormattingAppendableImpl(0);
            trace.setIndentPrefix("  ");
            this.dumpHtmlTree(trace, (org.jsoup.nodes.Node)body);
            System.out.println(trace.toString(0));
        }
        this.processHtmlTree(out, (org.jsoup.nodes.Node)body, false);
        boolean needTrailingEOL = true;
        if (!this.myAbbreviations.isEmpty()) {
            out.blankLine();
            for (Map.Entry<String, String> entry : this.myAbbreviations.entrySet()) {
                out.line().append("*[").append(entry.getKey()).append("]: ").append(entry.getValue()).line();
            }
            out.blankLine();
            needTrailingEOL = false;
        }
        if (!this.myReferenceUrlToReferenceMap.isEmpty()) {
            boolean first = true;
            for (Map.Entry entry : this.myReferenceUrlToReferenceMap.entrySet()) {
                if (this.myExternalReferences.contains(entry.getValue())) continue;
                if (first) {
                    first = false;
                    out.blankLine();
                }
                out.line().append(((Reference)entry.getValue()).getChars()).line();
            }
            if (!first) {
                out.blankLine();
                needTrailingEOL = false;
            }
        }
        if (!this.myMacrosMap.isEmpty()) {
            for (Map.Entry<String, String> entry : this.myMacrosMap.entrySet()) {
                out.blankLine();
                out.append(">>>").append(entry.getKey()).line();
                BasedSequence basedSequence = BasedSequenceImpl.of(entry.getValue());
                out.append((CharSequence)basedSequence.trimEnd()).append("\n");
                out.append("<<<\n");
                out.blankLine();
            }
            needTrailingEOL = false;
        }
        if (needTrailingEOL && this.myOptions.addTrailingEol) {
            out.line();
        }
    }

    public static FlexmarkHtmlParser build() {
        return new FlexmarkHtmlParser(null);
    }

    public static FlexmarkHtmlParser build(DataHolder options) {
        return new FlexmarkHtmlParser(options);
    }

    public void dumpHtmlTree(LineFormattingAppendable out, org.jsoup.nodes.Node node) {
        out.line().append(node.nodeName());
        for (Attribute attribute : node.attributes().asList()) {
            out.append(' ').append(attribute.getKey()).append("=\"").append(attribute.getValue()).append("\"");
        }
        out.line().indent();
        for (org.jsoup.nodes.Node child : node.childNodes()) {
            this.dumpHtmlTree(out, child);
        }
        out.unIndent();
    }

    public static String parse(String html) {
        return FlexmarkHtmlParser.parse(html, 1);
    }

    public static String parse(String html, int maxBlankLines) {
        return FlexmarkHtmlParser.parse(html, maxBlankLines, null);
    }

    public static String parse(String html, int maxBlankLines, DataHolder options) {
        LineFormattingAppendableImpl out = new LineFormattingAppendableImpl(134);
        FlexmarkHtmlParser parser = new FlexmarkHtmlParser(options);
        parser.parse(out, html);
        boolean eolEnd = maxBlankLines >= 0 && out.getPendingEOL() > 0;
        String s = out.toString(maxBlankLines);
        return eolEnd ? s : Utils.removeSuffix(s, "\n");
    }

    private String dumpState() {
        if (!this.myStateStack.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            while (!this.myStateStack.isEmpty()) {
                State state = this.myStateStack.pop();
                sb.append("\n").append(state == null ? "null" : state.toString());
            }
            return sb.toString();
        }
        return "";
    }

    private void processHtmlTree(LineFormattingAppendable out, org.jsoup.nodes.Node parent, boolean outputAttributes) {
        this.processHtmlTree(out, parent, outputAttributes, null);
    }

    private void processHtmlTree(LineFormattingAppendable out, org.jsoup.nodes.Node parent, boolean outputAttributes, Runnable prePopAction) {
        org.jsoup.nodes.Node node;
        this.pushState(parent);
        State oldState = this.myState;
        if (prePopAction != null) {
            oldState.addPrePopAction(prePopAction);
        }
        while ((node = this.peek()) != null) {
            this.processElement(out, node);
        }
        if (oldState != this.myState) {
            throw new IllegalStateException("State not equal after process " + this.dumpState());
        }
        oldState.runPrePopActions();
        this.popState(outputAttributes ? out : null);
    }

    private void processElement(LineFormattingAppendable out, org.jsoup.nodes.Node node) {
        boolean outputHtml;
        boolean processed;
        block48: {
            block47: {
                TagParam tagParam = this.getTagParam(node);
                processed = false;
                outputHtml = false;
                if (tagParam == null) break block47;
                switch (tagParam.tagType) {
                    case A: {
                        processed = this.processA(out, (Element)node);
                        break;
                    }
                    case BR: {
                        processed = this.processBr(out, (Element)node);
                        break;
                    }
                    case ABBR: {
                        processed = this.processAbbr(out, (Element)node);
                        break;
                    }
                    case ASIDE: {
                        processed = this.processAside(out, (Element)node);
                        break;
                    }
                    case BLOCKQUOTE: {
                        processed = this.processBlockQuote(out, (Element)node);
                        break;
                    }
                    case CODE: {
                        outputHtml = true;
                        if (this.myOptions.extInlineCode.isParsed()) {
                            processed = this.processCode(out, (Element)node);
                            break;
                        }
                        break block48;
                    }
                    case DEL: {
                        outputHtml = true;
                        if (this.myOptions.extInlineDel.isParsed()) {
                            processed = this.processDel(out, (Element)node);
                            break;
                        }
                        break block48;
                    }
                    case DIV: {
                        processed = this.processDiv(out, (Element)node);
                        break;
                    }
                    case DL: {
                        processed = this.processDl(out, (Element)node);
                        break;
                    }
                    case _EMPHASIS: {
                        outputHtml = true;
                        if (this.myOptions.extInlineEmphasis.isParsed()) {
                            processed = this.processEmphasis(out, (Element)node);
                            break;
                        }
                        break block48;
                    }
                    case HR: {
                        processed = this.processHr(out, (Element)node);
                        break;
                    }
                    case IMG: {
                        processed = this.processImg(out, (Element)node);
                        break;
                    }
                    case INPUT: {
                        processed = this.processInput(out, (Element)node);
                        break;
                    }
                    case INS: {
                        outputHtml = true;
                        if (this.myOptions.extInlineIns.isParsed()) {
                            processed = this.processIns(out, (Element)node);
                            break;
                        }
                        break block48;
                    }
                    case OL: {
                        processed = this.processOl(out, (Element)node);
                        break;
                    }
                    case P: {
                        processed = this.processP(out, (Element)node);
                        break;
                    }
                    case PRE: {
                        processed = this.processPre(out, (Element)node);
                        break;
                    }
                    case _STRONG_EMPHASIS: {
                        outputHtml = true;
                        if (this.myOptions.extInlineStrong.isParsed()) {
                            processed = this.processStrong(out, (Element)node);
                            break;
                        }
                        break block48;
                    }
                    case SUB: {
                        outputHtml = true;
                        if (this.myOptions.extInlineSub.isParsed()) {
                            processed = this.processSub(out, (Element)node);
                            break;
                        }
                        break block48;
                    }
                    case SUP: {
                        outputHtml = true;
                        if (this.myOptions.extInlineSup.isParsed()) {
                            processed = this.processSup(out, (Element)node);
                            break;
                        }
                        break block48;
                    }
                    case SVG: {
                        processed = this.processSvg(out, (Element)node);
                        break;
                    }
                    case UL: {
                        processed = this.processUl(out, (Element)node);
                        break;
                    }
                    case LI: {
                        processed = this.processList(out, (Element)node, false, true);
                        break;
                    }
                    case TABLE: {
                        processed = this.processTable(out, (Element)node);
                        break;
                    }
                    case _UNWRAPPED: {
                        processed = this.processUnwrapped(out, node);
                        break;
                    }
                    case _SPAN: {
                        processed = this.processSpan(out, (Element)node);
                        break;
                    }
                    case MATH: {
                        outputHtml = true;
                        if (this.myOptions.extMath.isParsed() && this.myOptions.extMath != ExtensionConversion.MARKDOWN) {
                            processed = this.processMath(out, (Element)node);
                            break;
                        }
                        break block48;
                    }
                    case _WRAPPED: {
                        processed = this.processWrapped(out, node, tagParam.param == null, false);
                        break;
                    }
                    case _COMMENT: {
                        processed = this.processComment(out, (Comment)node);
                        break;
                    }
                    case _HEADING: {
                        processed = this.processHeading(out, (Element)node);
                        break;
                    }
                    case _TEXT: {
                        processed = this.processText(out, (TextNode)node);
                        break;
                    }
                }
                break block48;
            }
            if (node instanceof Element) {
                processed = this.processEmoji(out, (Element)node);
            }
        }
        if (!processed) {
            if (outputHtml) {
                this.processWrapped(out, node, null, true);
            } else if (this.myOptions.outputUnknownTags) {
                this.processWrapped(out, node, null, false);
            } else {
                this.processUnwrapped(out, node);
            }
        }
    }

    private boolean processUnwrapped(LineFormattingAppendable out, org.jsoup.nodes.Node element) {
        this.skip();
        this.processHtmlTree(out, element, false);
        return true;
    }

    private boolean processWrapped(LineFormattingAppendable out, org.jsoup.nodes.Node node, Boolean isBlock, boolean escapeMarkdown) {
        if (node instanceof Element && (isBlock == null && ((Element)node).isBlock() || isBlock != null && isBlock.booleanValue())) {
            String s = node.toString();
            int pos = s.indexOf(">");
            out.lineIf(isBlock != null).append(s.substring(0, pos + 1)).lineIf(isBlock != null);
            this.next();
            this.processHtmlTree(out, node, false);
            int endPos = s.lastIndexOf("<");
            out.lineIf(isBlock != null).append(s.substring(endPos)).lineIf(isBlock != null);
        } else {
            if (escapeMarkdown) {
                this.appendOuterHtml(node, out);
            } else {
                out.append(node.toString());
            }
            this.next();
        }
        return true;
    }

    private void appendOuterHtml(org.jsoup.nodes.Node node, LineFormattingAppendable out) {
        String text = node.outerHtml();
        int head = text.indexOf(">");
        int tail = text.lastIndexOf("</");
        if (head != -1 && tail != -1) {
            out.append(text.substring(0, head + 1));
            int iMax = node.childNodeSize();
            if (iMax > 0) {
                for (int i = 0; i < iMax; ++i) {
                    this.appendOuterHtml(node.childNode(i), out);
                }
            } else {
                out.append(this.escapeSpecialChars(text.substring(head + 1, tail)));
            }
            out.append(text.substring(tail));
        } else if (head == -1) {
            out.append(this.escapeSpecialChars(text));
        } else {
            out.append(text);
        }
    }

    private String prepareText(String text) {
        return this.prepareText(text, this.myInlineCode);
    }

    private String prepareText(String text, boolean inCode) {
        if (this.specialCharsPattern != null) {
            Matcher matcher = this.specialCharsPattern.matcher(text);
            int length = text.length();
            StringBuilder sb = new StringBuilder(length * 2);
            int lastPos = 0;
            while (matcher.find()) {
                String raw;
                String mapped;
                if (lastPos < matcher.start()) {
                    sb.append(text, lastPos, matcher.start());
                }
                if ((mapped = this.mySpecialCharsMap.get(raw = matcher.group())) != null) {
                    sb.append(mapped);
                } else {
                    sb.append(raw);
                }
                lastPos = matcher.end();
            }
            if (lastPos < length) {
                sb.append(text, lastPos, length);
            }
            text = sb.toString();
        }
        text = !inCode ? this.escapeSpecialChars(text) : text.replace("\u00a0", " ");
        return text;
    }

    private String escapeSpecialChars(String text) {
        if (!this.myOptions.skipCharEscape) {
            text = text.replace("\\", "\\\\");
            text = text.replace("*", "\\*");
            text = text.replace("~", "\\~");
            text = text.replace("^", "\\^");
            text = text.replace("&", "\\&");
            text = text.replace("<", "\\<").replace(">", "\\>");
            text = text.replace("[", "\\[").replace("]", "\\]");
            text = text.replace("|", "\\|").replace("`", "\\`");
            text = text.replace("\u00a0", this.myOptions.nbspText);
        }
        return text;
    }

    private boolean processText(LineFormattingAppendable out, TextNode node) {
        this.skip();
        if (out.isPreFormatted()) {
            out.append(this.prepareText(node.getWholeText(), true));
        } else {
            String text = this.prepareText(node.text());
            if (out.offsetWithPending() != 0 || !text.trim().isEmpty()) {
                out.append(text);
            }
        }
        return true;
    }

    private void processTextNodes(LineFormattingAppendable out, org.jsoup.nodes.Node node, boolean stripIdAttribute) {
        this.processTextNodes(out, node, stripIdAttribute, null, null);
    }

    private void processTextNodes(LineFormattingAppendable out, org.jsoup.nodes.Node node, boolean stripIdAttribute, CharSequence wrapText) {
        this.processTextNodes(out, node, stripIdAttribute, wrapText, wrapText);
    }

    private void processTextNodes(LineFormattingAppendable out, org.jsoup.nodes.Node node, boolean stripIdAttribute, CharSequence textPrefix, CharSequence textSuffix) {
        org.jsoup.nodes.Node child;
        this.pushState(node);
        while ((child = this.peek()) != null) {
            if (child instanceof TextNode) {
                if (textPrefix != null && textPrefix.length() > 0) {
                    out.append(textPrefix);
                }
                String text = ((TextNode)child).getWholeText();
                String preparedText = this.prepareText(text);
                out.append(preparedText);
                if (textSuffix != null && textSuffix.length() > 0) {
                    out.append(textSuffix);
                }
                this.skip();
                continue;
            }
            if (child instanceof Element) {
                this.processElement(out, child);
                continue;
            }
            this.skip();
        }
        if (stripIdAttribute) {
            this.excludeAttributes("id");
        }
        int nodeCount = node.parent().childNodeSize();
        if (node.parent().childNode(nodeCount - 1) == node) {
            this.transferIdToParent();
        }
        this.popState(out);
    }

    private void wrapTextNodes(LineFormattingAppendable out, org.jsoup.nodes.Node node, CharSequence wrapText, boolean needSpaceAround) {
        String text = this.processTextNodes(node);
        String prefixBefore = null;
        String appendAfter = null;
        boolean addSpaceBefore = false;
        boolean addSpaceAfter = false;
        if (!text.isEmpty() && needSpaceAround) {
            if ("\u00a0 \t\n".indexOf(text.charAt(0)) != -1) {
                prefixBefore = this.prepareText(text.substring(0, 1));
                text = text.substring(1);
            } else if (text.startsWith("&nbsp;")) {
                prefixBefore = "&nbsp;";
                text = text.substring(prefixBefore.length());
            } else {
                boolean bl = addSpaceBefore = out.getPendingEOL() != 0 && !out.isPendingSpace() && out.offsetWithPending() != 0 && out.getPendingEOL() <= 0;
            }
            if (!text.isEmpty() && "\u00a0 \t\n".indexOf(text.charAt(text.length() - 1)) != -1) {
                appendAfter = this.prepareText(text.substring(text.length() - 1));
                text = text.substring(0, text.length() - 1);
            } else if (text.endsWith("&nbsp;")) {
                appendAfter = "&nbsp;";
                text = text.substring(0, text.length() - appendAfter.length());
            } else {
                String nextText;
                org.jsoup.nodes.Node next = this.peek();
                addSpaceAfter = true;
                if (next instanceof TextNode && !(nextText = ((TextNode)next).getWholeText()).isEmpty() && Character.isWhitespace(nextText.charAt(0))) {
                    addSpaceAfter = false;
                }
            }
        }
        if (!text.isEmpty()) {
            int pos;
            for (pos = text.length() - 1; pos >= 0 && Character.isWhitespace(text.charAt(pos)); --pos) {
            }
            if (++pos > 0) {
                if (prefixBefore != null) {
                    out.append(prefixBefore);
                }
                if (addSpaceBefore) {
                    out.append(' ');
                }
                text = text.substring(0, pos);
                out.append(wrapText);
                out.append(text);
                out.append(wrapText);
                if (appendAfter != null) {
                    out.append(appendAfter);
                }
                if (addSpaceAfter) {
                    out.append(' ');
                }
            }
        }
    }

    private String processTextNodes(org.jsoup.nodes.Node node) {
        org.jsoup.nodes.Node child;
        this.pushState(node);
        LineFormattingAppendableImpl out = new LineFormattingAppendableImpl(0);
        while ((child = this.peek()) != null) {
            if (child instanceof TextNode) {
                String text = ((TextNode)child).getWholeText();
                out.append(this.prepareText(text));
                this.skip();
                continue;
            }
            if (child instanceof Element) {
                this.processElement(out, child);
                continue;
            }
            this.skip();
        }
        this.transferIdToParent();
        this.popState(null);
        return out.toString(-1);
    }

    private Node parseMarkdown(String markdown) {
        if (this.myParser == null) {
            this.myParser = Parser.builder(this.myFullOptions).build();
        }
        return this.myParser.parse(markdown);
    }

    private Reference getOrCreateReference(String url, String text, String title) {
        Node document;
        Node firstChild;
        Reference reference = this.myReferenceUrlToReferenceMap.get(url);
        if (reference != null) {
            if (title != null && !title.trim().isEmpty()) {
                if (reference.getTitle().isBlank()) {
                    reference.setTitle(BasedSequenceImpl.of(title));
                    return reference;
                }
                if (reference.getTitle().equals(title.trim())) {
                    return reference;
                }
            }
            return reference;
        }
        String referenceId = text;
        if (this.myReferenceUrlToReferenceMap.containsKey(referenceId)) {
            int i = 1;
            while (this.myReferenceUrlToReferenceMap.containsKey(referenceId = text + "_" + i)) {
                ++i;
            }
        }
        StringBuilder sb = new StringBuilder().append("[").append(referenceId).append("]: ").append(url);
        if (title != null && !title.trim().isEmpty()) {
            sb.append(" '").append(title.replace("'", "\\'")).append("'");
        }
        if ((firstChild = (document = this.parseMarkdown(sb.toString())).getFirstChild()) instanceof Reference) {
            reference = (Reference)firstChild;
            this.myReferenceUrlToReferenceMap.put(url, reference);
            return reference;
        }
        return null;
    }

    private boolean hasChildrenOfType(Element element, Set<TagType> tagParams) {
        for (org.jsoup.nodes.Node child : element.children()) {
            TagParam tagParam = this.getTagParam(child);
            if (!tagParams.contains((Object)tagParam.tagType)) continue;
            return true;
        }
        return false;
    }

    private boolean processA(LineFormattingAppendable out, Element element) {
        this.skip();
        if (element.hasAttr("href")) {
            LinkConversion conv = this.myOptions.extInlineLink;
            if (conv.isSuppressed()) {
                return true;
            }
            if (out.isPreFormatted()) {
                int hashIndex;
                String href;
                String useHref = href = element.attr("href");
                int slashIndex = href.lastIndexOf(47);
                if (slashIndex != -1 && (hashIndex = href.indexOf(35, slashIndex)) != -1 && slashIndex + 1 == hashIndex) {
                    useHref = useHref.substring(0, slashIndex) + useHref.substring(hashIndex);
                }
                out.append(useHref);
            } else if (conv.isParsed()) {
                String title;
                this.pushState((org.jsoup.nodes.Node)element);
                String textNodes = this.processTextNodes((org.jsoup.nodes.Node)element);
                String text = textNodes.trim();
                String href = element.attr("href");
                String string = title = element.hasAttr("title") ? element.attr("title") : null;
                if (!text.isEmpty() || !href.contains("#")) {
                    if (this.myOptions.extractAutoLinks && href.equals(text) && (title == null || title.isEmpty())) {
                        if (this.myOptions.wrapAutoLinks) {
                            out.append('<');
                        }
                        out.append(text);
                        if (this.myOptions.wrapAutoLinks) {
                            out.append('>');
                        }
                        this.transferIdToParent();
                    } else if (!(this.myOptions.skipLinks || conv.isTextOnly() || href.startsWith("javascript:"))) {
                        Reference reference;
                        boolean handled = false;
                        if (conv.isReference() && !this.hasChildrenOfType(element, explicitLinkTextTags) && (reference = this.getOrCreateReference(href, text, title)) != null) {
                            handled = true;
                            if (reference.getReference().equals(text)) {
                                out.append('[').append(text).append("][]");
                            } else {
                                out.append('[').append(text).append("][").append(reference.getReference()).append(']');
                            }
                        }
                        if (!handled) {
                            out.append('[');
                            out.append(text);
                            out.append(']');
                            out.append('(').append(href);
                            if (title != null) {
                                out.append(" \"").append(title.replace("\n", this.myOptions.eolInTitleAttribute).replace("\"", "\\\"")).append('\"');
                            }
                            out.append(")");
                        }
                    } else {
                        out.append(text);
                    }
                    this.excludeAttributes("href", "title");
                    this.popState(out);
                } else {
                    this.transferIdToParent();
                    this.popState(null);
                }
            } else if (!conv.isSuppressed()) {
                this.processWrapped(out, (org.jsoup.nodes.Node)element, null, true);
            }
        } else {
            boolean stripIdAttribute = false;
            if (element.childNodeSize() == 0 && element.parent().tagName().equals("body")) {
                stripIdAttribute = true;
            }
            this.processTextNodes(out, (org.jsoup.nodes.Node)element, stripIdAttribute);
        }
        return true;
    }

    private boolean processBr(LineFormattingAppendable out, Element element) {
        this.skip();
        if (out.isPreFormatted()) {
            out.append('\n');
        } else {
            int options = out.getOptions();
            out.setOptions(options & 0xFFFFFFF9);
            if (out.getPendingEOL() == 0) {
                out.repeat(' ', 2).line();
            } else if (out.getPendingEOL() == 1) {
                String s = out.toString();
                if (!s.endsWith("<br />")) {
                    if (this.myOptions.brAsParaBreaks) {
                        out.blankLine();
                    }
                } else if (this.myOptions.brAsExtraBlankLines) {
                    out.append("<br />").blankLine();
                }
            } else if (this.myOptions.brAsExtraBlankLines) {
                out.append("<br />").blankLine();
            }
            out.setOptions(options);
        }
        return true;
    }

    private boolean processAbbr(LineFormattingAppendable out, Element element) {
        this.skip();
        if (element.hasAttr("title")) {
            String text = this.processTextNodes((org.jsoup.nodes.Node)element).trim();
            this.myAbbreviations.put(text, element.attr("title"));
        }
        return true;
    }

    private boolean isFirstChild(Element element) {
        for (org.jsoup.nodes.Node node : element.parent().childNodes()) {
            if (node instanceof Element) {
                return element == node;
            }
            if (!node.nodeName().equals("#text") || node.outerHtml().trim().isEmpty()) continue;
            break;
        }
        return false;
    }

    private boolean isLastChild(Element element) {
        Elements children = element.parent().children();
        int i = children.size();
        while (i-- > 0) {
            org.jsoup.nodes.Node node = (org.jsoup.nodes.Node)children.get(i);
            if (!(node instanceof Element)) continue;
            return element == node;
        }
        return false;
    }

    private boolean processAside(LineFormattingAppendable out, Element element) {
        this.skip();
        if (this.isFirstChild(element)) {
            out.line();
        }
        out.pushPrefix();
        out.addPrefix("| ");
        this.processHtmlTree(out, (org.jsoup.nodes.Node)element, true);
        out.line();
        out.popPrefix();
        return true;
    }

    private boolean processBlockQuote(LineFormattingAppendable out, Element element) {
        this.skip();
        if (this.isFirstChild(element)) {
            out.line();
        }
        out.pushPrefix();
        out.addPrefix("> ");
        this.processHtmlTree(out, (org.jsoup.nodes.Node)element, true);
        out.line();
        out.popPrefix();
        return true;
    }

    private boolean processCode(LineFormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.extInlineCode.isSuppressed()) {
            BasedSequence text = SubSequence.of(element.ownText());
            int backTickCount = this.getMaxRepeatedChars(text, '`', 1);
            RepeatedCharSequence backTicks = RepeatedCharSequence.of("`", backTickCount);
            boolean oldInlineCode = this.myInlineCode;
            this.myInlineCode = true;
            this.processTextNodes(out, (org.jsoup.nodes.Node)element, false, this.myOptions.skipInlineCode || this.myOptions.extInlineCode.isTextOnly() ? "" : backTicks);
            this.myInlineCode = oldInlineCode;
        }
        return true;
    }

    private int getMaxRepeatedChars(CharSequence text, char c, int minCount) {
        int pos;
        BasedSequence chars = BasedSequenceImpl.of(text);
        int lastPos = 0;
        while (lastPos < chars.length() && (pos = chars.indexOf(c, lastPos)) >= 0) {
            int count = chars.countLeading(c, pos);
            if (minCount <= count) {
                minCount = count + 1;
            }
            lastPos = pos + count;
        }
        return minCount;
    }

    private boolean processDel(LineFormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.extInlineDel.isSuppressed()) {
            if (!this.myOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
                this.wrapTextNodes(out, (org.jsoup.nodes.Node)element, "", false);
            } else {
                this.wrapTextNodes(out, (org.jsoup.nodes.Node)element, this.myOptions.skipInlineDel || this.myOptions.extInlineDel.isTextOnly() ? "" : "~~", element.nextElementSibling() != null);
            }
        }
        return true;
    }

    private boolean processEmphasis(LineFormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.extInlineEmphasis.isSuppressed()) {
            if (!this.myOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
                this.wrapTextNodes(out, (org.jsoup.nodes.Node)element, "", false);
            } else {
                this.wrapTextNodes(out, (org.jsoup.nodes.Node)element, this.myOptions.skipInlineEmphasis || this.myOptions.extInlineEmphasis.isTextOnly() ? "" : "*", element.nextElementSibling() != null);
            }
        }
        return true;
    }

    private boolean processHeading(LineFormattingAppendable out, Element element) {
        String headingText;
        int level;
        this.skip();
        TagParam tagParam = this.getTagParam((org.jsoup.nodes.Node)element);
        if (tagParam != null && (level = ((Integer)tagParam.param).intValue()) >= 1 && level <= 6 && !(headingText = this.processTextNodes((org.jsoup.nodes.Node)element).trim()).isEmpty()) {
            out.blankLine();
            boolean skipHeading = false;
            switch (level) {
                case 1: {
                    skipHeading = this.myOptions.skipHeading1;
                    break;
                }
                case 2: {
                    skipHeading = this.myOptions.skipHeading2;
                    break;
                }
                case 3: {
                    skipHeading = this.myOptions.skipHeading3;
                    break;
                }
                case 4: {
                    skipHeading = this.myOptions.skipHeading4;
                    break;
                }
                case 5: {
                    skipHeading = this.myOptions.skipHeading5;
                    break;
                }
                case 6: {
                    skipHeading = this.myOptions.skipHeading6;
                }
            }
            if (skipHeading) {
                out.append(headingText);
            } else {
                if (this.myOptions.setextHeadings && level <= 2) {
                    out.append(headingText);
                    int extraChars = this.outputAttributes(out, " ");
                    out.line().repeat(level == 1 ? (char)'=' : '-', Utils.minLimit(headingText.length() + extraChars, this.myOptions.minSetextHeadingMarkerLength));
                } else {
                    out.repeat('#', level).append(' ');
                    out.append(headingText);
                    this.outputAttributes(out, " ");
                }
                out.blankLine();
            }
        }
        return true;
    }

    private boolean processHr(LineFormattingAppendable out, Element element) {
        this.skip();
        out.blankLine().append(this.myOptions.thematicBreak).blankLine();
        return true;
    }

    private boolean processImg(LineFormattingAppendable out, Element element) {
        this.skip();
        if (element.hasAttr("src")) {
            String emojiAlt;
            String src = element.attr("src");
            EmojiReference.Emoji emoji = EmojiShortcuts.getEmojiFromURI(src);
            if (emoji == null && element.hasAttr("alt") && (emojiAlt = element.attr("alt")).startsWith(EMOJI_ALT_PREFIX)) {
                List<EmojiReference.Emoji> emojiList = EmojiReference.getEmojiList();
                int pos = emojiAlt.indexOf(":", EMOJI_ALT_PREFIX.length());
                if (pos > 0) {
                    String category = emojiAlt.substring(EMOJI_ALT_PREFIX.length(), pos);
                    String shortcut = emojiAlt.substring(pos + 1);
                    EmojiReference.Emoji emoji2 = EmojiShortcuts.getEmojiFromShortcut(shortcut);
                    if (emoji2.category.equals(category)) {
                        emoji = emoji2;
                    }
                }
            }
            if (emoji != null) {
                out.append(':').append(emoji.shortcut).append(':');
            } else {
                LinkConversion conv = this.myOptions.extInlineImage;
                if (conv.isSuppressed()) {
                    return true;
                }
                if (conv.isParsed()) {
                    String title;
                    String alt;
                    String string = alt = !element.hasAttr("alt") ? null : element.attr("alt").trim().replace("[", "\\[").replace("]", "\\]");
                    if (alt != null && alt.isEmpty()) {
                        alt = null;
                    }
                    String string2 = title = !element.hasAttr("title") ? null : element.attr("title").replace("\n", this.myOptions.eolInTitleAttribute).replace("\"", "\\\"");
                    if (title != null && title.isEmpty()) {
                        title = null;
                    }
                    if (!conv.isTextOnly()) {
                        Reference reference;
                        int pos = src.indexOf(63);
                        int eol = pos < 0 ? pos : src.indexOf("%0A", pos);
                        boolean isMultiLineUrl = pos > 0 && eol > 0;
                        boolean handled = false;
                        if (conv.isReference() && !isMultiLineUrl && (reference = this.getOrCreateReference(src, alt == null ? "image" : alt, title)) != null) {
                            handled = true;
                            if (alt == null || reference.getReference().equals(alt)) {
                                out.append("![").append(reference.getReference()).append("][]");
                            } else {
                                out.append("![").append(alt).append("][").append(reference.getReference()).append("]");
                            }
                        }
                        if (!handled) {
                            out.append("![");
                            if (alt != null) {
                                out.append(alt);
                            }
                            out.append(']').append('(');
                            if (isMultiLineUrl) {
                                out.append(src, 0, pos + 1);
                                String decoded = Utils.urlDecode(src.substring(pos + 1).replace("+", "%2B"), "UTF8");
                                out.line().append(decoded);
                            } else {
                                out.append(src);
                            }
                            if (title != null) {
                                out.append(" \"").append(title).append('\"');
                            }
                            out.append(")");
                        }
                    } else if (alt != null) {
                        out.append(alt);
                    } else if (title != null) {
                        out.append(title);
                    }
                } else if (!conv.isSuppressed()) {
                    this.processWrapped(out, (org.jsoup.nodes.Node)element, null, false);
                }
            }
        }
        return true;
    }

    public LineFormattingAppendable tailBlankLine(LineFormattingAppendable out, Element element) {
        return this.tailBlankLine(out, element, 1);
    }

    public boolean isLastBlockQuoteChild(Element node) {
        Element parent;
        while (node.nextElementSibling() == null && (parent = node.parent()) != null) {
            if (parent.nodeName().toLowerCase().equals("blockquote")) {
                return true;
            }
            node = parent;
        }
        return false;
    }

    public LineFormattingAppendable tailBlankLine(LineFormattingAppendable out, Element element, int count) {
        if (this.isLastBlockQuoteChild(element)) {
            CharSequence prefix = out.getPrefix();
            int pos = prefix.toString().lastIndexOf(62);
            if (pos != -1) {
                out.setPrefix(prefix.subSequence(0, pos));
            } else {
                out.setPrefix("");
            }
            out.blankLine(count);
            out.setPrefix(prefix, false);
        } else {
            out.blankLine(count);
        }
        return out;
    }

    private boolean processP(LineFormattingAppendable out, Element element) {
        this.skip();
        boolean isItemParagraph = false;
        boolean isDefinitionItemParagraph = false;
        Element firstElementSibling = element.firstElementSibling();
        if (firstElementSibling == null || element == firstElementSibling) {
            String tagName = element.parent().tagName();
            isItemParagraph = tagName.equalsIgnoreCase("li");
            isDefinitionItemParagraph = tagName.equalsIgnoreCase("dd");
        }
        out.blankLineIf(!isItemParagraph && !isDefinitionItemParagraph && !this.isFirstChild(element));
        if (element.childNodeSize() == 0) {
            if (this.myOptions.brAsExtraBlankLines) {
                out.append("<br />").blankLine();
            }
        } else {
            this.processTextNodes(out, (org.jsoup.nodes.Node)element, false);
        }
        out.line();
        if (isItemParagraph || isDefinitionItemParagraph) {
            this.tailBlankLine(out, element);
        }
        return true;
    }

    private boolean processInput(LineFormattingAppendable out, Element element) {
        boolean isItemParagraph = false;
        Element firstElementSibling = element.firstElementSibling();
        if (firstElementSibling == null || element == firstElementSibling) {
            String tagName = element.parent().tagName();
            isItemParagraph = tagName.equalsIgnoreCase("li");
        }
        if (isItemParagraph && element.hasAttr("type") && "checkbox".equalsIgnoreCase(element.attr("type"))) {
            this.skip();
            if (element.hasAttr("checked")) {
                out.append("[x] ");
            } else {
                out.append("[ ] ");
            }
            return true;
        }
        return false;
    }

    private boolean processIns(LineFormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.extInlineIns.isSuppressed()) {
            if (!this.myOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
                this.wrapTextNodes(out, (org.jsoup.nodes.Node)element, "", false);
            } else {
                this.wrapTextNodes(out, (org.jsoup.nodes.Node)element, this.myOptions.skipInlineIns || this.myOptions.extInlineIns.isTextOnly() ? "" : "++", element.nextElementSibling() != null);
            }
        }
        return true;
    }

    private boolean processStrong(LineFormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.extInlineStrong.isSuppressed()) {
            if (!this.myOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
                this.wrapTextNodes(out, (org.jsoup.nodes.Node)element, "", false);
            } else {
                this.wrapTextNodes(out, (org.jsoup.nodes.Node)element, this.myOptions.skipInlineStrong || this.myOptions.extInlineStrong.isTextOnly() ? "" : "**", element.nextElementSibling() != null);
            }
        }
        return true;
    }

    private boolean processSub(LineFormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.extInlineSub.isSuppressed()) {
            if (this.myOptions.skipInlineSub || this.myOptions.extInlineSub.isTextOnly() || !this.myOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
                this.wrapTextNodes(out, (org.jsoup.nodes.Node)element, "", false);
            } else {
                this.wrapTextNodes(out, (org.jsoup.nodes.Node)element, "~", false);
            }
        }
        return true;
    }

    private boolean processSup(LineFormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.extInlineSup.isSuppressed()) {
            // empty if block
        }
        if (this.myOptions.skipInlineSup || this.myOptions.extInlineSup.isTextOnly() || !this.myOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
            this.wrapTextNodes(out, (org.jsoup.nodes.Node)element, "", false);
        } else {
            this.wrapTextNodes(out, (org.jsoup.nodes.Node)element, "^", false);
        }
        return true;
    }

    private boolean processSvg(LineFormattingAppendable out, Element element) {
        if (element.hasClass("octicon")) {
            this.skip();
            return true;
        }
        return false;
    }

    private boolean processPre(LineFormattingAppendable out, Element element) {
        this.pushState((org.jsoup.nodes.Node)element);
        boolean hadCode = false;
        String className = "";
        LineFormattingAppendableImpl preText = new LineFormattingAppendableImpl(out.getOptions() & 0xFFFFFFF9);
        preText.openPreFormatted(false);
        org.jsoup.nodes.Node next = this.peek();
        while (next != null) {
            if (next.nodeName().equalsIgnoreCase("code") || next.nodeName().equalsIgnoreCase("tt")) {
                hadCode = true;
                Element code = (Element)next;
                this.processHtmlTree(preText, (org.jsoup.nodes.Node)code, false);
                if (className.isEmpty()) {
                    className = Utils.removeStart(code.className(), "language-");
                }
            } else if (next.nodeName().equalsIgnoreCase("br")) {
                preText.append("\n");
            } else if (next.nodeName().equalsIgnoreCase("#text")) {
                preText.append(((TextNode)next).getWholeText());
            } else {
                this.processHtmlTree(preText, next, false);
            }
            this.next();
            next = this.peek();
        }
        preText.closePreFormatted();
        String text = preText.toString(2);
        int backTickCount = this.getMaxRepeatedChars(text, '`', 3);
        RepeatedCharSequence backTicks = RepeatedCharSequence.of("`", backTickCount);
        if (!(this.myOptions.skipFencedCode || className.isEmpty() && !text.trim().isEmpty() && hadCode)) {
            out.blankLine().append(backTicks);
            if (!className.isEmpty()) {
                out.append(className);
            }
            out.line();
            out.openPreFormatted(true);
            out.append(text.isEmpty() ? "\n" : text);
            out.closePreFormatted();
            out.line().append(backTicks).line();
            this.tailBlankLine(out, element);
        } else {
            out.blankLine();
            out.pushPrefix();
            out.addPrefix(this.myOptions.codeIndent);
            out.openPreFormatted(true);
            out.append(text.isEmpty() ? "\n" : text);
            out.closePreFormatted();
            out.line();
            this.tailBlankLine(out, element);
            out.popPrefix();
        }
        this.popState(out);
        this.next();
        return true;
    }

    private void processListItem(LineFormattingAppendable out, Element item, ListState listState) {
        this.skip();
        this.pushState((org.jsoup.nodes.Node)item);
        ++listState.itemCount;
        String itemPrefix = listState.getItemPrefix(this.myOptions);
        RepeatedCharSequence childPrefix = RepeatedCharSequence.of(" ", this.myOptions.listContentIndent ? itemPrefix.length() : 4);
        out.line().append(itemPrefix);
        out.pushPrefix();
        out.addPrefix(childPrefix, true);
        int offset = out.offsetWithPending();
        this.processHtmlTree(out, (org.jsoup.nodes.Node)item, true);
        if (offset == out.offsetWithPending()) {
            int options = out.getOptions();
            out.setOptions((options | 0x20) & 0xFFFFFFFB);
            out.line();
            out.setOptions(options);
        } else {
            out.line();
        }
        out.popPrefix();
        this.popState(out);
    }

    private boolean hasListItemParent(Element element) {
        for (Element parent = element.parent(); parent != null; parent = parent.parent()) {
            if (!parent.tagName().equalsIgnoreCase("li")) continue;
            return true;
        }
        return false;
    }

    private boolean haveListItemAncestor(org.jsoup.nodes.Node node) {
        TagParam tagParam;
        for (org.jsoup.nodes.Node parent = node.parent(); parent != null && (tagParam = this.getTagParam(parent)) != null; parent = parent.parent()) {
            if (tagParam.tagType != TagType.LI) continue;
            return true;
        }
        return false;
    }

    private boolean processList(LineFormattingAppendable out, Element element, boolean isNumbered, boolean isFakeList) {
        org.jsoup.nodes.Node item;
        Element previousElementSibling;
        String tag;
        if (!isFakeList) {
            this.skip();
            this.pushState((org.jsoup.nodes.Node)element);
            if (!this.haveListItemAncestor(this.myState.myParent) && !this.isFirstChild(element)) {
                out.blankLine();
            }
        }
        String string = tag = (previousElementSibling = element.previousElementSibling()) == null ? null : previousElementSibling.tagName().toUpperCase();
        if (tag != null && tag.equals(element.tagName().toUpperCase()) && (tag.equals("UL") || tag.equals("OL"))) {
            if (this.myOptions.listsEndOnDoubleBlank) {
                out.blankLine(2);
            } else {
                out.line().append("<!-- -->").blankLine();
            }
        }
        ListState listState = new ListState(isNumbered);
        if (listState.isNumbered && element.hasAttr("start")) {
            try {
                int i = Integer.parseInt(element.attr("start"));
                listState.itemCount = i - 1;
            }
            catch (NumberFormatException i) {
                // empty catch block
            }
        }
        block6: while ((item = this.peek()) != null) {
            TagParam tagParam = this.getTagParam(item);
            if (tagParam != null) {
                switch (tagParam.tagType) {
                    case LI: {
                        this.processListItem(out, (Element)item, listState);
                        continue block6;
                    }
                    case P: {
                        if (item.childNodeSize() > 0) {
                            this.processListItem(out, (Element)item, listState);
                            continue block6;
                        }
                        this.skip();
                        continue block6;
                    }
                }
                this.skip();
                continue;
            }
            this.processWrapped(out, item, true, false);
        }
        if (element.nextElementSibling() != null) {
            out.blankLine();
        }
        if (!isFakeList) {
            this.popState(out);
        }
        return true;
    }

    private boolean processOl(LineFormattingAppendable out, Element element) {
        return this.processList(out, element, true, false);
    }

    private boolean processUl(LineFormattingAppendable out, Element element) {
        return this.processList(out, element, false, false);
    }

    private void processDefinition(LineFormattingAppendable out, Element item) {
        this.pushState((org.jsoup.nodes.Node)item);
        int options = out.getOptions();
        Elements children = item.children();
        boolean firstIsPara = false;
        if (!children.isEmpty() && ((Element)children.get(0)).tagName().equalsIgnoreCase("p")) {
            out.blankLine();
            firstIsPara = true;
        }
        RepeatedCharSequence childPrefix = RepeatedCharSequence.of(" ", this.myOptions.listContentIndent ? this.myOptions.definitionMarkerSpaces + 1 : 4);
        out.line().setOptions(options & 0xFFFFFFFD);
        out.append(':').repeat(' ', this.myOptions.definitionMarkerSpaces);
        out.pushPrefix();
        out.addPrefix(childPrefix, true);
        out.setOptions(options);
        if (firstIsPara) {
            this.processHtmlTree(out, (org.jsoup.nodes.Node)item, true);
        } else {
            this.processTextNodes(out, (org.jsoup.nodes.Node)item, false);
        }
        out.line();
        out.popPrefix();
        this.popState(out);
    }

    private boolean processDl(LineFormattingAppendable out, Element element) {
        org.jsoup.nodes.Node item;
        this.skip();
        this.pushState((org.jsoup.nodes.Node)element);
        boolean lastWasDefinition = true;
        boolean firstItem = true;
        block4: while ((item = this.next()) != null) {
            TagParam tagParam = this.getTagParam(item);
            if (tagParam != null) {
                switch (tagParam.tagType) {
                    case DT: {
                        out.blankLineIf(lastWasDefinition).lineIf(!firstItem);
                        this.processTextNodes(out, item, false);
                        out.line();
                        lastWasDefinition = false;
                        firstItem = false;
                        continue block4;
                    }
                    case DD: {
                        this.processDefinition(out, (Element)item);
                        lastWasDefinition = true;
                        firstItem = false;
                        continue block4;
                    }
                }
                continue;
            }
            this.processWrapped(out, item, true, false);
        }
        this.popState(out);
        return true;
    }

    private boolean processDiv(LineFormattingAppendable out, Element element) {
        this.skip();
        if (!this.isFirstChild(element)) {
            if (!this.myOptions.divAsParagraph) {
                CharSequence lineContent;
                int pendingSpace;
                int lineCount;
                int pendingEOL = out.getPendingEOL();
                if (pendingEOL == 0) {
                    int pendingSpace2 = out.getPendingSpace();
                    out.lineWithTrailingSpaces(Utils.minLimit(0, 2 - pendingSpace2));
                } else if (pendingEOL == 1 && (lineCount = out.getLineCount()) > 0 && (pendingSpace = BasedSequenceImpl.of(lineContent = out.getLineContent(lineCount - 1)).countTrailing(" \t")) < 2) {
                    out.removeLines(lineCount - 1, lineCount);
                    out.append(lineContent);
                    out.lineWithTrailingSpaces(2 - pendingSpace);
                }
            } else {
                out.blankLine();
            }
        }
        this.processHtmlTree(out, (org.jsoup.nodes.Node)element, false);
        if (!this.isLastChild(element)) {
            out.line();
            if (this.myOptions.divAsParagraph) {
                out.blankLine();
            }
        }
        return true;
    }

    private boolean processMath(LineFormattingAppendable out, Element element) {
        this.skip();
        if (!this.myOptions.extMath.isSuppressed()) {
            boolean noWraps = this.myOptions.extMath.isTextOnly();
            this.processTextNodes(out, (org.jsoup.nodes.Node)element, false, noWraps ? "" : "$`", noWraps ? "" : "`$");
        }
        return true;
    }

    private boolean matchingText(Pattern pattern, String text, String[] match) {
        Matcher matcher = pattern.matcher(text);
        if (matcher.matches()) {
            match[0] = matcher.groupCount() > 0 ? matcher.group(1) : matcher.group();
            return true;
        }
        return false;
    }

    private String convertNumeric(String text) {
        if (RomanNumeral.LIMITED_ROMAN_NUMERAL.matcher(text = text.trim()).matches() || RomanNumeral.LIMITED_LOWERCASE_ROMAN_NUMERAL.matcher(text).matches()) {
            RomanNumeral numeral = new RomanNumeral(text);
            return String.valueOf(numeral.toInt());
        }
        if (ALPHA_NUMERAL.matcher(text).matches()) {
            int value = 0;
            text = text.toUpperCase();
            int iMax = text.length();
            for (int i = 0; i < iMax; ++i) {
                char c = text.charAt(i);
                value *= 26;
                value += c - 65 + 1;
            }
            return String.valueOf(value);
        }
        return "1";
    }

    private boolean processSpan(LineFormattingAppendable out, Element element) {
        String style;
        if (element.hasAttr("style") && (style = element.attr("style")).equals("mso-list:Ignore")) {
            this.skip();
            String[] match = new String[]{"1"};
            String text = this.processTextNodes((org.jsoup.nodes.Node)element);
            if (this.matchingText(NUMERIC_DOT_LIST, text, match)) {
                out.append(text).append(' ');
            } else if (this.matchingText(NUMERIC_PAREN_LIST, text, match)) {
                if (this.myOptions.dotOnlyNumericLists) {
                    out.append(match[0]).append(". ");
                } else {
                    out.append(match[0]).append(") ");
                }
            } else if (this.matchingText(NON_NUMERIC_DOT_LIST, text, match)) {
                out.append(this.convertNumeric(match[0])).append(". ");
                if (this.myOptions.commentOriginalNonNumericListItem) {
                    out.append(" <!-- ").append(match[0]).append(" -->");
                }
            } else if (this.matchingText(NON_NUMERIC_PAREN_LIST, text, match)) {
                if (this.myOptions.dotOnlyNumericLists) {
                    out.append(this.convertNumeric(match[0])).append(". ");
                    if (this.myOptions.commentOriginalNonNumericListItem) {
                        out.append(" <!-- ").append(match[0]).append(" -->");
                    }
                } else {
                    out.append(this.convertNumeric(match[0])).append(") ");
                    if (this.myOptions.commentOriginalNonNumericListItem) {
                        out.append(" <!-- ").append(match[0]).append(" -->");
                    }
                }
            } else if (BULLET_LIST.matcher(text).matches()) {
                out.append("* ");
            } else {
                out.append("* ").append(text);
            }
            this.transferIdToParent();
            return true;
        }
        this.skip();
        this.processHtmlTree(out, (org.jsoup.nodes.Node)element, true, new Runnable(){

            @Override
            public void run() {
                FlexmarkHtmlParser.this.transferIdToParent();
            }
        });
        return true;
    }

    private boolean processEmoji(LineFormattingAppendable out, Element element) {
        if (element.tagName().equalsIgnoreCase("g-emoji")) {
            EmojiReference.Emoji emoji;
            if (element.hasAttr("alias")) {
                this.skip();
                out.append(':').append(element.attr("alias")).append(':');
                return true;
            }
            if (element.hasAttr("fallback-src") && (emoji = EmojiShortcuts.getEmojiFromURI(element.attr("fallback-src"))) != null) {
                this.skip();
                out.append(':').append(emoji.shortcut).append(':');
                return true;
            }
        }
        return false;
    }

    private boolean processComment(LineFormattingAppendable out, Comment element) {
        this.skip();
        if (this.myOptions.renderComments) {
            out.append("<!--").append(element.getData()).append("-->");
        }
        return true;
    }

    private TagParam getTagParam(org.jsoup.nodes.Node node) {
        return ourTagProcessors.get(node.nodeName().toLowerCase());
    }

    private boolean processTable(LineFormattingAppendable out, Element table) {
        org.jsoup.nodes.Node item;
        MarkdownTable oldTable = this.myTable;
        this.skip();
        this.pushState((org.jsoup.nodes.Node)table);
        this.myTable = new MarkdownTable(this.myOptions.tableOptions);
        this.myTableSuppressColumns = false;
        while ((item = this.next()) != null) {
            TagParam tagParam = this.getTagParam(item);
            if (tagParam == null) continue;
            switch (tagParam.tagType) {
                case CAPTION: {
                    this.processTableCaption(out, (Element)item);
                    break;
                }
                case TBODY: {
                    this.myTable.setHeader(false);
                    this.processTableSection(out, (Element)item);
                    break;
                }
                case THEAD: {
                    this.myTable.setHeader(true);
                    this.processTableSection(out, (Element)item);
                    break;
                }
                case TR: {
                    Element tableRow = (Element)item;
                    Elements children = tableRow.children();
                    this.myTable.setHeader(!children.isEmpty() && ((Element)children.get(0)).tagName().equalsIgnoreCase("th"));
                    this.processTableRow(out, (Element)item);
                }
            }
        }
        this.myTable.finalizeTable();
        int sepColumns = this.myTable.getMaxColumns();
        if (sepColumns > 0) {
            out.blankLine();
            this.myTable.appendTable(out);
            this.tailBlankLine(out, table);
        }
        this.myTable = oldTable;
        this.popState(out);
        return true;
    }

    private void processTableSection(LineFormattingAppendable out, Element element) {
        org.jsoup.nodes.Node node;
        this.pushState((org.jsoup.nodes.Node)element);
        while ((node = this.next()) != null) {
            TagParam tagParam = this.getTagParam(node);
            if (tagParam != null) {
                if (tagParam.tagType != TagType.TR) continue;
                Element tableRow = (Element)node;
                Elements children = tableRow.children();
                boolean wasHeading = this.myTable.getHeader();
                if (!children.isEmpty() && ((Element)children.get(0)).tagName().equalsIgnoreCase("th")) {
                    this.myTable.setHeader(true);
                }
                if (this.myTable.getHeader() && this.myTable.body.rows.size() > 0) {
                    if (this.myOptions.ignoreTableHeadingAfterRows) {
                        this.myTableSuppressColumns = true;
                    } else {
                        this.myTable.setHeader(false);
                    }
                }
                this.processTableRow(out, tableRow);
                this.myTableSuppressColumns = false;
                this.myTable.setHeader(wasHeading);
                continue;
            }
            this.processWrapped(out, (org.jsoup.nodes.Node)element, true, false);
        }
        this.popState(out);
    }

    private void processTableRow(LineFormattingAppendable out, Element element) {
        org.jsoup.nodes.Node node;
        this.pushState((org.jsoup.nodes.Node)element);
        while ((node = this.next()) != null) {
            TagParam tagParam = this.getTagParam(node);
            if (tagParam != null) {
                switch (tagParam.tagType) {
                    case TH: {
                        this.processTableCell(out, (Element)node);
                        break;
                    }
                    case TD: {
                        this.processTableCell(out, (Element)node);
                    }
                }
                continue;
            }
            this.processWrapped(out, (org.jsoup.nodes.Node)element, true, false);
        }
        this.myTable.nextRow();
        this.popState(out);
    }

    private void processTableCaption(LineFormattingAppendable out, Element element) {
        this.myTable.setCaption(this.processTextNodes((org.jsoup.nodes.Node)element).trim());
    }

    private void processTableCell(LineFormattingAppendable out, Element element) {
        String cellText = this.processTextNodes((org.jsoup.nodes.Node)element).trim().replaceAll("\\s*\n\\s*", " ");
        int colSpan = 1;
        int rowSpan = 1;
        CellAlignment alignment = null;
        if (element.hasAttr("colSpan")) {
            try {
                colSpan = Integer.parseInt(element.attr("colSpan"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (element.hasAttr("rowSpan")) {
            try {
                rowSpan = Integer.parseInt(element.attr("rowSpan"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (element.hasAttr("align")) {
            alignment = CellAlignment.getAlignment(element.attr("align"));
        } else {
            Set classNames = element.classNames();
            if (!classNames.isEmpty()) {
                for (String clazz : classNames) {
                    CellAlignment cellAlignment = this.myOptions.tableCellAlignmentMap.get(clazz);
                    if (cellAlignment == null) continue;
                    alignment = cellAlignment;
                    break;
                }
                if (alignment == null) {
                    for (Object key : this.myOptions.tableCellAlignmentMap.keySet()) {
                        if (!(key instanceof Pattern)) continue;
                        Pattern pattern = (Pattern)key;
                        for (String clazz : classNames) {
                            if (!pattern.matcher(clazz).find()) continue;
                            alignment = this.myOptions.tableCellAlignmentMap.get(key);
                            break;
                        }
                        if (alignment == null) continue;
                        break;
                    }
                }
            }
        }
        if (!this.myTableSuppressColumns) {
            this.myTable.addCell(new TableCell(SubSequence.NULL, cellText.replace("\n", " "), BasedSequence.NULL, rowSpan, colSpan, alignment));
        }
    }

    private void pushState(org.jsoup.nodes.Node parent) {
        this.myStateStack.push(this.myState);
        this.myState = new State(parent);
        this.processAttributes(parent);
    }

    void transferIdToParent() {
        State state;
        if (this.myStateStack.isEmpty()) {
            throw new IllegalStateException("transferIdToParent with an empty stack");
        }
        com.vladsch.flexmark.util.html.Attribute attribute = this.myState.myAttributes.get("id");
        this.myState.myAttributes.remove("id");
        if (attribute != null && !attribute.getValue().isEmpty() && (state = this.myStateStack.peek()) != null) {
            state.myAttributes.addValue("id", attribute.getValue());
        }
    }

    private void transferToParentExcept(String ... excludes) {
        if (this.myStateStack.isEmpty()) {
            throw new IllegalStateException("transferIdToParent with an empty stack");
        }
        Attributes attributes = new Attributes(this.myState.myAttributes);
        this.myState.myAttributes.clear();
        for (String exclude : excludes) {
            this.myState.myAttributes.addValue(attributes.get(exclude));
            attributes.remove(exclude);
        }
        if (!attributes.isEmpty()) {
            State parentState = this.myStateStack.peek();
            for (String attrName : attributes.keySet()) {
                parentState.myAttributes.addValue(attributes.get(attrName));
            }
        }
    }

    private void transferToParentOnly(String ... includes) {
        if (this.myStateStack.isEmpty()) {
            throw new IllegalStateException("transferIdToParent with an empty stack");
        }
        Attributes attributes = new Attributes();
        for (String include : includes) {
            com.vladsch.flexmark.util.html.Attribute attribute = this.myState.myAttributes.get(include);
            if (attribute == null) continue;
            this.myState.myAttributes.remove(include);
            attributes.addValue(attribute);
        }
        if (!attributes.isEmpty()) {
            State parentState = this.myStateStack.peek();
            for (String attrName : attributes.keySet()) {
                parentState.myAttributes.addValue(attributes.get(attrName));
            }
        }
    }

    private void popState(LineFormattingAppendable out) {
        if (this.myStateStack.isEmpty()) {
            throw new IllegalStateException("popState with an empty stack");
        }
        if (out != null) {
            this.outputAttributes(out, "");
        }
        this.myState = this.myStateStack.pop();
    }

    private org.jsoup.nodes.Node peek() {
        if (this.myState.myIndex < this.myState.myElements.size()) {
            return this.myState.myElements.get(this.myState.myIndex);
        }
        return null;
    }

    private org.jsoup.nodes.Node peek(int skip) {
        if (this.myState.myIndex + skip >= 0 && this.myState.myIndex + skip < this.myState.myElements.size()) {
            return this.myState.myElements.get(this.myState.myIndex + skip);
        }
        return null;
    }

    private org.jsoup.nodes.Node next() {
        org.jsoup.nodes.Node next = this.peek();
        if (next != null) {
            ++this.myState.myIndex;
        }
        return next;
    }

    private void skip() {
        org.jsoup.nodes.Node next = this.peek();
        if (next != null) {
            ++this.myState.myIndex;
        }
    }

    private org.jsoup.nodes.Node next(int skip) {
        if (skip > 0) {
            org.jsoup.nodes.Node next = this.peek(skip - 1);
            if (next != null) {
                this.myState.myIndex += skip;
            }
            return next;
        }
        return this.peek();
    }

    private void skip(int skip) {
        org.jsoup.nodes.Node next;
        if (skip > 0 && (next = this.peek(skip - 1)) != null) {
            this.myState.myIndex += skip;
        }
    }

    static {
        tableCellAlignments.put(Pattern.compile("\\bleft\\b"), CellAlignment.LEFT);
        tableCellAlignments.put(Pattern.compile("\\bcenter\\b"), CellAlignment.CENTER);
        tableCellAlignments.put(Pattern.compile("\\bright\\b"), CellAlignment.RIGHT);
        tableCellAlignments.put("text-left", CellAlignment.LEFT);
        tableCellAlignments.put("text-center", CellAlignment.CENTER);
        tableCellAlignments.put("text-right", CellAlignment.RIGHT);
        specialCharsMap = new HashMap<String, String>();
        specialCharsMap.put("\u201c", "\"");
        specialCharsMap.put("\u201d", "\"");
        specialCharsMap.put("&ldquo;", "\"");
        specialCharsMap.put("&rdquo;", "\"");
        specialCharsMap.put("\u2018", "'");
        specialCharsMap.put("\u2019", "'");
        specialCharsMap.put("&lsquo;", "'");
        specialCharsMap.put("&rsquo;", "'");
        specialCharsMap.put("&apos;", "'");
        specialCharsMap.put("\u00ab", "<<");
        specialCharsMap.put("&laquo;", "<<");
        specialCharsMap.put("\u00bb", ">>");
        specialCharsMap.put("&raquo;", ">>");
        specialCharsMap.put("\u2026", "...");
        specialCharsMap.put("&hellip;", "...");
        specialCharsMap.put("\u2013", "--");
        specialCharsMap.put("&endash;", "--");
        specialCharsMap.put("\u2014", "---");
        specialCharsMap.put("&emdash;", "---");
        NUMERIC_DOT_LIST = Pattern.compile("^(\\d+)\\.\\s*$");
        NUMERIC_PAREN_LIST = Pattern.compile("^(\\d+)\\)\\s*$");
        NON_NUMERIC_DOT_LIST = Pattern.compile("^((?:(?:" + RomanNumeral.ROMAN_NUMERAL.pattern() + ")|(?:" + RomanNumeral.LOWERCASE_ROMAN_NUMERAL.pattern() + ")|[a-z]+|[A-Z]+))\\.\\s*$");
        NON_NUMERIC_PAREN_LIST = Pattern.compile("^((?:[a-z]+|[A-Z]+))\\)\\s*$");
        BULLET_LIST = Pattern.compile("^([\u00b7])\\s*$");
        ALPHA_NUMERAL = Pattern.compile("^[a-z]+|[A-Z]+$");
        TABLE_CELL_ALIGNMENT_MAP = new DataKey<Map<Object, CellAlignment>>("TABLE_CELL_ALIGNMENT_MAP", tableCellAlignments);
        explicitLinkTextTags = new HashSet();
        explicitLinkTextTags.add(TagType.IMG);
        ourTagProcessors = new HashMap<String, TagParam>();
        ourTagProcessors.put("a", TagParam.tag(TagType.A, null));
        ourTagProcessors.put("abbr", TagParam.tag(TagType.ABBR, null));
        ourTagProcessors.put("aside", TagParam.tag(TagType.ASIDE, null));
        ourTagProcessors.put("br", TagParam.tag(TagType.BR, null));
        ourTagProcessors.put("blockquote", TagParam.tag(TagType.BLOCKQUOTE, null));
        ourTagProcessors.put("caption", TagParam.tag(TagType.CAPTION, null));
        ourTagProcessors.put("code", TagParam.tag(TagType.CODE, null));
        ourTagProcessors.put("del", TagParam.tag(TagType.DEL, null));
        ourTagProcessors.put("div", TagParam.tag(TagType.DIV, null));
        ourTagProcessors.put("dd", TagParam.tag(TagType.DD, null));
        ourTagProcessors.put("dl", TagParam.tag(TagType.DL, null));
        ourTagProcessors.put("dt", TagParam.tag(TagType.DT, null));
        ourTagProcessors.put("i", TagParam.tag(TagType._EMPHASIS, null));
        ourTagProcessors.put("em", TagParam.tag(TagType._EMPHASIS, null));
        ourTagProcessors.put("h1", TagParam.tag(TagType._HEADING, 1));
        ourTagProcessors.put("h2", TagParam.tag(TagType._HEADING, 2));
        ourTagProcessors.put("h3", TagParam.tag(TagType._HEADING, 3));
        ourTagProcessors.put("h4", TagParam.tag(TagType._HEADING, 4));
        ourTagProcessors.put("h5", TagParam.tag(TagType._HEADING, 5));
        ourTagProcessors.put("h6", TagParam.tag(TagType._HEADING, 6));
        ourTagProcessors.put("hr", TagParam.tag(TagType.HR, null));
        ourTagProcessors.put("img", TagParam.tag(TagType.IMG, null));
        ourTagProcessors.put("input", TagParam.tag(TagType.INPUT, null));
        ourTagProcessors.put("ins", TagParam.tag(TagType.INS, null));
        ourTagProcessors.put("u", TagParam.tag(TagType.INS, null));
        ourTagProcessors.put("li", TagParam.tag(TagType.LI, null));
        ourTagProcessors.put("ol", TagParam.tag(TagType.OL, null));
        ourTagProcessors.put("p", TagParam.tag(TagType.P, null));
        ourTagProcessors.put("pre", TagParam.tag(TagType.PRE, null));
        ourTagProcessors.put("b", TagParam.tag(TagType._STRONG_EMPHASIS, null));
        ourTagProcessors.put("strong", TagParam.tag(TagType._STRONG_EMPHASIS, null));
        ourTagProcessors.put("strike", TagParam.tag(TagType.DEL, null));
        ourTagProcessors.put("sub", TagParam.tag(TagType.SUB, null));
        ourTagProcessors.put("sup", TagParam.tag(TagType.SUP, null));
        ourTagProcessors.put("svg", TagParam.tag(TagType.SVG, null));
        ourTagProcessors.put("table", TagParam.tag(TagType.TABLE, null));
        ourTagProcessors.put("tbody", TagParam.tag(TagType.TBODY, null));
        ourTagProcessors.put("td", TagParam.tag(TagType.TD, null));
        ourTagProcessors.put("th", TagParam.tag(TagType.TH, null));
        ourTagProcessors.put("thead", TagParam.tag(TagType.THEAD, null));
        ourTagProcessors.put("tr", TagParam.tag(TagType.TR, null));
        ourTagProcessors.put("ul", TagParam.tag(TagType.UL, null));
        ourTagProcessors.put("math", TagParam.tag(TagType.MATH, null));
        ourTagProcessors.put("#comment", TagParam.tag(TagType._COMMENT, null));
        ourTagProcessors.put("#text", TagParam.tag(TagType._TEXT, null));
        ourTagProcessors.put("kbd", TagParam.tag(TagType._WRAPPED, false));
        ourTagProcessors.put("var", TagParam.tag(TagType._WRAPPED, false));
        ourTagProcessors.put("article", TagParam.tag(TagType._UNWRAPPED, null));
        ourTagProcessors.put("address", TagParam.tag(TagType._UNWRAPPED, null));
        ourTagProcessors.put("frameset", TagParam.tag(TagType._UNWRAPPED, null));
        ourTagProcessors.put("section", TagParam.tag(TagType._UNWRAPPED, null));
        ourTagProcessors.put("span", TagParam.tag(TagType._SPAN, null));
        ourTagProcessors.put("small", TagParam.tag(TagType._UNWRAPPED, null));
        ourTagProcessors.put("iframe", TagParam.tag(TagType._UNWRAPPED, null));
    }

    private static class TagParam {
        final TagType tagType;
        final Object param;

        TagParam(TagType tagType, Object param) {
            this.tagType = tagType;
            this.param = param;
        }

        static TagParam tag(TagType tagType, Object param) {
            return new TagParam(tagType, param);
        }
    }

    static enum TagType {
        A,
        ABBR,
        ASIDE,
        BR,
        BLOCKQUOTE,
        CAPTION,
        CODE,
        DEL,
        DIV,
        DL,
        DD,
        DT,
        _EMPHASIS,
        HR,
        IMG,
        INPUT,
        INS,
        LI,
        OL,
        P,
        PRE,
        _STRONG_EMPHASIS,
        SUB,
        SUP,
        SVG,
        TABLE,
        TBODY,
        TD,
        TH,
        THEAD,
        TR,
        UL,
        _HEADING,
        _UNWRAPPED,
        _SPAN,
        _WRAPPED,
        _COMMENT,
        _TEXT,
        MATH;

    }

    private static class ListState {
        boolean isNumbered;
        int itemCount;

        ListState(boolean isNumbered) {
            this.isNumbered = isNumbered;
            this.itemCount = 0;
        }

        String getItemPrefix(HtmlParserOptions options) {
            if (this.isNumbered) {
                return String.format(Locale.US, "%d%c ", this.itemCount, Character.valueOf(options.orderedListDelimiter));
            }
            return String.format("%c ", Character.valueOf(options.unorderedListDelimiter));
        }
    }

    private static class State {
        final org.jsoup.nodes.Node myParent;
        final List<org.jsoup.nodes.Node> myElements;
        int myIndex;
        final Attributes myAttributes;
        private LinkedList<Runnable> myPrePopActions;

        State(org.jsoup.nodes.Node parent) {
            this.myParent = parent;
            this.myElements = parent.childNodes();
            this.myIndex = 0;
            this.myAttributes = new Attributes();
            this.myPrePopActions = null;
        }

        public void addPrePopAction(Runnable action) {
            if (this.myPrePopActions == null) {
                this.myPrePopActions = new LinkedList();
            }
            this.myPrePopActions.add(action);
        }

        public void runPrePopActions() {
            if (this.myPrePopActions != null) {
                int iMax;
                int i = iMax = this.myPrePopActions.size();
                while (i-- > 0) {
                    this.myPrePopActions.get(i).run();
                }
            }
        }

        public String toString() {
            return "State{myParent=" + this.myParent + ", myElements=" + this.myElements + ", myIndex=" + this.myIndex + ", myAttributes=" + this.myAttributes + '}';
        }
    }
}

