/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.anchorlink.internal;

import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ext.anchorlink.AnchorLink;
import com.vladsch.flexmark.ext.anchorlink.AnchorLinkExtension;
import com.vladsch.flexmark.ext.anchorlink.internal.AnchorLinkOptions;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class AnchorLinkNodePostProcessor
extends NodePostProcessor {
    private final AnchorLinkOptions options;

    public AnchorLinkNodePostProcessor(DataHolder options) {
        this.options = new AnchorLinkOptions(options);
    }

    @Override
    public void process(NodeTracker state, Node node) {
        if (node instanceof Heading) {
            Heading heading;
            if (node.isOrDescendantOfType(BlockQuote.class)) {
                boolean bl = false;
            }
            if ((heading = (Heading)node).getText().isNotNull()) {
                AnchorLink anchor = new AnchorLink();
                if (!this.options.wrapText) {
                    if (heading.getFirstChild() == null) {
                        anchor.setChars((BasedSequence)heading.getText().subSequence(0, 0));
                        heading.appendChild(anchor);
                    } else {
                        anchor.setChars((BasedSequence)heading.getFirstChild().getChars().subSequence(0, 0));
                        heading.getFirstChild().insertBefore(anchor);
                    }
                } else {
                    anchor.takeChildren(heading);
                    heading.appendChild(anchor);
                }
                anchor.setCharsFromContent();
                state.nodeAdded(anchor);
            }
        } else {
            boolean bl = false;
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory(DataHolder options) {
            super(false);
            if (options.get(AnchorLinkExtension.ANCHORLINKS_NO_BLOCK_QUOTE).booleanValue()) {
                this.addNodeWithExclusions(Heading.class, BlockQuote.class);
            } else {
                this.addNodes(Heading.class);
            }
        }

        @Override
        public NodePostProcessor apply(Document document) {
            return new AnchorLinkNodePostProcessor(document);
        }
    }
}

