/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.abbreviation.internal;

import com.vladsch.flexmark.ext.abbreviation.Abbreviation;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationBlock;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationRepository;
import com.vladsch.flexmark.ext.abbreviation.internal.FormatOptions;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.NodeRepositoryFormatter;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AbbreviationNodeFormatter
extends NodeRepositoryFormatter<AbbreviationRepository, AbbreviationBlock, Abbreviation> {
    public static final DataKey<Map<String, String>> ABBREVIATION_TRANSLATION_MAP = new DataKey("ABBREVIATION_TRANSLATION_MAP", new HashMap());
    private final FormatOptions options;
    private final boolean transformUnderscores;

    public AbbreviationNodeFormatter(DataHolder options) {
        super(options, ABBREVIATION_TRANSLATION_MAP);
        this.options = new FormatOptions(options);
        String transformedId = String.format(Formatter.TRANSLATION_ID_FORMAT.getFrom(options), 1);
        this.transformUnderscores = transformedId.startsWith("_") && transformedId.endsWith("_");
    }

    @Override
    public AbbreviationRepository getRepository(DataHolder options) {
        return AbbreviationExtension.ABBREVIATIONS.getFrom(options);
    }

    @Override
    public ElementPlacement getReferencePlacement() {
        return this.options.abbreviationsPlacement;
    }

    @Override
    public ElementPlacementSort getReferenceSort() {
        return this.options.abbreviationsSort;
    }

    @Override
    public String modifyTransformedReference(String transformedText, NodeFormatterContext context) {
        if (this.transformUnderscores && context.isTransformingText()) {
            if (transformedText.startsWith("-") && transformedText.endsWith("-")) {
                transformedText = "_" + transformedText.substring(1, transformedText.length() - 1) + "_";
            } else if (transformedText.startsWith("_") && transformedText.endsWith("_")) {
                transformedText = "-" + transformedText.substring(1, transformedText.length() - 1) + "-";
            }
        }
        return transformedText;
    }

    @Override
    public void renderReferenceBlock(AbbreviationBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append(node.getOpeningMarker()).append(this.transformReferenceId(node.getText().toString(), context)).append(node.getClosingMarker()).append(' ');
        markdown.appendTranslating(node.getAbbreviation()).line();
    }

    @Override
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler<Abbreviation>(Abbreviation.class, new CustomNodeFormatter<Abbreviation>(){

            @Override
            public void render(Abbreviation node, NodeFormatterContext context, MarkdownWriter markdown) {
                AbbreviationNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<AbbreviationBlock>(AbbreviationBlock.class, new CustomNodeFormatter<AbbreviationBlock>(){

            @Override
            public void render(AbbreviationBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                AbbreviationNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    @Override
    public Set<Class<?>> getNodeClasses() {
        if (this.options.abbreviationsPlacement != ElementPlacement.AS_IS && this.options.abbreviationsSort != ElementPlacementSort.SORT_UNUSED_LAST) {
            return null;
        }
        return new HashSet(Arrays.asList(Abbreviation.class));
    }

    private void render(AbbreviationBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference(node, context, markdown);
    }

    private void render(Abbreviation node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.isTransformingText()) {
            String referenceId = this.transformReferenceId(node.getChars().toString(), context);
            markdown.append(referenceId);
        } else {
            markdown.append(node.getChars());
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        @Override
        public NodeFormatter create(DataHolder options) {
            return new AbbreviationNodeFormatter(options);
        }
    }
}

